/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.DeflatedChunkReader;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DeflatedChunksSet {
    protected byte[] row;
    private int rowfilled;
    private int rowlen;
    private int rown;
    State state;
    final Inflater inf;
    private final boolean infOwn;
    private DeflatedChunkReader curChunk;
    private boolean callbackMode = true;
    private int nFedBytes = 0;
    public final String chunkid;

    public DeflatedChunksSet(String chunkid, int initialRowLen, int maxRowLen, Inflater inflater, byte[] buffer) {
        this.chunkid = chunkid;
        this.rowlen = initialRowLen;
        Inflater inflater2 = this.inf = inflater != null ? inflater : new Inflater();
        if (inflater != null) {
            this.inf.reset();
            this.infOwn = false;
        } else {
            this.infOwn = true;
        }
        if (initialRowLen < 1 || maxRowLen < initialRowLen) {
            throw new PngjException("bad inital row len " + initialRowLen);
        }
        this.row = buffer != null && buffer.length >= initialRowLen ? buffer : new byte[maxRowLen];
        this.state = State.WAITING;
        this.rown = -1;
        this.prepareForNextRow(initialRowLen);
    }

    public DeflatedChunksSet(String chunkid, int initialRowLen, int maxRowLen) {
        this(chunkid, initialRowLen, maxRowLen, null, null);
    }

    protected void appendNewChunk(DeflatedChunkReader cr) {
        if (!this.chunkid.equals(cr.getChunkRaw().id)) {
            throw new PngjInputException("Bad chunk inside IdatSet, id:" + cr.getChunkRaw().id + ", expected:" + this.chunkid);
        }
        this.curChunk = cr;
    }

    protected void processBytes(byte[] buf, int off, int len) {
        this.nFedBytes += len;
        if (len < 1 || this.state.isFinished()) {
            return;
        }
        if (this.state == State.READY) {
            throw new PngjInputException("this should only be called if waitingForMoreInput");
        }
        if (this.inf.needsDictionary() || !this.inf.needsInput()) {
            throw new RuntimeException("should not happen");
        }
        this.inf.setInput(buf, off, len);
        this.inflateData();
    }

    private void inflateData() {
        int ninflated = 0;
        if (this.row == null || this.row.length < this.rowlen) {
            this.row = new byte[this.rowlen];
        }
        if (this.rowfilled < this.rowlen) {
            try {
                ninflated = this.inf.inflate(this.row, this.rowfilled, this.rowlen - this.rowfilled);
            }
            catch (DataFormatException e) {
                throw new PngjInputException("error decompressing zlib stream ", e);
            }
            this.rowfilled += ninflated;
        }
        State nextstate = null;
        nextstate = this.rowfilled == this.rowlen ? State.READY : (!this.inf.finished() ? State.WAITING : (this.rowfilled > 0 ? State.READY : State.DONE));
        this.state = nextstate;
        if (this.state == State.READY) {
            this.preProcessRow();
            if (this.isCallbackMode()) {
                int nextRowLen = this.processRowCallback();
                this.prepareForNextRow(nextRowLen);
            }
        }
    }

    protected void preProcessRow() {
    }

    protected int processRowCallback() {
        throw new PngjInputException("not implemented");
    }

    public byte[] getInflatedRow() {
        return this.row;
    }

    protected void prepareForNextRow(int len) {
        this.rowfilled = 0;
        ++this.rown;
        if (len < 1) {
            this.rowlen = 0;
            this.state = State.DONE;
        } else if (this.inf.finished()) {
            this.rowlen = 0;
            this.state = State.DONE;
        } else {
            this.rowlen = len;
            this.inflateData();
        }
    }

    public boolean isWaitingForMoreInput() {
        return this.state == State.WAITING;
    }

    public boolean isRowReady() {
        return this.state == State.READY;
    }

    public boolean isDone() {
        return this.state.isFinished();
    }

    public void end() {
        try {
            if (!this.state.isFinished()) {
                this.state = State.DONE;
            }
            if (this.infOwn) {
                this.inf.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRowLen() {
        return this.rowlen;
    }

    public int getRowFilled() {
        return this.rowfilled;
    }

    public int getRown() {
        return this.rown;
    }

    public boolean allowOtherChunksInBetween(String id) {
        return false;
    }

    public boolean isCallbackMode() {
        return this.callbackMode;
    }

    public void setCallbackMode(boolean callbackMode) {
        this.callbackMode = callbackMode;
    }

    public int getnFedBytes() {
        return this.nFedBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("idatSet : " + this.curChunk.getChunkRaw().id + " state=" + (Object)((Object)this.state) + " rows=" + this.rown);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WAITING,
        READY,
        DONE;


        public boolean isFinished() {
            return this == DONE;
        }
    }
}

