/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.beans.MapModel;
import freemarker.ext.beans.MemberAccessPolicy;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.util.ClassProperties;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.RequestInfo;
import org.geoserver.template.TemplateUtils;
import org.geotools.util.logging.Logging;

public class ObjectToMapWrapper<T>
extends BeansWrapper {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.rest");
    private BeansWrapper wrapper = null;
    Class<T> clazz;
    Collection<Class<?>> classesToExpand;

    public ObjectToMapWrapper(Class<T> clazz) {
        this(clazz, Collections.emptyList());
    }

    public ObjectToMapWrapper(Class<T> clazz, Collection<Class<?>> classesToExpand) {
        super(TemplateUtils.FM_VERSION);
        this.clazz = clazz;
        this.classesToExpand = classesToExpand;
    }

    public void setMemberAccessPolicy(MemberAccessPolicy memberAccessPolicy) {
        super.setMemberAccessPolicy(memberAccessPolicy);
        this.wrapper = TemplateUtils.getSafeWrapper(null, (MemberAccessPolicy)memberAccessPolicy, null);
    }

    public TemplateModel wrap(Object object) throws TemplateModelException {
        Collection c;
        if (object instanceof SimpleHash) {
            return (SimpleHash)object;
        }
        if (object instanceof Collection && ((c = (Collection)object).isEmpty() || this.clazz.isAssignableFrom(c.iterator().next().getClass()))) {
            SimpleHash hash = new SimpleHash((ObjectWrapper)this.wrapper);
            hash.put("values", (Object)new CollectionModel(c, (BeansWrapper)this));
            this.setRequestInfo(hash);
            this.wrapInternal(hash, (Collection)object);
            return hash;
        }
        if (object != null && this.clazz.isAssignableFrom(object.getClass())) {
            Map<String, Object> map = this.objectToMap(object, this.clazz);
            SimpleHash model = new SimpleHash((ObjectWrapper)this.wrapper);
            model.put("properties", (Object)new MapModel(map, (BeansWrapper)this));
            model.put("className", (Object)this.clazz.getSimpleName());
            this.setRequestInfo(model);
            this.wrapInternal(map, model, object);
            return model;
        }
        return super.wrap(object);
    }

    protected Map<String, Object> objectToMap(Object object, Class<?> clazz) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ClassProperties cp = OwsUtils.getClassProperties(clazz);
        for (String p : cp.properties()) {
            Object value;
            if ("Class".equals(p)) continue;
            try {
                value = OwsUtils.get((Object)object, (String)p);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not resolve property " + p + " of bean " + object, e);
                value = "** Failed to retrieve value of property " + p + ". Error message is: " + e.getMessage() + "**";
            }
            if (value == null) {
                value = "null";
            }
            String key = Character.toLowerCase(p.charAt(0)) + p.substring(1);
            Class<?> valueClass = this.getClassForUnwrapping(value);
            if (value instanceof Collection) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (Object o : (Collection)value) {
                    valueClass = this.getClassForUnwrapping(o);
                    if (valueClass == null) {
                        values.add(o == null ? "" : o.toString());
                        continue;
                    }
                    values.add(this.objectToMap(o, valueClass));
                }
                map.put(key, new CollectionModel(values, (BeansWrapper)this));
                continue;
            }
            if (valueClass == null) {
                map.put(key, value.toString());
                continue;
            }
            map.put(key, this.objectToMap(value, valueClass));
        }
        return map;
    }

    private Class<?> getClassForUnwrapping(Object o) {
        for (Class<?> clazz : this.classesToExpand) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return clazz;
        }
        return null;
    }

    protected void setRequestInfo(SimpleHash model) throws TemplateModelException {
        RequestInfo requestInfo = RequestInfo.get();
        if (model.get("page") == null && requestInfo != null) {
            model.put("page", (Object)requestInfo);
        }
    }

    protected void wrapInternal(Map<String, Object> properties, SimpleHash model, T object) {
    }

    protected void wrapInternal(SimpleHash model, Collection<T> object) {
    }

    protected Map<String, Object> hashToProperties(SimpleHash model) {
        try {
            return model.toMap();
        }
        catch (TemplateModelException e) {
            throw new RuntimeException(e);
        }
    }
}

