/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.DispatcherCallback;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.HandlerInterceptor;

public class CallbackInterceptor
implements HandlerInterceptor {
    static final Logger LOGGER = Logging.getLogger(CallbackInterceptor.class);

    List<DispatcherCallback> getCallbacks() {
        return GeoServerExtensions.extensions(DispatcherCallback.class);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List<DispatcherCallback> callbacks = this.getCallbacks();
        for (DispatcherCallback callback : callbacks) {
            callback.init(request, response);
        }
        for (DispatcherCallback callback : callbacks) {
            callback.dispatched(request, response, handler);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<DispatcherCallback> callbacks = this.getCallbacks();
        if (ex != null) {
            for (DispatcherCallback callback : callbacks) {
                callback.exception(request, response, ex);
            }
        }
        for (DispatcherCallback callback : callbacks) {
            try {
                callback.finished(request, response);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Callback threw exception on finish", e);
            }
        }
    }
}

