/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms.xml;

import org.geotools.ows.wms.xml.Extent;

public class Dimension {
    protected String name;
    protected String units;
    protected String unitSymbol;
    protected boolean current;
    protected Extent extent = null;

    public Dimension(String name, String units, String unitSymbol) {
        Dimension.validateArguments(name, units);
        this.name = name;
        this.units = units;
        this.unitSymbol = unitSymbol;
    }

    public Dimension(String name, String units) {
        Dimension.validateArguments(name, units);
        this.name = name;
        this.units = units;
    }

    private static void validateArguments(String name, String units) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Error creating Dimension: parameter 'name' must not be null!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Error creating Dimension: parameter 'name' must not be empty!");
        }
        if (units == null) {
            throw new IllegalArgumentException("Error creating Dimension: parameter 'units' must not be null!");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    public void setUnitSymbol(String unitSymbol) {
        this.unitSymbol = unitSymbol;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public String toString() {
        return this.name + ", " + this.units + "(" + this.unitSymbol + ")";
    }
}

