/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridUtil;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.ProxyLayer;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.TextMime;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.wms.WMSGetCapabilities;
import org.geowebcache.service.wms.WMSTileFuser;
import org.geowebcache.service.wms.WMSUtilities;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;

public class WMSService
extends Service {
    public static final String GEOWEBCACHE_WMS_PROXY_REQUEST_WHITELIST = "GEOWEBCACHE_WMS_PROXY_REQUEST_WHITELIST";
    public static final String SERVICE_WMS = "wms";
    static final String SERVICE_PATH = "/service/wms";
    private static Logger log = Logging.getLogger((String)WMSService.class.getName());
    private boolean fullWMS = false;
    private boolean proxyRequests = false;
    private boolean proxyNonTiledRequests = false;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private RuntimeStats stats;
    private URLMangler urlMangler = new NullURLMangler();
    private GeoWebCacheDispatcher controller = null;
    private String hintsConfig = "DEFAULT";
    private WMSUtilities utility;
    private SecurityDispatcher securityDispatcher;

    protected WMSService() {
        super(SERVICE_WMS);
    }

    public WMSService(StorageBroker sb, TileLayerDispatcher tld, RuntimeStats stats) {
        super(SERVICE_WMS);
        this.sb = sb;
        this.tld = tld;
        this.stats = stats;
    }

    public WMSService(StorageBroker sb, TileLayerDispatcher tld, RuntimeStats stats, URLMangler urlMangler, GeoWebCacheDispatcher controller) {
        super(SERVICE_WMS);
        this.sb = sb;
        this.tld = tld;
        this.stats = stats;
        this.urlMangler = urlMangler;
        this.controller = controller;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        long[] tileIndex;
        GridSubset gridSubset;
        BoundingBox bbox;
        MimeType mimeType;
        String req;
        String encoding = request.getCharacterEncoding();
        Map requestParameterMap = request.getParameterMap();
        String[] keys = new String[]{"layers", "request", "tiled", "cached", "metatiled", "width", "height"};
        Map values = ServletUtils.selectedStringsFromMap((Map)requestParameterMap, (String)encoding, (String[])keys);
        String layers = (String)values.get("layers");
        TileLayer tileLayer = null;
        if (layers != null) {
            tileLayer = this.tld.getTileLayer(layers);
        }
        if ((req = (String)values.get("request")) != null && !req.equalsIgnoreCase("getmap")) {
            if (layers == null || layers.length() == 0) {
                layers = ServletUtils.stringFromMap((Map)requestParameterMap, (String)encoding, (String)"layer");
                values.put("LAYERS", layers);
                if (layers != null) {
                    tileLayer = this.tld.getTileLayer(layers);
                }
            }
            Map filteringParameters = null;
            if (tileLayer != null) {
                filteringParameters = tileLayer.getModifiableParameters(requestParameterMap, encoding);
            }
            ConveyorTile tile = new ConveyorTile(this.sb, layers, null, null, (MimeType)ImageMime.png, filteringParameters, request, response);
            tile.setHint(req.toLowerCase());
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (layers == null) {
            throw new ServiceException("Unable to parse layers parameter from request.");
        }
        boolean tiled = Boolean.valueOf((String)values.get("tiled"));
        if (this.proxyNonTiledRequests && tiled) {
            ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        String[] paramKeys = new String[]{"format", "srs", "bbox"};
        Map paramValues = ServletUtils.selectedStringsFromMap((Map)requestParameterMap, (String)encoding, (String[])paramKeys);
        Map fullParameters = tileLayer.getModifiableParameters(requestParameterMap, encoding);
        String format = (String)paramValues.get("format");
        try {
            mimeType = MimeType.createFromFormat((String)format);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format, " + format);
        }
        String requestSrs = (String)paramValues.get("srs");
        if (requestSrs == null) {
            throw new ServiceException("No SRS specified");
        }
        SRS srs = SRS.getSRS((String)requestSrs);
        String requestBbox = (String)paramValues.get("bbox");
        try {
            bbox = new BoundingBox(requestBbox);
            if (bbox == null || !bbox.isSane()) {
                throw new ServiceException("The bounding box parameter (" + requestBbox + ") is missing or not sane");
            }
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("The bounding box parameter (" + requestBbox + ") is invalid");
        }
        int tileWidth = Integer.parseInt((String)values.get("width"));
        int tileHeight = Integer.parseInt((String)values.get("height"));
        List crsMatchingSubsets = tileLayer.getGridSubsetsForSRS(srs);
        if (crsMatchingSubsets.isEmpty()) {
            throw new ServiceException("Unable to match requested SRS " + srs + " to those supported by layer");
        }
        long[] tileIndexTarget = new long[3];
        GridSubset bestMatch = GridUtil.findBestMatchingGrid((BoundingBox)bbox, (List)crsMatchingSubsets, (Integer)tileWidth, (Integer)tileHeight, (long[])tileIndexTarget);
        if (bestMatch == null) {
            gridSubset = (GridSubset)crsMatchingSubsets.get(0);
            tileIndexTarget = null;
        } else {
            gridSubset = bestMatch;
        }
        if (this.fullWMS) {
            tileIndex = null;
            if (tileIndexTarget == null) {
                try {
                    tileIndex = gridSubset.closestIndex(bbox);
                }
                catch (GridMismatchException gridMismatchException) {}
            } else {
                tileIndex = tileIndexTarget;
            }
            if (tileIndex == null || gridSubset.getTileWidth() != tileWidth || gridSubset.getTileHeight() != tileHeight || !bbox.equals(gridSubset.boundsFromIndex(tileIndex), 0.02)) {
                log.fine("Recombinining tiles to respond to WMS request");
                ConveyorTile tile = new ConveyorTile(this.sb, layers, request, response);
                tile.setHint("getmap");
                tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
                return tile;
            }
        }
        tileIndex = tileIndexTarget == null ? gridSubset.closestIndex(bbox) : tileIndexTarget;
        gridSubset.checkTileDimensions(tileWidth, tileHeight);
        return new ConveyorTile(this.sb, layers, gridSubset.getName(), tileIndex, mimeType, fullParameters, request, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        ConveyorTile tile = (ConveyorTile)conv;
        String servletPrefix = null;
        if (this.controller != null) {
            servletPrefix = this.controller.getServletPrefix();
        }
        String servletBase = ServletUtils.getServletBaseURL((HttpServletRequest)conv.servletReq, (String)servletPrefix);
        String context = ServletUtils.getServletContextPath((HttpServletRequest)conv.servletReq, (String)SERVICE_PATH, (String)servletPrefix);
        if (tile.getHint() == null) throw new GeoWebCacheException("The WMS Service would love to help, but has no idea what you're trying to do?Please include request URL if you file a bug report.");
        if (tile.getHint().equalsIgnoreCase("getcapabilities")) {
            WMSGetCapabilities wmsCap = new WMSGetCapabilities(this.tld, tile.servletReq, servletBase, context, this.urlMangler);
            wmsCap.writeResponse(tile.servletResp);
            return;
        } else if (tile.getHint().equalsIgnoreCase("getmap")) {
            this.getSecurityDispatcher().checkSecurity(tile);
            WMSTileFuser wmsFuser = this.getFuser(tile.servletReq);
            try {
                wmsFuser.writeResponse(tile.servletResp, this.stats);
                return;
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.getMessage(), e);
                return;
            }
        } else if (tile.getHint().equalsIgnoreCase("getfeatureinfo")) {
            this.getSecurityDispatcher().checkSecurity(tile);
            this.handleGetFeatureInfo(tile);
            return;
        } else {
            this.getSecurityDispatcher().checkSecurity(tile);
            this.checkProxyRequest(tile.getHint());
            TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
            if (tl == null) {
                throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
            }
            if (!(tl instanceof ProxyLayer)) throw new GeoWebCacheException(tile.getLayerId() + " cannot cascade WMS requests.");
            ((ProxyLayer)tl).proxyRequest(tile);
        }
    }

    protected WMSTileFuser getFuser(HttpServletRequest servletReq) throws GeoWebCacheException {
        WMSTileFuser wmsFuser = new WMSTileFuser(this.tld, this.sb, servletReq);
        wmsFuser.setSecurityDispatcher(this.getSecurityDispatcher());
        wmsFuser.setApplicationContext(this.utility.getApplicationContext());
        wmsFuser.setHintsConfiguration(this.hintsConfig);
        return wmsFuser;
    }

    private void handleGetFeatureInfo(ConveyorTile tile) throws GeoWebCacheException {
        int width;
        int height;
        int y;
        int x;
        Object mimeType;
        TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        String[] keys = new String[]{"x", "y", "srs", "info_format", "bbox", "height", "width"};
        Map values = ServletUtils.selectedStringsFromMap((Map)tile.servletReq.getParameterMap(), (String)tile.servletReq.getCharacterEncoding(), (String[])keys);
        GridSubset gridSubset = (GridSubset)tl.getGridSubsetsForSRS(SRS.getSRS((String)((String)values.get("srs")))).iterator().next();
        BoundingBox bbox = null;
        try {
            bbox = new BoundingBox((String)values.get("bbox"));
        }
        catch (NumberFormatException nfe) {
            log.fine(nfe.getMessage());
        }
        if (bbox == null || !bbox.isSane()) {
            throw new ServiceException("The bounding box parameter (" + (String)values.get("srs") + ") is missing or not sane");
        }
        try {
            mimeType = MimeType.createFromFormat((String)((String)values.get("info_format")));
        }
        catch (MimeException me) {
            throw new GeoWebCacheException("The info_format parameter (" + (String)values.get("info_format") + ")is missing or not recognized.");
        }
        if (mimeType == null) {
            mimeType = tl.getInfoMimeTypes().contains(TextMime.txt) ? TextMime.txt : (MimeType)tl.getInfoMimeTypes().get(0);
        }
        if (!tl.getInfoMimeTypes().contains(mimeType)) {
            throw new GeoWebCacheException("The info_format parameter (" + (String)values.get("info_format") + ") is not supported.");
        }
        ConveyorTile gfiConv = new ConveyorTile(this.sb, tl.getName(), gridSubset.getName(), null, mimeType, tile.getFilteringParameters(), tile.servletReq, tile.servletResp);
        gfiConv.setTileLayer(tl);
        try {
            x = Integer.parseInt((String)values.get("x"));
            y = Integer.parseInt((String)values.get("y"));
        }
        catch (NumberFormatException nfe) {
            throw new GeoWebCacheException("The parameters for x and y must both be positive integers.");
        }
        try {
            height = Integer.parseInt((String)values.get("height"));
            width = Integer.parseInt((String)values.get("width"));
        }
        catch (NumberFormatException nfe) {
            throw new GeoWebCacheException("The parameters for height and width must both be positive integers.");
        }
        Resource data = tl.getFeatureInfo(gfiConv, bbox, height, width, x, y);
        try {
            tile.servletResp.setContentType(mimeType.getMimeType());
            ServletOutputStream outputStream = tile.servletResp.getOutputStream();
            data.transferTo(Channels.newChannel((OutputStream)outputStream));
            outputStream.flush();
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.log(Level.SEVERE, ioe.getMessage());
        }
    }

    public void setFullWMS(String trueFalse) {
        ArrayList configs = new ArrayList(GeoWebCacheExtensions.extensions(TileLayerConfiguration.class));
        ServerConfiguration gwcXMLconfig = null;
        for (BaseConfiguration config : configs) {
            if (!(config instanceof XMLConfiguration)) continue;
            gwcXMLconfig = (ServerConfiguration)config;
            break;
        }
        Boolean wmsFull = null;
        if (gwcXMLconfig != null) {
            wmsFull = gwcXMLconfig.isFullWMS();
        }
        this.fullWMS = wmsFull != null ? wmsFull : Boolean.parseBoolean(trueFalse);
        if (this.fullWMS) {
            log.config("Will recombine tiles for non-tiling clients.");
        } else {
            log.config("Will NOT recombine tiles for non-tiling clients.");
        }
    }

    public void setProxyRequests(String trueFalse) {
        this.proxyRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyRequests) {
            log.config("Will proxy requests to backend that are not getmap or getcapabilities.");
        } else {
            log.config("Will NOT proxy non-getMap requests to backend.");
        }
    }

    public void setProxyNonTiledRequests(String trueFalse) {
        this.proxyNonTiledRequests = Boolean.parseBoolean(trueFalse);
        if (this.proxyNonTiledRequests) {
            log.info("Will proxy requests that miss tiled=true to backend.");
        } else {
            log.info("Will NOT proxy requests that miss tiled=true to backend.");
        }
    }

    public void setHintsConfig(String hintsConfig) {
        this.hintsConfig = hintsConfig;
    }

    public void setUtility(WMSUtilities utility) {
        this.utility = utility;
    }

    protected Collection<String> getDefaultProxyRequestWhitelist() {
        if (this.getSecurityDispatcher().isSecurityEnabled()) {
            return Arrays.asList("getlegendgraphic");
        }
        return Arrays.asList("*");
    }

    protected Collection<String> getProxyRequestWhitelist() {
        return Optional.ofNullable(GeoWebCacheExtensions.getProperty((String)GEOWEBCACHE_WMS_PROXY_REQUEST_WHITELIST)).map(list -> list.split(";")).map(Arrays::stream).map(stream -> stream.map(String::toLowerCase).map(String::trim).collect(Collectors.toList())).map(x -> x).orElse(this.getDefaultProxyRequestWhitelist());
    }

    protected void checkProxyRequest(String request) {
        if (this.getProxyRequestWhitelist().stream().noneMatch(pattern -> pattern.equals("*") || pattern.equals(request))) {
            throw new SecurityException("WMS Request " + request + " is not on request proxy whitelist");
        }
    }

    public void setSecurityDispatcher(SecurityDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    protected SecurityDispatcher getSecurityDispatcher() {
        return this.securityDispatcher;
    }
}

