/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io.codec;

import ar.com.hjg.pngj.FilterType;
import it.geosolutions.imageio.plugins.png.PNGWriter;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.codec.ImageEncoderImpl;
import org.geowebcache.io.codec.ImageIOInitializer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;

public class PNGImageEncoder
extends ImageEncoderImpl {
    private static final String FILTER_TYPE = "filterType";
    private static final Logger LOGGER = Logging.getLogger((String)PNGImageEncoder.class.getName());
    private static List<String> supportedMimeTypes = new ArrayList<String>();
    private boolean disablePNG;
    private final boolean isAggressiveSupported;
    private static final float DEFAULT_QUALITY = 1.0f;
    private final float quality;

    public PNGImageEncoder(boolean aggressiveOutputStreamOptimization, Float quality, List<String> writerSpi, Map<String, String> inputParams, boolean disablePNG, ImageIOInitializer initializer) {
        super(aggressiveOutputStreamOptimization, supportedMimeTypes, writerSpi, inputParams, initializer);
        this.quality = quality != null ? quality.floatValue() : 1.0f;
        this.disablePNG = disablePNG;
        this.isAggressiveSupported = !this.disablePNG;
    }

    @Override
    public boolean isAggressiveOutputStreamSupported() {
        return super.isAggressiveOutputStreamSupported() && this.isAggressiveSupported;
    }

    @Override
    public void encode(RenderedImage image, Object destination, boolean aggressiveOutputStreamOptimization, MimeType type, Map<String, ?> map) throws Exception {
        block18: {
            if (!this.isAggressiveOutputStreamSupported() && aggressiveOutputStreamOptimization) {
                throw new UnsupportedOperationException("Operation not supported");
            }
            if (this.disablePNG) {
                super.encode(image, destination, aggressiveOutputStreamOptimization, type, map);
            } else {
                PNGWriter writer = new PNGWriter();
                OutputStream stream = null;
                try {
                    if (destination instanceof OutputStream) {
                        boolean isScanlinePresent = writer.isScanlineSupported(image);
                        if (!isScanlinePresent) {
                            image = new ImageWorker(image).rescaleToBytes().forceComponentColorModel().getRenderedImage();
                        }
                        Object filterObj = null;
                        if (map != null) {
                            filterObj = map.get(FILTER_TYPE);
                        }
                        FilterType filter = null;
                        filter = filterObj == null || !(filterObj instanceof FilterType) ? FilterType.FILTER_NONE : (FilterType)filterObj;
                        stream = (OutputStream)destination;
                        ImageEncoderImpl.WriteHelper helper = this.getHelper();
                        RenderedImage finalImage = image;
                        if (helper != null) {
                            finalImage = helper.prepareImage(image, type);
                        }
                        writer.writePNG(finalImage, stream, this.quality, filter);
                        break block18;
                    }
                    throw new IllegalArgumentException("Only an OutputStream can be provided to the PNGEncoder");
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    throw e;
                }
                finally {
                    if (writer != null) {
                        writer = null;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        }
                        stream = null;
                    }
                }
            }
        }
    }

    public boolean isDisablePNG() {
        return this.disablePNG;
    }

    static {
        supportedMimeTypes.add(ImageMime.png.getMimeType());
        supportedMimeTypes.add(ImageMime.png8.getMimeType());
        supportedMimeTypes.add(ImageMime.png24.getMimeType());
        supportedMimeTypes.add(ImageMime.png_24.getMimeType());
    }
}

