/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.Reader;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.WFSURIHandler;
import org.geoserver.wfs.xml.WFSXmlUtils;
import org.geotools.util.Version;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.xml.sax.helpers.NamespaceSupport;

public class WfsXmlReader
extends XmlRequestReader {
    Configuration configuration;
    GeoServer geoServer;
    EntityResolverProvider entityResolverProvider;

    public WfsXmlReader(String element, Configuration configuration, GeoServer geoServer) {
        this(element, configuration, geoServer, "wfs");
    }

    protected WfsXmlReader(String element, Configuration configuration, GeoServer geoServer, String serviceId) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.0.0"), serviceId);
        this.configuration = configuration;
        this.geoServer = geoServer;
        this.entityResolverProvider = new EntityResolverProvider(geoServer);
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Catalog catalog = this.geoServer.getCatalog();
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        Parser parser = new Parser(this.configuration);
        parser.setEntityResolver(this.entityResolverProvider.getEntityResolver());
        parser.getNamespaces().add((NamespaceSupport)new CatalogNamespaceSupport(catalog));
        parser.setValidating(strict.booleanValue());
        WFSURIHandler.addToParser(this.geoServer, parser);
        parser.setEntityExpansionLimit(WFSXmlUtils.getEntityExpansionLimitConfiguration());
        Object parsed = null;
        try {
            parsed = parser.parse(reader);
        }
        catch (Exception e) {
            throw this.cleanException(e);
        }
        if (strict.booleanValue() && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

