/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.tms.TMSDocumentFactory;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;

public class TMSService
extends Service {
    public static final String SERVICE_TMS = "tms";
    private static final String FLIP_Y = "FLIPY";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private RuntimeStats stats;
    private GeoWebCacheDispatcher controller = null;
    private TMSDocumentFactory tmsFactory;

    protected TMSService() {
        super(SERVICE_TMS);
    }

    public TMSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats, URLMangler urlMangler, GeoWebCacheDispatcher controller) {
        this(sb, stats, controller, new TMSDocumentFactory(tld, gsb, urlMangler));
    }

    public TMSService(StorageBroker sb, RuntimeStats stats, GeoWebCacheDispatcher controller, TMSDocumentFactory tmsFactory) {
        super(SERVICE_TMS);
        this.sb = sb;
        this.stats = stats;
        this.controller = controller;
        this.tmsFactory = tmsFactory;
        if (tmsFactory == null) {
            throw new IllegalArgumentException("Specified TMSFactory should not be null ");
        }
        this.tld = tmsFactory.tld;
    }

    public TMSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats) {
        this(sb, tld, gsb, stats, (URLMangler)new NullURLMangler(), null);
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String pathInfo = request.getPathInfo();
        Optional<Map<String, String>> possibleSplit = TMSService.splitParams(request);
        if (possibleSplit.isPresent()) {
            Map<String, String> split = possibleSplit.get();
            long[] gridLoc = new long[3];
            try {
                gridLoc[0] = Integer.parseInt(split.get("x"));
                gridLoc[1] = Integer.parseInt(split.get("y"));
                gridLoc[2] = Integer.parseInt(split.get("z"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("Unable to parse number " + nfe.getMessage() + " from " + pathInfo);
            }
            String layerId = split.get("layerId");
            String gridSetId = split.get("gridSetId");
            if (Objects.isNull(gridSetId)) {
                gridSetId = (String)this.tld.getTileLayer(layerId).getGridSubsets().iterator().next();
            }
            MimeType mimeType = null;
            String fileExtension = split.get("fileExtension");
            try {
                mimeType = MimeType.createFromExtension((String)fileExtension);
                if (mimeType == null) {
                    throw new HttpErrorCodeException(400, "Unsupported format: " + fileExtension);
                }
            }
            catch (MimeException me) {
                throw new ServiceException("Unable to determine requested format based on extension " + fileExtension);
            }
            try {
                TileLayer tileLayer = this.tld.getTileLayer(layerId);
                GridSubset gridSubset = tileLayer.getGridSubset(gridSetId);
                if (gridSubset == null) {
                    throw new HttpErrorCodeException(400, "Unsupported gridset: " + gridSetId);
                }
                if (this.hasFlipY(request)) {
                    long tilesHigh = gridSubset.getNumTilesHigh((int)gridLoc[2]);
                    gridLoc[1] = tilesHigh - gridLoc[1] - 1L;
                }
                gridSubset.checkCoverage(gridLoc);
            }
            catch (OutsideCoverageException e) {
                throw new HttpErrorCodeException(404, e.getMessage(), (Throwable)e);
            }
            catch (GeoWebCacheException e) {
                throw new HttpErrorCodeException(400, e.getMessage(), (Throwable)e);
            }
            ConveyorTile ret = new ConveyorTile(this.sb, layerId, gridSetId, gridLoc, mimeType, null, request, response);
            return ret;
        }
        ConveyorTile tile = new ConveyorTile(this.sb, null, request, response);
        tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
        return tile;
    }

    private boolean hasFlipY(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null) {
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                if (!FLIP_Y.equalsIgnoreCase(name)) continue;
                String flipY = request.getParameter(name);
                return Boolean.parseBoolean(flipY);
            }
        }
        return false;
    }

    public static Optional<Map<String, String>> splitParams(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        pathInfo = pathInfo.substring(pathInfo.indexOf("tms/1.0.0"));
        String[] params = pathInfo.split("/");
        int paramsLength = params.length;
        HashMap<String, String> parsed = new HashMap<String, String>();
        if (params.length < 4) {
            return Optional.empty();
        }
        String[] yExt = params[paramsLength - 1].split("\\.");
        parsed.put("x", params[paramsLength - 2]);
        parsed.put("y", yExt[0]);
        parsed.put("z", params[paramsLength - 3]);
        String layerNameAndSRS = params[2];
        String[] lsf = ServletUtils.URLDecode((String)layerNameAndSRS, (String)request.getCharacterEncoding()).split("@");
        parsed.put("layerId", lsf[0]);
        if (lsf.length >= 3) {
            parsed.put("gridSetId", lsf[1]);
            parsed.put("format", lsf[2]);
        }
        parsed.put("fileExtension", yExt[1]);
        return Optional.of(parsed);
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        String pathInfo = conv.servletReq.getPathInfo();
        pathInfo = pathInfo.substring(pathInfo.indexOf("tms/1.0.0"));
        String[] params = pathInfo.split("/");
        int paramsLength = params.length;
        String servletPrefix = null;
        if (this.controller != null) {
            servletPrefix = this.controller.getServletPrefix();
        }
        String servletBase = ServletUtils.getServletBaseURL((HttpServletRequest)conv.servletReq, (String)servletPrefix);
        String context = ServletUtils.getServletContextPath((HttpServletRequest)conv.servletReq, (String)"service/tms/1.0.0", (String)servletPrefix);
        Charset encoding = StandardCharsets.UTF_8;
        String ret = null;
        if (paramsLength < 2) {
            throw new GeoWebCacheException("Path is too short to be a valid TMS path");
        }
        if (paramsLength == 2) {
            String version = params[1];
            if (!version.equals("1.0.0")) {
                throw new GeoWebCacheException("Unknown version " + version + ", only 1.0.0 is supported.");
            }
            ret = this.tmsFactory.getTileMapServiceDoc(servletBase, context);
        } else {
            String layerNameAndSRS = params[2];
            String layerAtSRS = ServletUtils.URLDecode((String)layerNameAndSRS, (String)conv.servletReq.getCharacterEncoding());
            String[] layerSRSFormatExtension = layerAtSRS.split("@");
            TileLayer tl = this.tld.getTileLayer(layerSRSFormatExtension[0]);
            GridSubset gridSub = tl.getGridSubset(layerSRSFormatExtension[1]);
            MimeType mimeType = MimeType.createFromExtension((String)layerSRSFormatExtension[2]);
            ret = this.tmsFactory.getTileMapDoc(tl, gridSub, mimeType, servletBase, context);
        }
        byte[] data = ret.getBytes(encoding);
        this.stats.log(data.length, Conveyor.CacheResult.OTHER);
        conv.servletResp.setStatus(200);
        conv.servletResp.setContentType("text/xml");
        conv.servletResp.setHeader("content-disposition", "inline;filename=tms-getcapabilities.xml");
        try {
            conv.servletResp.getOutputStream().write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

