/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.DelegatingAuthenticationProvider;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.RoleCalculator;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class LDAPAuthenticationProvider
extends DelegatingAuthenticationProvider {
    private String adminRole;
    private String groupAdminRole;

    public LDAPAuthenticationProvider(AuthenticationProvider authProvider, String adminRole, String groupAdminRole) {
        super(authProvider);
        this.adminRole = adminRole;
        this.groupAdminRole = groupAdminRole;
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
    }

    protected Authentication doAuthenticate(Authentication authentication, HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)super.doAuthenticate(authentication, request);
        if (auth == null) {
            return null;
        }
        HashSet<GeoServerRole> roles = new HashSet<GeoServerRole>();
        roles.addAll(auth.getAuthorities());
        if (this.getSecurityManager() != null) {
            RoleCalculator calc = new RoleCalculator(this.getSecurityManager().getActiveRoleService());
            try {
                roles.addAll(calc.calculateRoles(new GeoServerUser(auth.getName())));
            }
            catch (IOException e) {
                throw new AuthenticationServiceException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (!auth.getAuthorities().contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        }
        if (this.adminRole != null && !this.adminRole.equals("") && !roles.contains(GeoServerRole.ADMIN_ROLE)) {
            for (GrantedAuthority authority : auth.getAuthorities()) {
                if (!authority.getAuthority().equalsIgnoreCase("ROLE_" + this.adminRole)) continue;
                roles.add(GeoServerRole.ADMIN_ROLE);
                break;
            }
        }
        if (this.groupAdminRole != null && !this.groupAdminRole.equals("") && !roles.contains(GeoServerRole.GROUP_ADMIN_ROLE)) {
            for (GrantedAuthority authority : auth.getAuthorities()) {
                if (!authority.getAuthority().equalsIgnoreCase("ROLE_" + this.groupAdminRole)) continue;
                roles.add(GeoServerRole.GROUP_ADMIN_ROLE);
                break;
            }
        }
        UsernamePasswordAuthenticationToken newAuth = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), auth.getCredentials(), roles);
        newAuth.setDetails(auth.getDetails());
        return newAuth;
    }
}

