/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.net.URI;
import org.geoserver.ows.KvpParser;

public class URIKvpParser
extends KvpParser {
    public URIKvpParser(String key) {
        super(key, URI.class);
    }

    @Override
    public URI parse(String value) throws Exception {
        try {
            return new URI(value);
        }
        catch (Exception t) {
            return URI.create(URIKvpParser.uriEncode(value));
        }
    }

    public static String uriEncode(String uri) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c > ' ' && c < '{' && "\"\\<>%^[]`+$,".indexOf(c) == -1) {
                sb.append(c);
                continue;
            }
            sb.append("%").append(Integer.toHexString(c));
        }
        return sb.toString();
    }
}

