/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.ows11.ExceptionType;
import net.opengis.ows11.KeywordsType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.ows11.RequestMethodType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.NameImpl;
import org.geotools.xsd.EMFUtils;

public class Ows11Util {
    static Ows11Factory f = Ows11Factory.eINSTANCE;

    public static LanguageStringType languageString(InternationalString value) {
        if (value != null) {
            return Ows11Util.languageString(value.toString(Locale.getDefault()));
        }
        return null;
    }

    public static LanguageStringType languageString(String value) {
        LanguageStringType ls = f.createLanguageStringType();
        ls.setValue(value);
        return ls;
    }

    public static KeywordsType keywords(List<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        KeywordsType kw = f.createKeywordsType();
        for (String keyword : keywords) {
            kw.getKeyword().add((Object)Ows11Util.languageString(keyword));
        }
        return kw;
    }

    public static CodeType code(String value) {
        CodeType code = f.createCodeType();
        code.setValue(value);
        return code;
    }

    public static CodeType code(Name name) {
        CodeType code = f.createCodeType();
        code.setValue(name.getURI());
        return code;
    }

    public static Name name(CodeType code) {
        if (code.getCodeSpace() != null) {
            return new NameImpl(code.getCodeSpace(), code.getValue());
        }
        return Ows11Util.name(code.getValue());
    }

    public static Name name(String URI) {
        String[] parsed = URI.trim().split(":");
        if (parsed.length == 1) {
            return new NameImpl(parsed[0]);
        }
        return new NameImpl(parsed[0], parsed[1]);
    }

    public static CodeType code(CodeType value) {
        return Ows11Util.code(value.getValue());
    }

    public static DomainMetadataType type(String name) {
        DomainMetadataType type = f.createDomainMetadataType();
        type.setValue(name);
        return type;
    }

    public static ExceptionReportType exceptionReport(ServiceException exception, boolean verboseExceptions) {
        return Ows11Util.exceptionReport(exception, verboseExceptions, null);
    }

    public static ExceptionReportType exceptionReport(ServiceException exception, boolean verboseExceptions, String version) {
        ExceptionType e = f.createExceptionType();
        if (exception.getCode() != null) {
            e.setExceptionCode(exception.getCode());
        } else {
            e.setExceptionCode("NoApplicableCode");
        }
        e.setLocator(exception.getLocator());
        StringBuffer sb = new StringBuffer();
        OwsUtils.dumpExceptionMessages((Throwable)exception, sb, true);
        e.getExceptionText().add((Object)sb.toString());
        e.getExceptionText().addAll((Collection)exception.getExceptionText());
        if (verboseExceptions) {
            e.getExceptionText().add((Object)"Details:");
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(trace));
            e.getExceptionText().add((Object)new String(trace.toByteArray()));
        }
        ExceptionReportType report = f.createExceptionReportType();
        version = version != null ? version : "1.1.0";
        report.setVersion(version);
        report.getException().add((Object)e);
        return report;
    }

    public static DCPType dcp(String service, EObject request) {
        String baseUrl = (String)EMFUtils.get((EObject)request, (String)"baseUrl");
        if (baseUrl == null) {
            throw new IllegalArgumentException("Request object" + request + " has no 'baseUrl' property.");
        }
        String href = ResponseUtils.buildURL(baseUrl, service, new HashMap<String, String>(), URLMangler.URLType.SERVICE);
        DCPType dcp = f.createDCPType();
        dcp.setHTTP(f.createHTTPType());
        RequestMethodType get = f.createRequestMethodType();
        get.setHref(href);
        dcp.getHTTP().getGet().add((Object)get);
        RequestMethodType post = f.createRequestMethodType();
        post.setHref(href);
        dcp.getHTTP().getPost().add((Object)post);
        return dcp;
    }
}

