/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.URLMangler;

public class WMTSTileJSON {
    private static Logger log = Logging.getLogger((String)WMTSTileJSON.class.getName());
    private final String restBaseUrl;
    private String style;
    private ConveyorTile convTile;
    private static final String ENDING_DIGITS_REGEX = "([0-9]+)$";
    private static final Pattern PATTERN_DIGITS = Pattern.compile("([0-9]+)$");

    public WMTSTileJSON(ConveyorTile convTile, String baseUrl, String contextPath, String style, URLMangler urlMangler) {
        this.convTile = convTile;
        this.style = style;
        this.restBaseUrl = urlMangler.buildURL(baseUrl, contextPath, "/service/wmts/rest");
    }

    public void writeResponse(TileLayer layer) {
        TileJSONProvider provider = (TileJSONProvider)layer;
        TileJSON json = provider.getTileJSON();
        ArrayList<String> urls = new ArrayList<String>();
        MimeType mimeType = this.convTile.getMimeType();
        Set gridSubSets = layer.getGridSubsets();
        for (String gridSubSet : gridSubSets) {
            this.addTileUrl(layer, gridSubSet, mimeType, urls);
        }
        List vectorLayers = json.getLayers();
        if (vectorLayers != null && !vectorLayers.isEmpty() && !mimeType.isVector()) {
            json.setLayers(null);
        }
        String[] tileUrls = urls.toArray(new String[urls.size()]);
        json.setTiles(tileUrls);
        this.convTile.servletResp.setStatus(200);
        this.convTile.servletResp.setContentType(ApplicationMime.json.getMimeType());
        try {
            ServletOutputStream os = this.convTile.servletResp.getOutputStream();
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.writeValue((OutputStream)os, (Object)json);
            os.flush();
        }
        catch (IOException ioe) {
            log.fine("Caught IOException" + ioe.getMessage());
        }
    }

    private void addTileUrl(TileLayer layer, String gridSubSet, MimeType mimeType, List<String> urls) {
        GridSubset grid = layer.getGridSubset(gridSubSet);
        int zoomLevelStart = -1;
        int start = -1;
        String zoomLevelPrefix = "";
        for (String gridName : grid.getGridNames()) {
            Matcher matcherName = PATTERN_DIGITS.matcher(gridName);
            if (!matcherName.find()) {
                throw new IllegalArgumentException("Zoom level has no numeric value:" + gridName);
            }
            start = matcherName.start(0);
            if (zoomLevelStart != -1 && start != zoomLevelStart) {
                throw new IllegalArgumentException("Zoom levels are not sharing the same not-numeric prefix");
            }
            if (zoomLevelStart == -1) {
                zoomLevelPrefix = gridName.substring(0, start);
            }
            zoomLevelStart = start;
        }
        String tileUrl = this.restBaseUrl + "/" + layer.getName() + "/" + (String)(this.style != null ? this.style + "/" : "") + gridSubSet + "/" + zoomLevelPrefix + "{z}/{y}/{x}?format=" + mimeType;
        urls.add(tileUrl);
    }
}

