/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.StylePage;
import org.geotools.util.Version;

public class StyleEditPage
extends AbstractStylePage {
    private static final long serialVersionUID = 5478083954402101191L;
    public static final String NAME = "name";
    public static final String WORKSPACE = "workspace";

    public StyleEditPage(PageParameters parameters) {
        StyleInfo si;
        String name = parameters.get(NAME).toString();
        String workspace = parameters.get(WORKSPACE).toOptionalString();
        StyleInfo styleInfo = si = workspace != null ? this.getCatalog().getStyleByName(workspace, name) : this.getCatalog().getStyleByName(name);
        if (si == null) {
            this.error((Serializable)((Object)new ParamResourceModel("StyleEditPage.notFound", (Component)this, new Object[]{name}).getString()));
            this.doReturn(StylePage.class);
            return;
        }
        this.recoverCssStyle(si);
        this.initPreviewLayer(si);
        this.initUI(si);
        if (!this.isAuthenticatedAsAdmin() && si.getWorkspace() == null) {
            this.styleForm.setEnabled(false);
            this.editor.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"disabled"))});
            this.get("validate").add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"hidden"))});
            this.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = -4336130086161028141L;

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)"document.getElementById('mainFormSubmit').style.display = 'none';"));
                    response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)"document.getElementById('uploadFormSubmit').style.display = 'none';"));
                }
            }});
            this.info((Serializable)((Object)new StringResourceModel("globalStyleReadOnly", (Component)this, null).getString()));
        }
    }

    public StyleEditPage(StyleInfo style) {
        super(style);
    }

    protected String getTitle() {
        StyleInfo style = (StyleInfo)this.styleModel.getObject();
        Object styleName = "";
        if (style != null) {
            styleName = (String)(style.getWorkspace() == null ? "" : style.getWorkspace().getName() + ":") + style.getName();
        }
        return new ParamResourceModel("title", (Component)this, new Object[]{styleName}).getString();
    }

    @Override
    protected void onStyleFormSubmit() {
        try {
            StyleInfo stylePath;
            StyleInfo style = this.getStyleInfo();
            String format = style.getFormat();
            style.setFormat(format);
            Version version = Styles.handler((String)format).version((Object)this.rawStyle);
            style.setFormatVersion(version);
            if (null == style.getLegend() || null == style.getLegend().getOnlineResource() || style.getLegend().getOnlineResource().isEmpty()) {
                style.setLegend(null);
            }
            if ((stylePath = this.getCatalog().getStyle(style.getId())) == null) {
                stylePath = style;
            }
            try {
                this.getCatalog().getResourcePool().writeStyle(stylePath, (InputStream)new ByteArrayInputStream(this.rawStyle.getBytes()));
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            this.getCatalog().save(style);
            this.styleForm.info((Serializable)((Object)"Style saved"));
            if (!"sld".equals(format)) {
                this.getCatalog().getResourcePool().getStyle(stylePath);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred saving the style", e);
            this.styleForm.error((Serializable)e);
        }
    }
}

