/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.feature;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.process.feature.AbstractFeatureCollectionProcess;
import org.geotools.process.feature.FeatureToFeatureProcessFactory;

public abstract class FeatureToFeatureProcess
extends AbstractFeatureCollectionProcess {
    public FeatureToFeatureProcess(FeatureToFeatureProcessFactory factory) {
        super(factory);
    }

    @Override
    public final Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        FeatureCollection features = (FeatureCollection)input.get(FeatureToFeatureProcessFactory.FEATURES.key);
        float scale = 100.0f / (float)features.size();
        monitor.started();
        SimpleFeatureType targetSchema = this.getTargetSchema((SimpleFeatureType)features.getSchema(), input);
        DefaultFeatureCollection result = new DefaultFeatureCollection(null, targetSchema);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(result.getSchema());
        try (FeatureIterator fi = features.features();){
            int counter = 0;
            while (fi.hasNext()) {
                fb.init((SimpleFeature)fi.next());
                SimpleFeature feature = fb.buildFeature(null);
                try {
                    this.processFeature(feature, input);
                }
                catch (Exception e) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                monitor.progress(scale * (float)counter++);
                result.add(feature);
            }
        }
        monitor.complete();
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put(FeatureToFeatureProcessFactory.RESULT.key, result);
        return output;
    }

    protected SimpleFeatureType getTargetSchema(SimpleFeatureType sourceSchema, Map<String, Object> input) {
        return sourceSchema;
    }
}

