/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.factory;

import java.awt.RenderingHints;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Parameter;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.process.RenderingProcess;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.DescribeResults;
import org.geotools.util.Converters;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;

public abstract class AnnotationDrivenProcessFactory
implements ProcessFactory {
    static final Logger LOGGER = Logging.getLogger(AnnotationDrivenProcessFactory.class);
    protected String namespace;
    InternationalString title;
    private static Map<Class, Class> PRIMITIVE_MAPPER = Map.of(Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class);

    public AnnotationDrivenProcessFactory(InternationalString title, String namespace) {
        this.namespace = namespace;
        this.title = title;
    }

    protected abstract DescribeProcess getProcessDescription(Name var1);

    protected abstract Method method(String var1);

    @Override
    public InternationalString getTitle() {
        return this.title;
    }

    @Override
    public InternationalString getDescription(Name name) {
        DescribeProcess info = this.getProcessDescription(name);
        if (info != null) {
            return new SimpleInternationalString(info.description());
        }
        return null;
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo(Name name) {
        Method method = this.method(name.getLocalPart());
        LinkedHashMap input = new LinkedHashMap();
        Annotation[][] params = method.getParameterAnnotations();
        Class<?>[] paramTypes = this.getMethodParamTypes(method);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (ProgressListener.class.isAssignableFrom(paramTypes[i])) continue;
            Parameter<?> param = this.paramInfo(method.getDeclaringClass(), i, paramTypes[i], params[i]);
            input.put(param.key, param);
        }
        return input;
    }

    private Class<?>[] getMethodParamTypes(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!paramTypes[i].isPrimitive()) continue;
            paramTypes[i] = PRIMITIVE_MAPPER.get(paramTypes[i]);
        }
        return paramTypes;
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) throws IllegalArgumentException {
        Method method = this.method(name.getLocalPart());
        LinkedHashMap result = new LinkedHashMap();
        for (Annotation annotation : method.getAnnotations()) {
            Annotation info;
            if (annotation instanceof DescribeResult) {
                info = (DescribeResult)annotation;
                this.addResult(method, result, (DescribeResult)info);
                continue;
            }
            if (!(annotation instanceof DescribeResults)) continue;
            info = (DescribeResults)annotation;
            for (DescribeResult dr : info.value()) {
                this.addResult(method, result, dr);
            }
        }
        if (result.isEmpty() && !Void.class.equals(method.getReturnType())) {
            Parameter VALUE = new Parameter("result", method.getReturnType(), "Process result", "No description is available");
            result.put(VALUE.key, VALUE);
        }
        return result;
    }

    private void addResult(Method method, Map<String, Parameter<?>> result, DescribeResult info) {
        Class<?> resultType = info.type();
        if (Object.class.equals(resultType)) {
            resultType = method.getReturnType();
        }
        HashMap<String, Object> metadata = null;
        if (info.meta() != null && info.meta().length > 0) {
            String[] meta = info.meta();
            metadata = new HashMap<String, Object>();
            this.fillParameterMetadata(meta, metadata);
        }
        int min = info.primary() ? 0 : 1;
        Parameter<Object> resultParam = new Parameter<Object>(info.name(), resultType, (InternationalString)new SimpleInternationalString(info.name()), (InternationalString)new SimpleInternationalString(info.description()), min > 0, min, 1, null, metadata);
        result.put(resultParam.key, resultParam);
    }

    @Override
    public InternationalString getTitle(Name name) {
        DescribeProcess info = this.getProcessDescription(name);
        if (info != null) {
            return new SimpleInternationalString(info.title());
        }
        return null;
    }

    @Override
    public String getVersion(Name name) {
        DescribeProcess info = this.getProcessDescription(name);
        if (info != null) {
            return info.version();
        }
        return null;
    }

    @Override
    public boolean supportsProgress(Name name) {
        return false;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    Parameter<?> paramInfo(Class process, int i, Class<?> type, Annotation[] paramAnnotations) {
        DescribeParameter info = null;
        for (Annotation annotation : paramAnnotations) {
            if (!(annotation instanceof DescribeParameter)) continue;
            info = (DescribeParameter)annotation;
            break;
        }
        boolean collection = Collection.class.isAssignableFrom(type);
        int min = 1;
        int max = 1;
        if (collection) {
            if (info != null) {
                type = info.collectionType();
                if (type == null) {
                    type = Object.class;
                }
                min = info.min() > -1 ? info.min() : 0;
                max = info.max() > -1 ? info.max() : Integer.MAX_VALUE;
            } else {
                type = Object.class;
                min = 0;
                max = Integer.MAX_VALUE;
            }
        } else if (type.isArray()) {
            if (info != null) {
                min = info.min() > -1 ? info.min() : 0;
                max = info.max() > -1 ? info.max() : Integer.MAX_VALUE;
            } else {
                min = 0;
                max = Integer.MAX_VALUE;
            }
            type = type.getComponentType();
        } else if (info != null) {
            if (info.min() > 1) {
                throw new IllegalArgumentException("The non collection parameter at index " + i + " cannot have a min multiplicity > 1");
            }
            int n = min = info.min() > -1 ? info.min() : 1;
            if (info.max() > 1) {
                throw new IllegalArgumentException("The non collection parameter at index " + i + " cannot have a max multiplicity > 1");
            }
            int n2 = max = info.max() > -1 ? info.max() : 1;
        }
        if (min > max) {
            throw new IllegalArgumentException("Min occurrences > max occurrences for parameter at index " + i);
        }
        if (min == 0 && max == 1 && type.isPrimitive()) {
            throw new IllegalArgumentException("Optional values cannot be primitives, use the associated object wrapper instead: " + info.name() + " in process " + process.getName());
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        if (info != null) {
            double maxValue;
            double minValue = info.minValue();
            if (minValue != Double.NEGATIVE_INFINITY) {
                metadata.put("min", minValue);
            }
            if ((maxValue = info.maxValue()) != Double.POSITIVE_INFINITY) {
                metadata.put("max", maxValue);
            }
        }
        Object defaultValue = null;
        if (info != null && !"THIS IS THE NULL VALUE FOR THE DEFAULT ATTRIBUTE".equals(info.defaultValue())) {
            String strDefault = info.defaultValue();
            defaultValue = this.lookupConstant(strDefault, process, type);
            if (defaultValue == null) {
                defaultValue = Converters.convert((Object)strDefault, (Class)type);
            }
            if (defaultValue == null) {
                throw new IllegalArgumentException("Default value " + strDefault + " could not be converted to target type " + type);
            }
        }
        if (info != null && info.meta() != null && info.meta().length > 0) {
            String[] meta = info.meta();
            this.fillParameterMetadata(meta, metadata);
        }
        if (info != null) {
            return new Parameter<Object>(info.name(), type, (InternationalString)new SimpleInternationalString(info.name()), (InternationalString)new SimpleInternationalString(info.description()), min > 0, min, max, defaultValue, metadata);
        }
        return new Parameter<Object>("arg" + i, type, (InternationalString)new SimpleInternationalString("Argument " + i), (InternationalString)new SimpleInternationalString("Input " + type.getName() + " value"), min > 0, min, max, defaultValue, metadata);
    }

    private void fillParameterMetadata(String[] metas, Map<String, Object> metadata) {
        for (String pair : metas) {
            String value;
            String key;
            int idx = pair.indexOf(61);
            if (idx > 0) {
                key = pair.substring(0, idx);
                value = pair.substring(idx + 1);
            } else {
                key = pair;
                value = null;
            }
            metadata.put(key, value);
        }
    }

    private Object lookupConstant(String path, Class<?> process, Class<?> type) {
        int hashIdx = path.indexOf("#");
        if (hashIdx == -1) {
            Object result = this.getConstantValue(path, process, type);
            if (result == null) {
                result = this.getConstantValue(path, type, type);
            }
            return result;
        }
        String className = path.substring(0, hashIdx);
        String field = path.substring(hashIdx + 1);
        try {
            Class<?> holder = Class.forName(className);
            return this.getConstantValue(field, holder, type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to locate class " + className);
        }
    }

    private Object getConstantValue(String path, Class<?> holder, Class<?> target) {
        Field field = null;
        try {
            field = holder.getDeclaredField(path);
        }
        catch (NoSuchFieldException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Failed to locate the field " + path + " in class " + holder);
            }
            return null;
        }
        if ((field.getModifiers() & 0x18) == 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Field " + path + " found in class " + holder + ", but it's not a costant");
            }
            return null;
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            Object result = field.get(null);
            return Converters.convert((Object)result, target);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Field " + path + " found in class " + holder + ", but failed to access it", e);
            }
            return null;
        }
    }

    @Override
    public Process create(Name name) {
        String methodName = name.getLocalPart();
        Method meth = this.method(methodName);
        Object process = this.createProcessBean(name);
        if (process != null && (this.lookupInvertGridGeometry(process, meth.getName()) != null || this.lookupInvertQuery(process, meth.getName()) != null || this.lookupCustomizeReadParams(process, meth.getName()) != null || this.lookupClipOnRenderingArea(process, meth.getName()) != null)) {
            return new InvokeMethodRenderingProcess(meth, process);
        }
        return new InvokeMethodProcess(meth, process);
    }

    Method lookupMethod(Object targetObject, String methodName) {
        Method method = null;
        for (Method m : targetObject.getClass().getMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || !methodName.equals(m.getName())) continue;
            method = m;
            break;
        }
        return method;
    }

    protected Method lookupInvertGridGeometry(Object targetObject, String methodName) {
        methodName = methodName == null || "execute".equals(methodName) ? "invertGridGeometry" : (String)methodName + "InvertGridGeometry";
        return this.lookupMethod(targetObject, (String)methodName);
    }

    protected Method lookupCustomizeReadParams(Object targetObject, String methodName) {
        methodName = methodName == null || "execute".equals(methodName) ? "customizeReadParams" : (String)methodName + "CustomizeReadParams";
        return this.lookupMethod(targetObject, (String)methodName);
    }

    protected Method lookupClipOnRenderingArea(Object targetObject, String methodName) {
        methodName = methodName == null || "execute".equals(methodName) ? "clipOnRenderingArea" : (String)methodName + "ClipOnRenderingArea";
        return this.lookupMethod(targetObject, (String)methodName);
    }

    protected Method lookupInvertQuery(Object targetObject, String methodName) {
        methodName = methodName == null || "execute".equals(methodName) ? "invertQuery" : (String)methodName + "InvertQuery";
        return this.lookupMethod(targetObject, (String)methodName);
    }

    protected abstract Object createProcessBean(Name var1);

    class InvokeMethodRenderingProcess
    extends InvokeMethodProcess
    implements Process,
    RenderingProcess {
        public InvokeMethodRenderingProcess(Method method, Object targetObject) {
            super(method, targetObject);
        }

        @Override
        public Query invertQuery(Map<String, Object> input, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
            Method invertQueryMethod = AnnotationDrivenProcessFactory.this.lookupInvertQuery(this.targetObject, this.method.getName());
            if (invertQueryMethod == null) {
                return targetQuery;
            }
            try {
                Object[] args = this.buildProcessArguments(invertQueryMethod, input, null, true);
                args[args.length - 2] = targetQuery;
                args[args.length - 1] = targetGridGeometry;
                return (Query)invertQueryMethod.invoke(this.targetObject, args);
            }
            catch (IllegalAccessException e) {
                throw new ProcessException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ProcessException) {
                    throw (ProcessException)t;
                }
                throw new ProcessException(t);
            }
        }

        @Override
        public GridGeometry invertGridGeometry(Map<String, Object> input, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
            Method invertGridGeometryMethod = AnnotationDrivenProcessFactory.this.lookupInvertGridGeometry(this.targetObject, this.method.getName());
            if (invertGridGeometryMethod == null) {
                return targetGridGeometry;
            }
            try {
                Object[] args = this.buildProcessArguments(invertGridGeometryMethod, input, null, true);
                args[args.length - 2] = targetQuery;
                args[args.length - 1] = targetGridGeometry;
                return (GridGeometry)invertGridGeometryMethod.invoke(this.targetObject, args);
            }
            catch (IllegalAccessException e) {
                throw new ProcessException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ProcessException) {
                    throw (ProcessException)t;
                }
                throw new ProcessException(t);
            }
        }

        @Override
        public GeneralParameterValue[] customizeReadParams(Map<String, Object> input, GridCoverageReader reader, GeneralParameterValue[] params) {
            Method customizeReadParamsMethod = AnnotationDrivenProcessFactory.this.lookupCustomizeReadParams(this.targetObject, this.method.getName());
            if (customizeReadParamsMethod == null) {
                return params;
            }
            try {
                Object[] args = this.buildProcessArguments(customizeReadParamsMethod, input, null, true);
                args[args.length - 2] = reader;
                args[args.length - 1] = params;
                return (GeneralParameterValue[])customizeReadParamsMethod.invoke(this.targetObject, args);
            }
            catch (IllegalAccessException e) {
                throw new ProcessException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ProcessException) {
                    throw (ProcessException)t;
                }
                throw new ProcessException(t);
            }
        }

        @Override
        public boolean clipOnRenderingArea(Map<String, Object> input) {
            Method clipOnRenderingAreaMethod = AnnotationDrivenProcessFactory.this.lookupClipOnRenderingArea(this.targetObject, this.method.getName());
            if (clipOnRenderingAreaMethod == null) {
                return false;
            }
            Object[] args = this.buildProcessArguments(clipOnRenderingAreaMethod, input, null, false);
            try {
                return (Boolean)clipOnRenderingAreaMethod.invoke(this.targetObject, args);
            }
            catch (IllegalAccessException e) {
                throw new ProcessException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ProcessException) {
                    throw (ProcessException)t;
                }
                throw new ProcessException(t);
            }
        }
    }

    class InvokeMethodProcess
    implements Process {
        Method method;
        Object targetObject;

        public InvokeMethodProcess(Method method, Object targetObject) {
            this.method = method;
            this.targetObject = targetObject;
        }

        @Override
        public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws ProcessException {
            Object[] args = this.buildProcessArguments(this.method, input, monitor, false);
            Object value = null;
            try {
                value = this.method.invoke(this.targetObject, args);
            }
            catch (IllegalAccessException e) {
                if (monitor != null) {
                    monitor.exceptionOccurred((Throwable)e);
                }
                throw new ProcessException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (monitor != null) {
                    monitor.exceptionOccurred(t);
                }
                if (t instanceof ProcessException) {
                    throw (ProcessException)t;
                }
                throw new ProcessException(t);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                int i = 0;
                for (Annotation annotation : this.method.getAnnotations()) {
                    Annotation info;
                    if (i >= values.length) break;
                    Object obj = values[i];
                    if (annotation instanceof DescribeResult) {
                        info = (DescribeResult)annotation;
                        this.addResult(result, obj, (DescribeResult)info);
                    }
                    if (!(annotation instanceof DescribeResults)) continue;
                    info = (DescribeResults)annotation;
                    for (DescribeResult dr : info.value()) {
                        this.addResult(result, obj, dr);
                    }
                }
                return result;
            }
            if (value instanceof Map) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                Map map = (Map)value;
                for (Annotation annotation : this.method.getAnnotations()) {
                    Annotation info;
                    Object resultValue;
                    if (annotation instanceof DescribeResult && (resultValue = map.get((info = (DescribeResult)annotation).name())) != null) {
                        this.addResult(result, resultValue, (DescribeResult)info);
                    }
                    if (!(annotation instanceof DescribeResults)) continue;
                    info = (DescribeResults)annotation;
                    for (DescribeResult dr : info.value()) {
                        Object resultValue2 = map.get(dr.name());
                        if (resultValue2 == null) continue;
                        this.addResult(result, resultValue2, dr);
                    }
                }
                return result;
            }
            if (!Void.class.equals(this.method.getReturnType())) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                DescribeResult dr = this.method.getAnnotation(DescribeResult.class);
                if (dr != null) {
                    result.put(dr.name(), value);
                } else {
                    result.put("result", value);
                }
                return result;
            }
            return null;
        }

        private void addResult(Map<String, Object> result, Object obj, DescribeResult info) {
            if (!info.type().isInstance(obj)) {
                throw new IllegalArgumentException(this.method.getName() + " unable to encode result " + obj + " as " + info.type());
            }
            result.put(info.name(), obj);
        }

        protected Object[] buildProcessArguments(Method method, Map<String, Object> input, ProgressListener monitor, boolean skip) throws ProcessException {
            Class<?>[] paramTypes = AnnotationDrivenProcessFactory.this.getMethodParamTypes(method);
            Annotation[][] annotations = method.getParameterAnnotations();
            Object[] args = new Object[paramTypes.length];
            for (int i = 0; i < args.length; ++i) {
                if (ProgressListener.class.equals(paramTypes[i])) {
                    args[i] = monitor;
                    continue;
                }
                if ((annotations[i] == null || annotations[i].length == 0) && skip) continue;
                Class<?> target = this.targetObject == null ? null : this.targetObject.getClass();
                Parameter<?> p = AnnotationDrivenProcessFactory.this.paramInfo(target, i, paramTypes[i], annotations[i]);
                Object value = input.get(p.key);
                if (value == null && p.getDefaultValue() != null) {
                    value = p.getDefaultValue();
                }
                args[i] = Converters.convert((Object)value, paramTypes[i]);
                if (args[i] == null && value != null) {
                    throw new ProcessException("Could not convert " + value + " to target type " + paramTypes[i].getName());
                }
                if (p.minOccurs > 0 && value == null) {
                    throw new ProcessException("Parameter " + p.key + " is missing but has min multiplicity > 0");
                }
                if (p.maxOccurs <= 1) continue;
                int size = -1;
                size = args[i] == null ? 0 : (paramTypes[i].isArray() ? Array.getLength(args[i]) : ((Collection)args[i]).size());
                if (size < p.minOccurs) {
                    throw new ProcessException("Parameter " + p.key + " has " + size + " elements but min occurrences is " + p.minOccurs);
                }
                if (size <= p.maxOccurs) continue;
                throw new ProcessException("Parameter " + p.key + " has " + size + " elements but max occurrences is " + p.maxOccurs);
            }
            return args;
        }
    }
}

