/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.data;

import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.web.data.AbstractDataAccessRulePage;
import org.geoserver.security.web.data.DataSecurityPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class NewDataAccessRulePage
extends AbstractDataAccessRulePage {
    public NewDataAccessRulePage() {
        super(new DataAccessRule());
        ((Form)this.get("form")).add((IFormValidator)new DuplicateRuleValidator());
    }

    @Override
    protected void onFormSubmit(DataAccessRule rule) {
        try {
            DataAccessRuleDAO dao = DataAccessRuleDAO.get();
            dao.addRule((Comparable)rule);
            dao.storeRules();
            this.doReturn(DataSecurityPage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred while saving rule ", e);
            this.error((Serializable)new ParamResourceModel("saveError", (Component)this.getPage(), new Object[]{e.getMessage()}));
        }
    }

    class DuplicateRuleValidator
    extends AbstractFormValidator {
        DuplicateRuleValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{NewDataAccessRulePage.this.rootChoice, NewDataAccessRulePage.this.layerChoice, NewDataAccessRulePage.this.accessModeChoice, NewDataAccessRulePage.this.rolesFormComponent};
        }

        public void validate(Form<?> form) {
            if (!form.findSubmitter().getInputName().equals("save")) {
                return;
            }
            NewDataAccessRulePage.this.updateModels();
            DataAccessRule rule = (DataAccessRule)form.getModelObject();
            if (DataAccessRuleDAO.get().getRules().contains(rule)) {
                form.error((Serializable)((Object)new ParamResourceModel("duplicateRule", (Component)NewDataAccessRulePage.this.getPage(), new Object[]{rule.getKey()}).getString()));
            }
        }
    }
}

