/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web.csp;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.web.csp.CSPPolicyPage;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public class CSPPolicyPanel
extends Panel {
    private static final long serialVersionUID = -8329354368660703089L;
    private static final GeoServerDataProvider.Property<CSPPolicy> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    private static final GeoServerDataProvider.Property<CSPPolicy> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    private static final GeoServerDataProvider.Property<CSPPolicy> DESCRIPTION = new GeoServerDataProvider.BeanProperty("description", "description");
    private static final GeoServerDataProvider.Property<CSPPolicy> REMOVE = new GeoServerDataProvider.PropertyPlaceholder("remove");
    private static final List<GeoServerDataProvider.Property<CSPPolicy>> PROPERTIES = List.of(ENABLED, NAME, DESCRIPTION, REMOVE);
    private CSPConfiguration config = null;
    private CSPPolicyTablePanel tablePanel = null;

    public CSPPolicyPanel(String id, final CSPConfiguration config) {
        super(id);
        this.config = config;
        this.add(new Component[]{new AjaxLink<Void>("add"){
            private static final long serialVersionUID = 5518438243807007190L;

            public void onClick(AjaxRequestTarget target) {
                CSPPolicyPage page = new CSPPolicyPage(new CSPPolicy(), config);
                this.setResponsePage((IRequestablePage)page.setReturnPage(this.getPage()));
            }
        }});
        this.tablePanel = new CSPPolicyTablePanel("table", config.getPolicies());
        this.add(new Component[]{this.tablePanel});
    }

    private static IModel<List<GeoServerDataProvider.Property<CSPPolicy>>> getProperties() {
        return new LoadableDetachableModel<List<GeoServerDataProvider.Property<CSPPolicy>>>(){
            private static final long serialVersionUID = 6024865833524314857L;

            protected List<GeoServerDataProvider.Property<CSPPolicy>> load() {
                return PROPERTIES;
            }
        };
    }

    private class CSPPolicyTablePanel
    extends ReorderableTablePanel<CSPPolicy> {
        private static final long serialVersionUID = -3229289637490224342L;

        public CSPPolicyTablePanel(String id, List<CSPPolicy> rules) {
            super(id, CSPPolicy.class, rules, CSPPolicyPanel.getProperties());
            this.setItemReuseStrategy(DefaultItemReuseStrategy.getInstance());
            this.setFilterable(false);
            this.setPageable(false);
        }

        protected Component getComponentForProperty(String id, IModel<CSPPolicy> itemModel, GeoServerDataProvider.Property<CSPPolicy> property) {
            if (property == NAME) {
                return this.editLink(id, itemModel, property.getModel(itemModel));
            }
            if (property == REMOVE) {
                return this.removeLink(id, (CSPPolicy)itemModel.getObject());
            }
            if (Boolean.TRUE.equals(property.getModel(itemModel).getObject())) {
                return new Icon(id, CatalogIconFactory.ENABLED_ICON);
            }
            if (Boolean.FALSE.equals(property.getModel(itemModel).getObject())) {
                return new Label(id, (Serializable)((Object)""));
            }
            return new Label(id, property.getModel(itemModel));
        }

        private Component editLink(String id, final IModel<CSPPolicy> model, IModel<?> label) {
            return new SimpleAjaxLink<CSPPolicy>(id, model, label){
                private static final long serialVersionUID = -7009235253455625060L;

                protected void onClick(AjaxRequestTarget target) {
                    CSPConfiguration config = CSPPolicyPanel.this.config;
                    CSPPolicyPage page = new CSPPolicyPage((CSPPolicy)model.getObject(), config);
                    this.setResponsePage((IRequestablePage)page.setReturnPage(this.getPage()));
                }
            };
        }

        private Component removeLink(String id, final CSPPolicy policy) {
            ImageAjaxLink<Void> link = new ImageAjaxLink<Void>(id, new PackageResourceReference(((Object)((Object)this)).getClass(), "../img/icons/silk/delete.png")){
                private static final long serialVersionUID = 190400999968840349L;

                protected void onClick(AjaxRequestTarget target) {
                    CSPPolicyPanel.this.config.getPolicies().remove(policy);
                    target.add(new Component[]{CSPPolicyPanel.this.tablePanel});
                }
            };
            link.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("th.remove", (Component)CSPPolicyPanel.this, new Object[0]))});
            return link;
        }
    }
}

