/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.rangelookup;

import org.jaitools.numeric.Range;

public class LookupItem<T extends Number, U extends Number> {
    private final Range<T> range;
    private final U value;

    public LookupItem(Range<T> range, U value) {
        if (range == null || value == null) {
            throw new IllegalArgumentException("Both range and value must be non-null");
        }
        this.range = range;
        this.value = value;
    }

    public Range<T> getRange() {
        return this.range;
    }

    public U getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LookupItem other = (LookupItem)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals(other.range));
    }

    public String toString() {
        return this.range.toString() + " => " + this.value;
    }
}

