/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.Collection;
import java.util.Map;
import net.opengis.ows20.AcceptLanguagesType;
import net.opengis.ows20.AcceptVersionsType;
import net.opengis.ows20.Ows20Factory;
import net.opengis.ows20.SectionsType;
import net.opengis.wcs20.GetCapabilitiesType;
import net.opengis.wcs20.Wcs20Factory;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wcs2_0.kvp.WCS20AcceptLanguagesKvpParser;
import org.geoserver.wcs2_0.kvp.WCS20AcceptVersionsKvpParser;
import org.geotools.xsd.EMFUtils;

public class WCS20GetCapabilitiesRequestReader
extends EMFKvpRequestReader {
    public WCS20GetCapabilitiesRequestReader() {
        super(GetCapabilitiesType.class, (EFactory)Wcs20Factory.eINSTANCE);
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        String value;
        Object avp;
        if (rawKvp.containsKey("acceptVersions")) {
            avp = new WCS20AcceptVersionsKvpParser();
            value = (String)rawKvp.get("acceptVersions");
            LOGGER.info("acceptVersions: " + value);
            AcceptVersionsType avt = (AcceptVersionsType)avp.parse(value);
            kvp.put("acceptVersions", avt);
        }
        if (rawKvp.containsKey("acceptLanguages")) {
            avp = new WCS20AcceptLanguagesKvpParser();
            value = (String)rawKvp.get("acceptLanguages");
            LOGGER.info("acceptLanguages: " + value);
            AcceptLanguagesType alt = (AcceptLanguagesType)avp.parse(value);
            kvp.put("acceptLanguages", alt);
        }
        if (rawKvp.containsKey("sections")) {
            String value2 = (String)rawKvp.get("sections");
            LOGGER.info("Sections: " + value2);
            SectionsType sections = Ows20Factory.eINSTANCE.createSectionsType();
            ((Collection)EMFUtils.get((EObject)sections, (String)"section")).addAll(KvpUtils.readFlat((String)value2, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER));
            kvp.put("sections", sections);
        }
        request = super.read(request, kvp, rawKvp);
        return request;
    }
}

