/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.WarpAffine;
import net.opengis.wcs20.ScaleAxisByFactorType;
import net.opengis.wcs20.ScaleAxisType;
import net.opengis.wcs20.ScaleByFactorType;
import net.opengis.wcs20.ScaleToExtentType;
import net.opengis.wcs20.ScaleToSizeType;
import net.opengis.wcs20.ScalingType;
import net.opengis.wcs20.TargetAxisExtentType;
import net.opengis.wcs20.TargetAxisSizeType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.InterpolationPolicy;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.processing.Operation;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.vfny.geoserver.util.WCSUtils;

enum ScalingPolicy {
    DoNothing{

        @Override
        public GridCoverage2D scale(GridCoverage2D sourceGC, ScalingType scaling, Interpolation interpolation, Hints hints, WCSInfo wcsinfo) {
            Utilities.ensureNonNull((String)"sourceGC", (Object)sourceGC);
            Utilities.ensureNonNull((String)"ScalingType", (Object)scaling);
            Utilities.ensureNonNull((String)"Interpolation", (Object)interpolation);
            return sourceGC;
        }
    }
    ,
    ScaleByFactor{

        @Override
        public GridCoverage2D scale(GridCoverage2D sourceGC, ScalingType scaling, Interpolation interpolation, Hints hints, WCSInfo wcsinfo) {
            Utilities.ensureNonNull((String)"sourceGC", (Object)sourceGC);
            Utilities.ensureNonNull((String)"ScalingType", (Object)scaling);
            double[] scaleFactors = 2.getScaleFactors(scaling);
            scaleFactors = ScalingPolicy.arrangeScaleFactors(hints, new double[]{scaleFactors[0], scaleFactors[0]});
            if (scaleFactors[0] <= 0.0) {
                throw new WCS20Exception("Invalid scale factor", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, String.valueOf(scaleFactors[0]));
            }
            if (scaleFactors[1] <= 0.0) {
                throw new WCS20Exception("Invalid scale factor", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, String.valueOf(scaleFactors[0]));
            }
            if (scaleFactors[0] == 1.0 && scaleFactors[1] == 1.0) {
                if (interpolation instanceof InterpolationNearest) {
                    return sourceGC;
                }
                Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
                ParameterValueGroup parameters = operation.getParameters();
                parameters.parameter("Source").setValue((Object)sourceGC);
                parameters.parameter("warp").setValue((Object)new WarpAffine(AffineTransform.getScaleInstance(1.0, 1.0)));
                parameters.parameter("interpolation").setValue((Object)interpolation);
                parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
                return (GridCoverage2D)CoverageProcessor.getInstance((Hints)hints).doOperation(parameters, hints);
            }
            GridGeometry2D gridGeometry = sourceGC.getGridGeometry();
            GridEnvelope gridRange = gridGeometry.getGridRange();
            WCSUtils.checkOutputLimits((WCSInfo)wcsinfo, (GridEnvelope2D)new GridEnvelope2D(0, 0, (int)((double)gridRange.getSpan(gridGeometry.gridDimensionX) * scaleFactors[0]), (int)((double)gridRange.getSpan(gridGeometry.gridDimensionY) * scaleFactors[1])), (SampleModel)sourceGC.getRenderedImage().getSampleModel());
            Operation operation = CoverageProcessor.getInstance().getOperation("Scale");
            ParameterValueGroup parameters = operation.getParameters();
            parameters.parameter("Source").setValue((Object)sourceGC);
            parameters.parameter("interpolation").setValue((Object)(interpolation != null ? interpolation : InterpolationPolicy.getDefaultPolicy().getInterpolation()));
            parameters.parameter("xScale").setValue(scaleFactors[0]);
            parameters.parameter("yScale").setValue(scaleFactors[1]);
            parameters.parameter("xTrans").setValue(0.0);
            parameters.parameter("yTrans").setValue(0.0);
            return (GridCoverage2D)CoverageProcessor.getInstance((Hints)hints).doOperation(parameters, hints);
        }
    }
    ,
    ScaleToSize{

        @Override
        public GridCoverage2D scale(GridCoverage2D sourceGC, ScalingType scaling, Interpolation interpolation, Hints hints, WCSInfo wcsinfo) {
            WarpAffine warp;
            int[] targetSize = 3.getTargetSize(scaling);
            int sizeX = targetSize[0];
            int sizeY = targetSize[1];
            GridEnvelope2D sourceGE = sourceGC.getGridGeometry().getGridRange2D();
            if (sizeY == sourceGE.width && sizeX == sourceGE.height) {
                if (interpolation instanceof InterpolationNearest) {
                    return sourceGC;
                }
                Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
                ParameterValueGroup parameters = operation.getParameters();
                parameters.parameter("Source").setValue((Object)sourceGC);
                parameters.parameter("warp").setValue((Object)new WarpAffine(AffineTransform.getScaleInstance(1.0, 1.0)));
                parameters.parameter("interpolation").setValue((Object)interpolation);
                parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
                return (GridCoverage2D)CoverageProcessor.getInstance().doOperation(parameters, hints);
            }
            WCSUtils.checkOutputLimits((WCSInfo)wcsinfo, (GridEnvelope2D)new GridEnvelope2D(0, 0, sizeX, sizeY), (SampleModel)sourceGC.getRenderedImage().getSampleModel());
            double scaleX = 1.0 * (double)sizeX / (double)sourceGE.width;
            double scaleY = 1.0 * (double)sizeY / (double)sourceGE.height;
            RenderedImage sourceImage = sourceGC.getRenderedImage();
            int sourceMinX = sourceImage.getMinX();
            int sourceMinY = sourceImage.getMinY();
            AffineTransform affineTransform = new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)sourceMinX - scaleX * (double)sourceMinX, (double)sourceMinY - scaleY * (double)sourceMinY);
            try {
                warp = new WarpAffine(affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e);
            }
            ImageLayout2 layout = new ImageLayout2(sourceMinX, sourceMinY, sizeX, sizeY);
            hints.add((RenderingHints)new Hints(JAI.KEY_IMAGE_LAYOUT, (Object)layout));
            Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
            ParameterValueGroup parameters = operation.getParameters();
            parameters.parameter("Source").setValue((Object)sourceGC);
            parameters.parameter("warp").setValue((Object)warp);
            parameters.parameter("interpolation").setValue((Object)(interpolation != null ? interpolation : InterpolationPolicy.getDefaultPolicy().getInterpolation()));
            parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
            GridCoverage2D gc = (GridCoverage2D)CoverageProcessor.getInstance().doOperation(parameters, hints);
            return gc;
        }
    }
    ,
    ScaleToExtent{

        @Override
        public GridCoverage2D scale(GridCoverage2D sourceGC, ScalingType scaling, Interpolation interpolation, Hints hints, WCSInfo wcsinfo) {
            WarpAffine warp;
            Utilities.ensureNonNull((String)"sourceGC", (Object)sourceGC);
            Utilities.ensureNonNull((String)"ScalingType", (Object)scaling);
            ScaleToExtentType scaleType = scaling.getScaleToExtent();
            EList targetAxisExtentElements = scaleType.getTargetAxisExtent();
            TargetAxisExtentType xExtent = null;
            TargetAxisExtentType yExtent = null;
            for (TargetAxisExtentType axisExtentType : targetAxisExtentElements) {
                String axisName = axisExtentType.getAxis();
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/i") || axisName.equals("i")) {
                    xExtent = axisExtentType;
                    continue;
                }
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/j") || axisName.equals("j")) {
                    yExtent = axisExtentType;
                    continue;
                }
                throw new WCS20Exception("Scale Axis Undefined", WCS20Exception.WCS20ExceptionCode.ScaleAxisUndefined, axisName);
            }
            if (xExtent == null) {
                throw new WCS20Exception("Missing extent along i", WCS20Exception.WCS20ExceptionCode.InvalidExtent, "Null");
            }
            if (yExtent == null) {
                throw new WCS20Exception("Missing extent along j", WCS20Exception.WCS20ExceptionCode.InvalidExtent, "Null");
            }
            int minx = (int)((TargetAxisExtentType)targetAxisExtentElements.get(0)).getLow();
            int maxx = (int)((TargetAxisExtentType)targetAxisExtentElements.get(0)).getHigh();
            int miny = (int)((TargetAxisExtentType)targetAxisExtentElements.get(1)).getLow();
            int maxy = (int)((TargetAxisExtentType)targetAxisExtentElements.get(1)).getHigh();
            GridEnvelope2D sourceGE = sourceGC.getGridGeometry().getGridRange2D();
            if (minx >= maxx) {
                throw new WCS20Exception("Invalid Extent for dimension:" + ((TargetAxisExtentType)targetAxisExtentElements.get(0)).getAxis(), WCS20Exception.WCS20ExceptionCode.InvalidExtent, String.valueOf(maxx));
            }
            if (miny >= maxy) {
                throw new WCS20Exception("Invalid Extent for dimension:" + ((TargetAxisExtentType)targetAxisExtentElements.get(1)).getAxis(), WCS20Exception.WCS20ExceptionCode.InvalidExtent, String.valueOf(maxy));
            }
            Rectangle destinationRectangle = new Rectangle(minx, miny, maxx - minx + 1, maxy - miny + 1);
            if (destinationRectangle.equals(sourceGE)) {
                if (interpolation instanceof InterpolationNearest) {
                    return sourceGC;
                }
                Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
                ParameterValueGroup parameters = operation.getParameters();
                parameters.parameter("Source").setValue((Object)sourceGC);
                parameters.parameter("warp").setValue((Object)new WarpAffine(AffineTransform.getScaleInstance(1.0, 1.0)));
                parameters.parameter("interpolation").setValue((Object)interpolation);
                parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
                return (GridCoverage2D)CoverageProcessor.getInstance((Hints)hints).doOperation(parameters, hints);
            }
            WCSUtils.checkOutputLimits((WCSInfo)wcsinfo, (GridEnvelope2D)new GridEnvelope2D(destinationRectangle), (SampleModel)sourceGC.getRenderedImage().getSampleModel());
            double scaleX = 1.0 * (double)destinationRectangle.width / (double)sourceGE.width;
            double scaleY = 1.0 * (double)destinationRectangle.height / (double)sourceGE.height;
            RenderedImage sourceImage = sourceGC.getRenderedImage();
            int sourceMinX = sourceImage.getMinX();
            int sourceMinY = sourceImage.getMinY();
            AffineTransform affineTransform = new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)destinationRectangle.x - scaleX * (double)sourceMinX, (double)destinationRectangle.y - scaleY * (double)sourceMinY);
            try {
                warp = new WarpAffine(affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e);
            }
            ImageLayout2 layout = new ImageLayout2(destinationRectangle.x, destinationRectangle.y, destinationRectangle.width, destinationRectangle.height);
            hints.add((RenderingHints)new Hints(JAI.KEY_IMAGE_LAYOUT, (Object)layout));
            Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
            ParameterValueGroup parameters = operation.getParameters();
            parameters.parameter("Source").setValue((Object)sourceGC);
            parameters.parameter("warp").setValue((Object)warp);
            parameters.parameter("interpolation").setValue((Object)(interpolation != null ? interpolation : InterpolationPolicy.getDefaultPolicy().getInterpolation()));
            parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
            GridCoverage2D gc = (GridCoverage2D)CoverageProcessor.getInstance().doOperation(parameters, hints);
            return gc;
        }
    }
    ,
    ScaleAxesByFactor{

        @Override
        public GridCoverage2D scale(GridCoverage2D sourceGC, ScalingType scaling, Interpolation interpolation, Hints hints, WCSInfo wcsinfo) {
            Utilities.ensureNonNull((String)"sourceGC", (Object)sourceGC);
            Utilities.ensureNonNull((String)"ScalingType", (Object)scaling);
            double[] scaleFactors = 5.getScaleFactors(scaling);
            scaleFactors = ScalingPolicy.arrangeScaleFactors(hints, scaleFactors);
            double scaleFactorX = scaleFactors[0];
            double scaleFactorY = scaleFactors[1];
            if (scaleFactorX == 1.0 && scaleFactorY == 1.0) {
                if (interpolation instanceof InterpolationNearest) {
                    return sourceGC;
                }
                Operation operation = CoverageProcessor.getInstance().getOperation("Warp");
                ParameterValueGroup parameters = operation.getParameters();
                parameters.parameter("Source").setValue((Object)sourceGC);
                parameters.parameter("warp").setValue((Object)new WarpAffine(AffineTransform.getScaleInstance(1.0, 1.0)));
                parameters.parameter("interpolation").setValue((Object)interpolation);
                parameters.parameter("backgroundValues").setValue((Object)CoverageUtilities.getBackgroundValues((GridCoverage2D)sourceGC));
                return (GridCoverage2D)CoverageProcessor.getInstance((Hints)hints).doOperation(parameters, hints);
            }
            GridGeometry2D gridGeometry = sourceGC.getGridGeometry();
            GridEnvelope gridRange = gridGeometry.getGridRange();
            WCSUtils.checkOutputLimits((WCSInfo)wcsinfo, (GridEnvelope2D)new GridEnvelope2D(0, 0, (int)((double)gridRange.getSpan(gridGeometry.gridDimensionX) * scaleFactorX), (int)((double)gridRange.getSpan(gridGeometry.gridDimensionY) * scaleFactorY)), (SampleModel)sourceGC.getRenderedImage().getSampleModel());
            Operation operation = CoverageProcessor.getInstance().getOperation("Scale");
            ParameterValueGroup parameters = operation.getParameters();
            parameters.parameter("Source").setValue((Object)sourceGC);
            parameters.parameter("interpolation").setValue((Object)(interpolation != null ? interpolation : InterpolationPolicy.getDefaultPolicy().getInterpolation()));
            parameters.parameter("xScale").setValue(scaleFactors[0]);
            parameters.parameter("yScale").setValue(scaleFactors[1]);
            parameters.parameter("xTrans").setValue(0.0);
            parameters.parameter("yTrans").setValue(0.0);
            return (GridCoverage2D)CoverageProcessor.getInstance((Hints)hints).doOperation(parameters, hints);
        }
    };


    public abstract GridCoverage2D scale(GridCoverage2D var1, ScalingType var2, Interpolation var3, Hints var4, WCSInfo var5);

    public static ScalingPolicy getPolicy(ScalingType scaling) {
        if (scaling != null) {
            if (scaling.getScaleAxesByFactor() != null) {
                return ScaleAxesByFactor;
            }
            if (scaling.getScaleByFactor() != null) {
                return ScaleByFactor;
            }
            if (scaling.getScaleToExtent() != null) {
                return ScaleToExtent;
            }
            if (scaling.getScaleToSize() != null) {
                return ScaleToSize;
            }
        }
        return DoNothing;
    }

    public static int[] getTargetSize(ScalingType scaling) {
        if (scaling.getScaleToSize() != null) {
            ScaleToSizeType scaleType = scaling.getScaleToSize();
            EList targetAxisSizeElements = scaleType.getTargetAxisSize();
            TargetAxisSizeType xSize = null;
            TargetAxisSizeType ySize = null;
            for (TargetAxisSizeType axisSizeType : targetAxisSizeElements) {
                String axisName = axisSizeType.getAxis();
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/i") || axisName.equals("i")) {
                    xSize = axisSizeType;
                    continue;
                }
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/j") || axisName.equals("j")) {
                    ySize = axisSizeType;
                    continue;
                }
                throw new WCS20Exception("Scale Axis Undefined", WCS20Exception.WCS20ExceptionCode.ScaleAxisUndefined, axisName);
            }
            int sizeX = (int)xSize.getTargetSize();
            if (sizeX <= 0) {
                throw new WCS20Exception("Invalid target size", WCS20Exception.WCS20ExceptionCode.InvalidExtent, Integer.toString(sizeX));
            }
            int sizeY = (int)ySize.getTargetSize();
            if (sizeY <= 0) {
                throw new WCS20Exception("Invalid target size", WCS20Exception.WCS20ExceptionCode.InvalidExtent, Integer.toString(sizeY));
            }
            return new int[]{sizeX, sizeY};
        }
        if (scaling.getScaleToExtent() != null) {
            ScaleToExtentType ste = scaling.getScaleToExtent();
            TargetAxisExtentType xSize = null;
            TargetAxisExtentType ySize = null;
            for (TargetAxisExtentType axisSizeType : ste.getTargetAxisExtent()) {
                String axisName = axisSizeType.getAxis();
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/i") || axisName.equals("i")) {
                    xSize = axisSizeType;
                    continue;
                }
                if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/j") || axisName.equals("j")) {
                    ySize = axisSizeType;
                    continue;
                }
                throw new WCS20Exception("Scale Axis Undefined", WCS20Exception.WCS20ExceptionCode.ScaleAxisUndefined, axisName);
            }
            int sizeX = (int)(xSize.getHigh() - xSize.getLow());
            if (sizeX <= 0) {
                throw new WCS20Exception("Invalid target extent, high is greater than low", WCS20Exception.WCS20ExceptionCode.InvalidExtent, Integer.toString((int)xSize.getHigh()));
            }
            int sizeY = (int)(ySize.getHigh() - ySize.getLow());
            if (sizeY <= 0) {
                throw new WCS20Exception("Invalid target extent, high is greater than low", WCS20Exception.WCS20ExceptionCode.InvalidExtent, Integer.toString((int)ySize.getHigh()));
            }
            return new int[]{sizeX, sizeY};
        }
        throw new IllegalArgumentException("targe size can not be computed from this type of scaling: " + ScalingPolicy.getPolicy(scaling));
    }

    public static double[] getScaleFactors(ScalingType scaling) {
        ScalingPolicy policy = ScalingPolicy.getPolicy(scaling);
        switch (policy) {
            case ScaleByFactor: {
                ScaleByFactorType scaleByFactorType = scaling.getScaleByFactor();
                double scaleFactor = scaleByFactorType.getScaleFactor();
                if (scaleFactor <= 0.0) {
                    throw new WCS20Exception("Invalid scale factor, needs to be a positive number", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, Double.toString(scaleFactor));
                }
                return new double[]{scaleFactor, scaleFactor};
            }
            case ScaleAxesByFactor: {
                ScaleAxisByFactorType scaleType = scaling.getScaleAxesByFactor();
                EList targetAxisScaleElements = scaleType.getScaleAxis();
                ScaleAxisType xScale = null;
                ScaleAxisType yScale = null;
                for (ScaleAxisType scaleAxisType : targetAxisScaleElements) {
                    String axisName = scaleAxisType.getAxis();
                    if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/i") || axisName.equals("i")) {
                        xScale = scaleAxisType;
                        continue;
                    }
                    if (axisName.equals("http://www.opengis.net/def/axis/OGC/1/j") || axisName.equals("j")) {
                        yScale = scaleAxisType;
                        continue;
                    }
                    throw new WCS20Exception("Scale Axis Undefined", WCS20Exception.WCS20ExceptionCode.ScaleAxisUndefined, axisName);
                }
                if (xScale == null) {
                    throw new WCS20Exception("Missing scale factor along i", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, "Null");
                }
                if (yScale == null) {
                    throw new WCS20Exception("Missing scale factor along j", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, "Null");
                }
                double scaleFactorX = xScale.getScaleFactor();
                if (scaleFactorX <= 0.0) {
                    throw new WCS20Exception("Invalid scale factor", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, Double.toString(scaleFactorX));
                }
                double scaleFactorY = yScale.getScaleFactor();
                if (scaleFactorY <= 0.0) {
                    throw new WCS20Exception("Invalid scale factor", WCS20Exception.WCS20ExceptionCode.InvalidScaleFactor, Double.toString(scaleFactorY));
                }
                return new double[]{scaleFactorX, scaleFactorY};
            }
        }
        throw new IllegalArgumentException("scale factors can not be computed from this type of scaling: " + policy);
    }

    private static double[] arrangeScaleFactors(Hints hints, double[] scaleFactors) {
        Double[] preAppliedScale;
        if (hints != null && hints.containsKey((Object)GetCoverage.PRE_APPLIED_SCALE) && (preAppliedScale = (Double[])hints.get((Object)GetCoverage.PRE_APPLIED_SCALE)) != null) {
            scaleFactors[0] = scaleFactors[0] * preAppliedScale[0];
            scaleFactors[1] = scaleFactors[1] * preAppliedScale[1];
        }
        return scaleFactors;
    }
}

