/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.v1_1.bindings;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import net.opengis.wcs11.TimePeriodType;
import net.opengis.wcs11.TimeSequenceType;
import net.opengis.wcs11.Wcs111Factory;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.gml3.GML;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.wcs.v1_1.WCS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimeSequenceTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return WCS.TimeSequenceType;
    }

    public Class getType() {
        return TimeSequenceType.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List<Node> timePositions = node.getChildren("timePosition");
        TimeSequenceType results = Wcs111Factory.eINSTANCE.createTimeSequenceType();
        if (timePositions != null && !timePositions.isEmpty()) {
            for (Node timePositionNode : timePositions) {
                Date positionDate = ((Position)timePositionNode.getValue()).getDate();
                results.getTimePosition().add((Object)TimeSequenceTypeBinding.cvtToGmt(positionDate));
            }
            return results;
        }
        List<Node> timePeriods = node.getChildren("TimePeriod");
        if (timePeriods != null && !timePeriods.isEmpty()) {
            for (Node timePeriodNode : timePeriods) {
                DefaultInstant begining = new DefaultInstant((Position)timePeriodNode.getChild("BeginPosition").getValue());
                DefaultInstant ending = new DefaultInstant((Position)timePeriodNode.getChild("EndPosition").getValue());
                TimePeriodType timePeriod = Wcs111Factory.eINSTANCE.createTimePeriodType();
                Date beginPosition = TimeSequenceTypeBinding.cvtToGmt(begining.getPosition().getDate());
                Date endPosition = TimeSequenceTypeBinding.cvtToGmt(ending.getPosition().getDate());
                timePeriod.setBeginPosition((Object)beginPosition);
                timePeriod.setEndPosition((Object)endPosition);
                results.getTimePeriod().add((Object)timePeriod);
            }
            return results;
        }
        return results;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        List timeSequence = (List)object;
        if (timeSequence == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        List timeSequence = (List)object;
        if (timeSequence == null || timeSequence.isEmpty()) {
            return null;
        }
        if (name.getLocalPart().equals("timePeriod") && timeSequence.get(0) instanceof Period) {
            return timeSequence;
        }
        if (name.getLocalPart().equals("timePosition") && timeSequence.get(0) instanceof Position) {
            LinkedList<Position> result = new LinkedList<Position>();
            List positions = timeSequence;
            for (Position position : positions) {
                result.add(position);
            }
            return result;
        }
        return null;
    }

    private static Date cvtToGmt(Date date) {
        Date dstDate;
        Date ret;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(ret = new Date(date.getTime() - (long)tz.getRawOffset())) && tz.inDaylightTime(dstDate = new Date(ret.getTime() - (long)tz.getDSTSavings()))) {
            ret = dstDate;
        }
        return ret;
    }
}

