/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml4wcs.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.geometry.Position;
import org.geotools.geometry.GeneralPosition;
import org.geotools.gml4wcs.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return GML.DirectPositionType;
    }

    public Class getType() {
        return Position.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        GeneralPosition dp = null;
        if ("pos".equals(instance.getName())) {
            String[] CP = instance.getText().split(" ");
            double[] coordinates = new double[CP.length];
            int c = 0;
            for (String coord : CP) {
                coordinates[c++] = Double.parseDouble(coord.trim());
            }
            dp = new GeneralPosition(coordinates);
        }
        return dp;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        Position dp = (Position)object;
        if (dp == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", org.geotools.gml3.GML.Null.getLocalPart()));
        } else {
            double[] coordinates = dp.getCoordinate();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < coordinates.length; ++i) {
                sb.append(String.valueOf(coordinates[i]));
                if (i == coordinates.length - 1) continue;
                sb.append(" ");
            }
            value.appendChild(document.createTextNode(sb.toString()));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        Position dp = (Position)object;
        if (name.getLocalPart().equals("dimension")) {
            return dp.getDimension();
        }
        return null;
    }
}

