/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.java2d.marlin.ArrayCacheInt;
import sun.java2d.marlin.ArrayCacheIntClean;

public final class TestArrayCacheInt {
    static final int INITIAL_CAPACITY = 1024;
    static final int MIN_CACHE_CAPACITY = 4096;
    static final int MAX_CACHE_CAPACITY = 0x1000000;
    static final int RATIO_8TH = 9;
    static final boolean TRACE = false;

    private TestArrayCacheInt() {
    }

    public static int testWidenDirtyArrayCacheInt(ContextWidenArray ctx, int n) {
        return ctx.testWidenDirtyArrayCacheInt(n);
    }

    public static int testWidenCleanArrayCacheInt(ContextWidenArray ctx, int n) {
        return ctx.testWidenCleanArrayCacheInt(n);
    }

    public static int testWidenArrayAlloc(ContextWidenArray ctx, int n) {
        return ctx.testWidenArrayAlloc(n);
    }

    public static void main(String[] unused) {
        int res;
        int i;
        ContextWidenArray ctx = new ContextWidenArray();
        int max = 0x1200000;
        int N = 100;
        System.out.println("testWidenDirtyArrayCacheInt(18874368)");
        for (i = 0; i < 100; ++i) {
            res = TestArrayCacheInt.testWidenDirtyArrayCacheInt(ctx, 0x1200000);
            System.out.println("testWidenDirtyArrayCacheInt[" + i + "] : " + res);
        }
        System.out.println("testWidenCleanArrayCacheInt(18874368)");
        for (i = 0; i < 100; ++i) {
            res = TestArrayCacheInt.testWidenCleanArrayCacheInt(ctx, 0x1200000);
            System.out.println("testWidenCleanArrayCacheInt[" + i + "] : " + res);
        }
        System.out.println("testWidenArrayAlloc(18874368)");
        for (i = 0; i < 100; ++i) {
            res = TestArrayCacheInt.testWidenArrayAlloc(ctx, 0x1200000);
            System.out.println("testWidenArrayAlloc[" + i + "] : " + res);
        }
    }

    public static final class ContextWidenArray {
        private final ArrayCacheIntClean cleanIntCache = new ArrayCacheIntClean(5);
        private final ArrayCacheInt dirtyIntCache = new ArrayCacheInt(5);
        private final ArrayCacheInt.Reference edgePtrs_ref = this.newDirtyIntArrayRef(1024);
        private int[] edgePtrs;
        private final ArrayCacheIntClean.Reference edgePtrs_ref_Cl;
        private int[] edgePtrs_Cl;

        public ContextWidenArray() {
            this.edgePtrs = this.edgePtrs_ref.initial;
            this.edgePtrs_ref_Cl = this.newCleanIntArrayRef(1024);
            this.edgePtrs_Cl = this.edgePtrs_ref_Cl.initial;
        }

        public int testWidenDirtyArrayCacheInt(int max) {
            int[] _edgePtrs = this.edgePtrs;
            int edgePtrsLen = _edgePtrs.length;
            int sum = 0;
            for (int i = edgePtrsLen; i <= max; i *= 2) {
                int ptrEnd = i;
                if (edgePtrsLen < ptrEnd) {
                    this.edgePtrs = _edgePtrs = this.edgePtrs_ref.widenArray(_edgePtrs, edgePtrsLen, ptrEnd);
                    edgePtrsLen = _edgePtrs.length;
                }
                int n = i;
                _edgePtrs[i - 1] = n;
                sum += n;
            }
            this.disposeDirtyArrayCacheInt();
            return sum;
        }

        private void disposeDirtyArrayCacheInt() {
            if (this.edgePtrs_ref.doCleanRef(this.edgePtrs)) {
                this.edgePtrs = this.edgePtrs_ref.putArray(this.edgePtrs);
            }
        }

        private ArrayCacheInt.Reference newDirtyIntArrayRef(int initialSize) {
            return this.dirtyIntCache.createRef(initialSize);
        }

        public int testWidenCleanArrayCacheInt(int max) {
            int[] _edgePtrs = this.edgePtrs_Cl;
            int edgePtrsLen = _edgePtrs.length;
            int sum = 0;
            int ptrEnd = 0;
            for (int i = edgePtrsLen; i <= max; i *= 2) {
                ptrEnd = i;
                if (edgePtrsLen < ptrEnd) {
                    this.edgePtrs_Cl = _edgePtrs = this.edgePtrs_ref_Cl.widenArray(_edgePtrs, edgePtrsLen, ptrEnd);
                    edgePtrsLen = _edgePtrs.length;
                }
                int n = i;
                _edgePtrs[i - 1] = n;
                sum += n;
            }
            this.disposeCleanArrayCacheInt(ptrEnd);
            return sum;
        }

        private void disposeCleanArrayCacheInt(int max) {
            this.edgePtrs_Cl = this.edgePtrs_ref_Cl.putArray(this.edgePtrs_Cl, 0, max);
        }

        private ArrayCacheIntClean.Reference newCleanIntArrayRef(int initialSize) {
            return this.cleanIntCache.createRef(initialSize);
        }

        public int testWidenArrayAlloc(int max) {
            int[] _edgePtrs = this.edgePtrs_ref.initial;
            int edgePtrsLen = _edgePtrs.length;
            int sum = 0;
            for (int i = edgePtrsLen; i <= max; i *= 2) {
                int ptrEnd = i;
                if (edgePtrsLen < ptrEnd) {
                    _edgePtrs = ContextWidenArray.widenArray(_edgePtrs, edgePtrsLen, ptrEnd - edgePtrsLen);
                    this.edgePtrs = _edgePtrs;
                    edgePtrsLen = _edgePtrs.length;
                }
                int n = i;
                _edgePtrs[i - 1] = n;
                sum += n;
            }
            return sum;
        }

        static int[] widenArray(int[] in, int cursize, int numToAdd) {
            if (in.length >= cursize + numToAdd) {
                return in;
            }
            return Arrays.copyOf(in, 2 * (cursize + numToAdd));
        }
    }
}

