/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.DPQSSorterContext;

public final class DualPivotQuicksort20191112Ext {
    private static final boolean FAST_ISORT = true;
    private static final int MAX_MIXED_INSERTION_SORT_SIZE = 65;
    private static final int MAX_INSERTION_SORT_SIZE = 44;
    private static final int MIN_TRY_MERGE_SIZE = 4096;
    private static final int MIN_FIRST_RUN_SIZE = 16;
    private static final int MIN_FIRST_RUNS_FACTOR = 7;
    static final int MAX_RUN_CAPACITY = 5120;
    private static final int DELTA = 6;
    private static final int MAX_RECURSION_DEPTH = 384;

    private DualPivotQuicksort20191112Ext() {
    }

    static void sort(DPQSSorterContext sorter, int[] a, int[] auxA, int[] b, int[] auxB, int low, int high) {
        if (high - low <= 44) {
            DualPivotQuicksort20191112Ext.insertionSort(a, b, low, high);
            return;
        }
        sorter.initBuffers(high, auxA, auxB);
        DualPivotQuicksort20191112Ext.sort(sorter, a, b, 0, low, high);
    }

    private static void sort(DPQSSorterContext sorter, int[] a, int[] b, int bits, int low, int high) {
        while (true) {
            int t;
            int end = high - 1;
            int size = high - low;
            if (size < 65 + bits && (bits & 1) > 0) {
                DualPivotQuicksort20191112Ext.mixedInsertionSort(a, b, low, high - 3 * (size >> 5 << 3), high);
                return;
            }
            if (size < 44) {
                DualPivotQuicksort20191112Ext.insertionSort(a, b, low, high);
                return;
            }
            if ((bits == 0 || size > 4096 && (bits & 1) > 0) && DualPivotQuicksort20191112Ext.tryMergeRuns(sorter, a, b, low, size)) {
                return;
            }
            if ((bits += 6) > 384) {
                DualPivotQuicksort20191112Ext.heapSort(a, b, low, high);
                return;
            }
            int step = (size >> 3) * 3 + 3;
            int e1 = low + step;
            int e5 = end - step;
            int e3 = e1 + e5 >>> 1;
            int e2 = e1 + e3 >>> 1;
            int e4 = e3 + e5 >>> 1;
            int a3 = a[e3];
            if (a[e5] < a[e2]) {
                t = a[e5];
                a[e5] = a[e2];
                a[e2] = t;
            }
            if (a[e4] < a[e1]) {
                t = a[e4];
                a[e4] = a[e1];
                a[e1] = t;
            }
            if (a[e5] < a[e4]) {
                t = a[e5];
                a[e5] = a[e4];
                a[e4] = t;
            }
            if (a[e2] < a[e1]) {
                t = a[e2];
                a[e2] = a[e1];
                a[e1] = t;
            }
            if (a[e4] < a[e2]) {
                t = a[e4];
                a[e4] = a[e2];
                a[e2] = t;
            }
            if (a3 < a[e2]) {
                if (a3 < a[e1]) {
                    a[e3] = a[e2];
                    a[e2] = a[e1];
                    a[e1] = a3;
                } else {
                    a[e3] = a[e2];
                    a[e2] = a3;
                }
            } else if (a3 > a[e4]) {
                if (a3 > a[e5]) {
                    a[e3] = a[e4];
                    a[e4] = a[e5];
                    a[e5] = a3;
                } else {
                    a[e3] = a[e4];
                    a[e4] = a3;
                }
            }
            int lower = low;
            int upper = end;
            if (a[e1] < a[e2] && a[e2] < a[e3] && a[e3] < a[e4] && a[e4] < a[e5]) {
                int pivotA1 = a[e1];
                int pivotA2 = a[e5];
                int pivotB1 = b[e1];
                int pivotB2 = b[e5];
                a[e1] = a[lower];
                a[e5] = a[upper];
                b[e1] = b[lower];
                b[e5] = b[upper];
                while (a[++lower] < pivotA1) {
                }
                while (a[--upper] > pivotA2) {
                }
                int unused = --lower;
                int k = ++upper;
                block3: while (--k > lower) {
                    int ak = a[k];
                    int bk = b[k];
                    if (ak < pivotA1) {
                        while (lower < k) {
                            if (a[++lower] < pivotA1) continue;
                            if (a[lower] > pivotA2) {
                                a[k] = a[--upper];
                                a[upper] = a[lower];
                                b[k] = b[upper];
                                b[upper] = b[lower];
                            } else {
                                a[k] = a[lower];
                                b[k] = b[lower];
                            }
                            a[lower] = ak;
                            b[lower] = bk;
                            continue block3;
                        }
                        continue;
                    }
                    if (ak <= pivotA2) continue;
                    a[k] = a[--upper];
                    a[upper] = ak;
                    b[k] = b[upper];
                    b[upper] = bk;
                }
                a[low] = a[lower];
                a[lower] = pivotA1;
                a[end] = a[upper];
                a[upper] = pivotA2;
                b[low] = b[lower];
                b[lower] = pivotB1;
                b[end] = b[upper];
                b[upper] = pivotB2;
                DualPivotQuicksort20191112Ext.sort(sorter, a, b, bits | 1, lower + 1, upper);
                DualPivotQuicksort20191112Ext.sort(sorter, a, b, bits | 1, upper + 1, high);
            } else {
                int pivotA = a[e3];
                int pivotB = b[e3];
                a[e3] = a[lower];
                b[e3] = b[lower];
                int k = ++upper;
                while (--k > lower) {
                    int ak = a[k];
                    if (ak == pivotA) continue;
                    a[k] = pivotA;
                    int bk = b[k];
                    if (ak < pivotA) {
                        while (a[++lower] < pivotA) {
                        }
                        if (a[lower] > pivotA) {
                            a[k] = a[--upper];
                            a[upper] = a[lower];
                            b[k] = b[upper];
                            b[upper] = b[lower];
                        } else {
                            a[k] = a[lower];
                            b[k] = b[lower];
                        }
                        a[lower] = ak;
                        b[lower] = bk;
                        continue;
                    }
                    a[k] = a[--upper];
                    a[upper] = ak;
                    b[k] = b[upper];
                    b[upper] = bk;
                }
                a[low] = a[lower];
                a[lower] = pivotA;
                b[low] = b[lower];
                b[lower] = pivotB;
                DualPivotQuicksort20191112Ext.sort(sorter, a, b, bits | 1, upper, high);
            }
            high = lower;
        }
    }

    private static void mixedInsertionSort(int[] a, int[] b, int low, int end, int high) {
        if (end == high) {
            while (++low < end) {
                int i = low;
                int ai = a[i];
                if (ai >= a[i - 1]) continue;
                int bi = b[i];
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                    b[i + 1] = b[i];
                }
                a[i + 1] = ai;
                b[i + 1] = bi;
            }
        } else {
            int i;
            int pin = a[end];
            int p = high;
            while (++low < end) {
                i = low;
                int ai = a[i];
                int bi = b[i];
                if (ai < a[i - 1]) {
                    a[i] = a[i - 1];
                    b[i--] = b[i];
                    while (ai < a[--i]) {
                        a[i + 1] = a[i];
                        b[i + 1] = b[i];
                    }
                    a[i + 1] = ai;
                    b[i + 1] = bi;
                    continue;
                }
                if (p <= i || ai <= pin) continue;
                while (a[--p] > pin) {
                }
                if (p > i) {
                    ai = a[p];
                    a[p] = a[i];
                    bi = b[p];
                    b[p] = b[i];
                }
                while (ai < a[--i]) {
                    a[i + 1] = a[i];
                    b[i + 1] = b[i];
                }
                a[i + 1] = ai;
                b[i + 1] = bi;
            }
            while (low < high) {
                i = low++;
                int a1 = a[i];
                int a2 = a[low];
                int b1 = b[i];
                int b2 = b[low];
                if (a1 > a2) {
                    while (a1 < a[--i]) {
                        a[i + 2] = a[i];
                        b[i + 2] = b[i];
                    }
                    a[++i + 1] = a1;
                    b[i + 1] = b1;
                    while (a2 < a[--i]) {
                        a[i + 1] = a[i];
                        b[i + 1] = b[i];
                    }
                    a[i + 1] = a2;
                    b[i + 1] = b2;
                } else if (a1 < a[i - 1]) {
                    while (a2 < a[--i]) {
                        a[i + 2] = a[i];
                        b[i + 2] = b[i];
                    }
                    a[++i + 1] = a2;
                    b[i + 1] = b2;
                    while (a1 < a[--i]) {
                        a[i + 1] = a[i];
                        b[i + 1] = b[i];
                    }
                    a[i + 1] = a1;
                    b[i + 1] = b1;
                }
                ++low;
            }
        }
    }

    static void insertionSort(int[] a, int[] b, int low, int high) {
        int k = low;
        while (++k < high) {
            int i = k;
            int ai = a[i];
            if (ai >= a[i - 1]) continue;
            int bi = b[i];
            while (--i >= low && ai < a[i]) {
                a[i + 1] = a[i];
                b[i + 1] = b[i];
            }
            a[i + 1] = ai;
            b[i + 1] = bi;
        }
    }

    private static void heapSort(int[] a, int[] b, int low, int high) {
        int k = low + high >>> 1;
        while (k > low) {
            DualPivotQuicksort20191112Ext.pushDown(a, b, --k, a[k], b[k], low, high);
        }
        while (--high > low) {
            int maxA = a[low];
            int maxB = b[low];
            DualPivotQuicksort20191112Ext.pushDown(a, b, low, a[high], b[high], low, high);
            a[high] = maxA;
            b[high] = maxB;
        }
    }

    private static void pushDown(int[] a, int[] b, int p, int valueA, int valueB, int low, int high) {
        int k;
        while ((k = (p << 1) - low + 2) <= high) {
            if (k == high || a[k] < a[k - 1]) {
                --k;
            }
            if (a[k] <= valueA) break;
            a[p] = a[k];
            int n = p;
            p = k;
            b[n] = b[p];
        }
        a[p] = valueA;
        b[p] = valueB;
    }

    private static boolean tryMergeRuns(DPQSSorterContext sorter, int[] a, int[] b, int low, int size) {
        int[] run = null;
        int high = low + size;
        int count = 1;
        int last = low;
        int k = low + 1;
        while (k < high) {
            if (a[k - 1] < a[k]) {
                while (++k < high && a[k - 1] <= a[k]) {
                }
            } else if (a[k - 1] > a[k]) {
                while (++k < high && a[k - 1] >= a[k]) {
                }
                int i = last - 1;
                int j = k;
                while (++i < --j && a[i] > a[j]) {
                    int t = a[i];
                    a[i] = a[j];
                    a[j] = t;
                    t = b[i];
                    b[i] = b[j];
                    b[j] = t;
                }
            } else {
                int ak = a[k];
                while (++k < high && ak == a[k]) {
                }
                if (k < high) continue;
            }
            if (sorter.runInit || run == null) {
                sorter.runInit = false;
                if (k == high) {
                    return true;
                }
                if (k - low < 16) {
                    return false;
                }
                run = sorter.run;
                run[0] = low;
            } else if (a[last - 1] > a[last]) {
                if (count > k - low >> 7) {
                    return false;
                }
                if (++count == 5120) {
                    return false;
                }
            }
            run[count] = last = k;
            if (k >= high - 1) continue;
            ++k;
        }
        if (count > 1) {
            int[] auxA = sorter.auxA;
            int[] auxB = sorter.auxB;
            int offset = low;
            if (auxA.length < size || auxB.length < size) {
                auxA = new int[size];
                auxB = new int[size];
            }
            DualPivotQuicksort20191112Ext.mergeRuns(a, auxA, b, auxB, offset, 1, run, 0, count);
        }
        return true;
    }

    private static int[] mergeRuns(int[] srcA, int[] dstA, int[] srcB, int[] dstB, int offset, int aim, int[] run, int lo, int hi) {
        if (hi - lo == 1) {
            if (aim >= 0) {
                return srcA;
            }
            int i = run[hi];
            int j = i - offset;
            int low = run[lo];
            while (i > low) {
                dstA[--j] = srcA[--i];
                dstB[j] = srcB[i];
            }
            return dstA;
        }
        int mi = lo;
        int rmi = run[lo] + run[hi] >>> 1;
        while (run[++mi + 1] <= rmi) {
        }
        int[] a1 = DualPivotQuicksort20191112Ext.mergeRuns(srcA, dstA, srcB, dstB, offset, -aim, run, lo, mi);
        int[] a2 = DualPivotQuicksort20191112Ext.mergeRuns(srcA, dstA, srcB, dstB, offset, 0, run, mi, hi);
        int[] b1 = a1 == srcA ? srcB : dstB;
        int[] b2 = a2 == srcA ? srcB : dstB;
        int[] resA = a1 == srcA ? dstA : srcA;
        int[] resB = a1 == srcA ? dstB : srcB;
        int k = a1 == srcA ? run[lo] - offset : run[lo];
        int lo1 = a1 == dstA ? run[lo] - offset : run[lo];
        int hi1 = a1 == dstA ? run[mi] - offset : run[mi];
        int lo2 = a2 == dstA ? run[mi] - offset : run[mi];
        int hi2 = a2 == dstA ? run[hi] - offset : run[hi];
        DualPivotQuicksort20191112Ext.mergeParts(resA, resB, k, a1, b1, lo1, hi1, a2, b2, lo2, hi2);
        return resA;
    }

    private static void mergeParts(int[] dstA, int[] dstB, int k, int[] a1, int[] b1, int lo1, int hi1, int[] a2, int[] b2, int lo2, int hi2) {
        while (lo1 < hi1 && lo2 < hi2) {
            if (a1[lo1] < a2[lo2]) {
                dstA[k] = a1[lo1];
                dstB[k] = b1[lo1];
                ++k;
                ++lo1;
                continue;
            }
            dstA[k] = a2[lo2];
            dstB[k] = b2[lo2];
            ++k;
            ++lo2;
        }
        if (dstA != a1 || k < lo1) {
            while (lo1 < hi1) {
                dstA[k] = a1[lo1];
                dstB[k] = b1[lo1];
                ++k;
                ++lo1;
            }
        }
        if (dstA != a2 || k < lo2) {
            while (lo2 < hi2) {
                dstA[k] = a2[lo2];
                dstB[k] = b2[lo2];
                ++k;
                ++lo2;
            }
        }
    }
}

