/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.controller.GWCController;
import org.geowebcache.rest.converter.XStreamListAliasWrapper;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class TileLayerController
extends GWCController {
    @Autowired
    TileLayerDispatcher layerDispatcher;
    @Autowired
    private StorageBroker storageBroker;

    public void setStorageBroker(StorageBroker storageBroker) {
        this.storageBroker = storageBroker;
    }

    @RequestMapping(value={"/layers"}, method={RequestMethod.GET})
    public XStreamListAliasWrapper layersGet(HttpServletRequest request) {
        return new XStreamListAliasWrapper(this.layerDispatcher.getLayerNames(), "layer", Set.class, this.getClass());
    }

    @RequestMapping(value={"/layers/{layer}"}, method={RequestMethod.GET})
    public TileLayer layerGet(@PathVariable String layer) {
        return TileLayerController.findTileLayer(layer, this.layerDispatcher);
    }

    @Deprecated
    @RequestMapping(value={"/layers/{layerName}"}, method={RequestMethod.POST})
    public ResponseEntity<?> layerPost(@RequestBody TileLayer tl, @PathVariable String layerName) throws GeoWebCacheException, RestException, IOException {
        tl = this.checkLayer(layerName, tl);
        try {
            this.layerDispatcher.modify(tl);
        }
        catch (IllegalArgumentException e) {
            return new ResponseEntity((Object)("Layer " + tl.getName() + " is not known by the configuration.Maybe it was loaded from another source, or you're trying to add a new layer and need to do an HTTP PUT ?"), HttpStatus.BAD_REQUEST);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Warning", "299: Deprecated API. Use PUT instead.");
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/layers/{layerName}"}, method={RequestMethod.PUT})
    public ResponseEntity<?> layerPut(@RequestBody TileLayer tl, @PathVariable String layerName) throws GeoWebCacheException, RestException, IOException {
        tl = this.checkLayer(layerName, tl);
        TileLayer testtl = null;
        try {
            testtl = TileLayerController.findTileLayer(tl.getName(), this.layerDispatcher);
        }
        catch (RestException restException) {
            // empty catch block
        }
        if (testtl == null) {
            this.layerDispatcher.addLayer(tl);
        } else {
            this.layerDispatcher.modify(tl);
        }
        return new ResponseEntity((Object)"layer saved", HttpStatus.OK);
    }

    @RequestMapping(value={"/layers/{layer}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> doDelete(HttpServletRequest req, @PathVariable String layer) throws GeoWebCacheException, RestException, IOException {
        String layerName = layer;
        TileLayerController.findTileLayer(layerName, this.layerDispatcher);
        StorageException storageBrokerDeleteException = null;
        try {
            this.storageBroker.delete(layerName);
        }
        catch (StorageException se) {
            storageBrokerDeleteException = se;
        }
        try {
            this.layerDispatcher.removeLayer(layerName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
        if (storageBrokerDeleteException != null) {
            throw new RestException("Removal of layer " + layerName + " was successful but deletion of cached tiles failed: " + storageBrokerDeleteException.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, storageBrokerDeleteException);
        }
        return new ResponseEntity((Object)(layerName + " deleted"), HttpStatus.OK);
    }

    protected TileLayer checkLayer(String layerName, TileLayer newLayer) throws RestException, IOException {
        if (!newLayer.getName().equals(layerName)) {
            throw new RestException("There is a mismatch between the name of the  layer in the submission and the URL you specified.", HttpStatus.BAD_REQUEST);
        }
        if (newLayer.getParameterFilters() != null) {
            try {
                for (ParameterFilter parameterFilter : newLayer.getParameterFilters()) {
                }
            }
            catch (ClassCastException ex) {
                throw new RestException("parameterFilters contains an element that is not a known ParameterFilter", HttpStatus.BAD_REQUEST);
            }
        }
        return newLayer;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }
}

