/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.rest.service.FormService;
import org.geowebcache.rest.service.SeedService;
import org.geowebcache.seed.TileBreeder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class SeedController {
    @Autowired
    TileBreeder seeder;
    @Autowired
    SeedService seedService;
    @Autowired
    FormService formService;
    @Autowired
    protected DefaultingConfiguration xmlConfig;

    @RequestMapping(value={"/seed.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> doGet(HttpServletRequest req) {
        return this.seedService.getRunningTasks(req);
    }

    @RequestMapping(value={"/seed/{layer:.+}.json"}, method={RequestMethod.GET}, produces={"application/json", "text/plain"})
    public ResponseEntity<?> doGet(@PathVariable String layer) {
        return this.seedService.getRunningLayerTasks(layer);
    }

    @RequestMapping(value={"/seed/{layer:.+}.xml"}, method={RequestMethod.GET}, produces={"application/xml", "text/plain"})
    public ResponseEntity<?> doGetXml(@PathVariable String layer) {
        return this.seedService.getRunningLayerTasksXml(layer);
    }

    @RequestMapping(value={"/seed/{layer:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<?> doFormGet(HttpServletRequest request, @PathVariable String layer) {
        return this.formService.handleGet(request, layer);
    }

    @RequestMapping(value={"/seed"}, method={RequestMethod.POST})
    public ResponseEntity doPost(HttpServletRequest request) {
        String response = this.seedService.handleKillAllThreads(request, null);
        if (response.equalsIgnoreCase("error")) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)response, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/seed/{layer:.+}"}, method={RequestMethod.POST})
    public ResponseEntity<?> doPost(HttpServletRequest request, InputStream inputStream, @PathVariable String layer, @RequestParam Map<String, String> params) {
        String body = this.readBody(inputStream);
        try {
            if (body != null && body.length() > 0) {
                Map<String, String> formMap = this.splitToMap(URLDecoder.decode(body, "UTF-8"));
                params.putAll(formMap);
            }
            return this.handleFormPostInternal(layer, params);
        }
        catch (UnsupportedEncodingException e) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)"Unable to parse form result.", (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/seed/{layer}.json"}, method={RequestMethod.POST})
    public ResponseEntity<?> seedOrTruncateWithJsonPayload(HttpServletRequest request, InputStream inputStream, @PathVariable(name="layer") String layerName) {
        String body = this.readBody(inputStream);
        String extension = "json";
        return this.seedService.doSeeding(request, layerName, extension, body);
    }

    @RequestMapping(value={"/seed/{layer}.xml"}, method={RequestMethod.POST})
    public ResponseEntity<?> seedOrTruncateWithXmlPayload(HttpServletRequest request, InputStream inputStream, @PathVariable(name="layer") String layerName) {
        String body = this.readBody(inputStream);
        String extension = "xml";
        return this.seedService.doSeeding(request, layerName, extension, body);
    }

    private String readBody(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    private ResponseEntity<?> handleFormPostInternal(String layer, Map<String, String> params) {
        try {
            return this.formService.handleFormPost(layer, params);
        }
        catch (GeoWebCacheException e) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((Object)"error", (MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private Map<String, String> splitToMap(String data) {
        if (data.contains("&")) {
            return Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)data);
        }
        return Splitter.on((String)" ").withKeyValueSeparator("=").split((CharSequence)data);
    }

    public void setXmlConfig(DefaultingConfiguration xmlConfig) {
        this.xmlConfig = xmlConfig;
    }
}

