/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.data.store.panel.FileModel;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.browser.FileRootsFinder;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;
import org.geotools.util.logging.Logging;

public class FileInput
extends Panel {
    private static final Logger LOGGER = Logging.getLogger(FileInput.class);
    private final FileRootsFinder rootsFinder;
    protected TextField<String> textField;
    protected GSModalWindow dialog;
    protected IModel<? extends FileFilter> fileFilter;

    @SafeVarargs
    public FileInput(String id, IModel<String> paramValue, IModel<String> paramLabelModel, boolean required, IValidator<? super String> ... validators) {
        super(id, paramValue);
        Component[] componentArray = new Component[1];
        this.dialog = new GSModalWindow("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.rootsFinder = new FileRootsFinder(false);
        this.textField = new AutoCompleteTextField<String>("paramValue", this.getFileModel(paramValue)){

            protected Iterator<String> getChoices(String input) {
                try {
                    FileFilter fileFilter = FileInput.this.fileFilter != null ? (FileFilter)FileInput.this.fileFilter.getObject() : null;
                    return FileInput.this.rootsFinder.getMatches(input, fileFilter).iterator();
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Failed to provide autocomplete for path " + input, e);
                    return Collections.emptyIterator();
                }
            }
        };
        this.textField.setRequired(required);
        this.textField.setOutputMarkupId(true);
        this.textField.setLabel(paramLabelModel);
        if (validators != null) {
            for (IValidator<? super String> validator : validators) {
                this.textField.add(validator);
            }
        }
        FormComponentFeedbackBorder feedback = new FormComponentFeedbackBorder("border");
        feedback.add(new Component[]{this.textField});
        feedback.add(new Component[]{this.chooserButton((String)paramLabelModel.getObject())});
        this.add(new Component[]{feedback});
    }

    protected IModel<String> getFileModel(IModel<String> paramValue) {
        return new FileModel(paramValue);
    }

    protected Component chooserButton(final String windowTitle) {
        AjaxSubmitLink link = new AjaxSubmitLink("chooser"){
            private static final long serialVersionUID = -6640131658256808053L;

            public boolean getDefaultFormProcessing() {
                return false;
            }

            public void onSubmit(AjaxRequestTarget target) {
                File file = null;
                FileInput.this.textField.processInput();
                String input = (String)FileInput.this.textField.getConvertedInput();
                if (input != null && !input.equals("")) {
                    file = new File(input);
                }
                GeoServerFileChooser chooser = new GeoServerFileChooser(FileInput.this.dialog.getContentId(), (IModel)new Model((Serializable)file)){
                    private static final long serialVersionUID = -7096642192491726498L;

                    @Override
                    protected void fileClicked(File file, Optional<AjaxRequestTarget> target) {
                        FileInput.this.textField.clearInput();
                        FileInput.this.textField.setModelObject((Object)file.getAbsolutePath());
                        if (target.isPresent()) {
                            target.get().add(new Component[]{FileInput.this.textField});
                            FileInput.this.dialog.close(target.get());
                        }
                    }
                };
                chooser.setFileTableHeight(null);
                chooser.setFilter(FileInput.this.fileFilter);
                FileInput.this.dialog.setContent((Component)chooser);
                FileInput.this.dialog.setTitle(windowTitle);
                FileInput.this.dialog.show(target);
            }
        };
        return link;
    }

    public FormComponent<String> getFormComponent() {
        return this.textField;
    }

    public void setFileFilter(IModel<? extends FileFilter> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void setPrefixPaths(boolean prefixPaths) {
        this.rootsFinder.setPrefixPaths(prefixPaths);
    }
}

