/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class WKTToCRSModel
implements IModel<CoordinateReferenceSystem> {
    private static final Logger LOGGER = Logging.getLogger(WKTToCRSModel.class);
    IModel<String> srsModel;

    public WKTToCRSModel(IModel<String> srsModel) {
        this.srsModel = srsModel;
    }

    public CoordinateReferenceSystem getObject() {
        String wkt = (String)this.srsModel.getObject();
        try {
            return CRS.parseWKT((String)wkt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setObject(CoordinateReferenceSystem object) {
        CoordinateReferenceSystem crs = object;
        try {
            this.srsModel.setObject((Object)crs.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to lookup the SRS code for " + crs);
            this.srsModel.setObject(null);
        }
    }

    public void detach() {
        this.srsModel.detach();
    }
}

