/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SRSProvider;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class SRSListPanel
extends Panel {
    private static final long serialVersionUID = 3777350932084160337L;
    GeoServerTablePanel<SRSProvider.SRS> table;

    public SRSListPanel(String id) {
        this(id, new SRSProvider());
    }

    public SRSListPanel(String id, SRSProvider srsProvider) {
        super(id);
        this.table = new GeoServerTablePanel<SRSProvider.SRS>("table", (GeoServerDataProvider)srsProvider){
            private static final long serialVersionUID = 6182776235846912573L;

            @Override
            protected Component getComponentForProperty(String id, IModel<SRSProvider.SRS> itemModel, GeoServerDataProvider.Property<SRSProvider.SRS> property) {
                SRSProvider.SRS srs = (SRSProvider.SRS)itemModel.getObject();
                if (SRSProvider.IDENTIFIER.equals(property)) {
                    Component linkForCode = SRSListPanel.this.createLinkForCode(id, itemModel);
                    return linkForCode;
                }
                if (SRSProvider.DESCRIPTION.equals(property)) {
                    String description = srs.getDescription();
                    return new Label(id, (Serializable)((Object)description.trim()));
                }
                throw new IllegalArgumentException("Unknown property: " + property);
            }
        };
        this.add(new Component[]{this.table});
    }

    public void setCompactMode(boolean compact) {
        this.table.getTopPager().setVisible(!compact);
    }

    protected Component createLinkForCode(String linkId, IModel<SRSProvider.SRS> itemModel) {
        return new SimpleAjaxLink<Object>(linkId, SRSProvider.IDENTIFIER.getModel(itemModel)){
            private static final long serialVersionUID = -1330723116026268069L;

            @Override
            protected void onClick(AjaxRequestTarget target) {
                SRSListPanel.this.onCodeClicked(target, this.getDefaultModelObjectAsString());
            }
        };
    }

    protected abstract void onCodeClicked(AjaxRequestTarget var1, String var2);
}

