/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.util.Converters;

public class EnvelopePanel
extends FormComponentPanel<ReferencedEnvelope> {
    private static final long serialVersionUID = -2975427786330616705L;
    protected Label minXLabel;
    protected Label minYLabel;
    protected Label maxXLabel;
    protected Label maxYLabel;
    protected Label minZLabel;
    protected Label maxZLabel;
    protected Double minX;
    protected Double minY;
    protected Double maxX;
    protected Double maxY;
    protected Double minZ;
    protected Double maxZ;
    protected DecimalTextField minXInput;
    protected DecimalTextField minYInput;
    protected DecimalTextField maxXInput;
    protected DecimalTextField maxYInput;
    protected DecimalTextField minZInput;
    protected DecimalTextField maxZInput;
    protected CoordinateReferenceSystem crs;
    protected WebMarkupContainer crsContainer;
    protected CRSPanel crsPanel;
    protected boolean crsRequired;

    public EnvelopePanel(String id) {
        super(id);
        this.initComponents();
    }

    public EnvelopePanel(String id, ReferencedEnvelope e) {
        this(id, (IModel<ReferencedEnvelope>)new Model((Serializable)e));
    }

    public EnvelopePanel(String id, IModel<ReferencedEnvelope> model) {
        super(id, model);
        this.initComponents();
    }

    public void setCRSFieldVisible(boolean visible) {
        this.crsContainer.setVisible(visible);
    }

    public boolean isCRSFieldVisible() {
        return this.crsContainer.isVisible();
    }

    public boolean isCrsRequired() {
        return this.crsRequired;
    }

    public void setCrsRequired(boolean crsRequired) {
        this.crsRequired = crsRequired;
    }

    public boolean is3D() {
        return this.crs != null && this.crs.getCoordinateSystem().getDimension() >= 3;
    }

    public void setLabelsVisibility(boolean visible) {
        this.minXLabel.setVisible(visible);
        this.minYLabel.setVisible(visible);
        this.maxXLabel.setVisible(visible);
        this.maxYLabel.setVisible(visible);
        this.minZLabel.setVisible(visible && this.is3D());
        this.maxZLabel.setVisible(visible && this.is3D());
    }

    void initComponents() {
        this.updateFields();
        Component[] componentArray = new Component[1];
        this.minXLabel = new Label("minXL", (IModel)new ResourceModel("minX"));
        componentArray[0] = this.minXLabel;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.minYLabel = new Label("minYL", (IModel)new ResourceModel("minY"));
        componentArray2[0] = this.minYLabel;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.minZLabel = new Label("minZL", (IModel)new ResourceModel("minZ"));
        componentArray3[0] = this.minZLabel;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.maxXLabel = new Label("maxXL", (IModel)new ResourceModel("maxX"));
        componentArray4[0] = this.maxXLabel;
        this.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.maxYLabel = new Label("maxYL", (IModel)new ResourceModel("maxY"));
        componentArray5[0] = this.maxYLabel;
        this.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.maxZLabel = new Label("maxZL", (IModel)new ResourceModel("maxZ"));
        componentArray6[0] = this.maxZLabel;
        this.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.minXInput = new DecimalTextField("minX", (IModel<Double>)new PropertyModel((Object)this, "minX"));
        componentArray7[0] = this.minXInput;
        this.add(componentArray7);
        Component[] componentArray8 = new Component[1];
        this.minYInput = new DecimalTextField("minY", (IModel<Double>)new PropertyModel((Object)this, "minY"));
        componentArray8[0] = this.minYInput;
        this.add(componentArray8);
        Component[] componentArray9 = new Component[1];
        this.minZInput = new DecimalTextField("minZ", (IModel<Double>)new PropertyModel((Object)this, "minZ"));
        componentArray9[0] = this.minZInput;
        this.add(componentArray9);
        Component[] componentArray10 = new Component[1];
        this.maxXInput = new DecimalTextField("maxX", (IModel<Double>)new PropertyModel((Object)this, "maxX"));
        componentArray10[0] = this.maxXInput;
        this.add(componentArray10);
        Component[] componentArray11 = new Component[1];
        this.maxYInput = new DecimalTextField("maxY", (IModel<Double>)new PropertyModel((Object)this, "maxY"));
        componentArray11[0] = this.maxYInput;
        this.add(componentArray11);
        Component[] componentArray12 = new Component[1];
        this.maxZInput = new DecimalTextField("maxZ", (IModel<Double>)new PropertyModel((Object)this, "maxZ"));
        componentArray12[0] = this.maxZInput;
        this.add(componentArray12);
        this.addBoundingBoxValidators();
        this.minZInput.setVisible(this.is3D());
        this.minZLabel.setVisible(this.is3D());
        this.maxZInput.setVisible(this.is3D());
        this.maxZLabel.setVisible(this.is3D());
        this.crsContainer = new WebMarkupContainer("crsContainer");
        this.crsContainer.setVisible(false);
        this.crsPanel = new CRSPanel("crs", (IModel<CoordinateReferenceSystem>)new PropertyModel((Object)this, "crs"));
        this.crsContainer.add(new Component[]{this.crsPanel});
        this.add(new Component[]{this.crsContainer});
    }

    private void addBoundingBoxValidators() {
        this.minXInput.add((IValidator & Serializable)validatable -> this.validateAxis((IValidatable<Double>)validatable, this.maxXInput, "X"));
        this.minYInput.add((IValidator & Serializable)validatable -> this.validateAxis((IValidatable<Double>)validatable, this.maxYInput, "Y"));
        if (this.is3D()) {
            this.minZInput.add((IValidator & Serializable)validatable -> this.validateAxis((IValidatable<Double>)validatable, this.maxZInput, "Z"));
        }
    }

    private void validateAxis(IValidatable<Double> validatable, DecimalTextField maxValueField, String axis) {
        if (maxValueField.isValid()) {
            maxValueField.convertInput();
            Double convertedValue = (Double)maxValueField.getConvertedInput();
            if (convertedValue != null && (Double)validatable.getValue() >= convertedValue) {
                ValidationError error = new ValidationError();
                error.setMessage((String)new ParamResourceModel("validation.boundingBoxAxisNonPositive", (Component)this, axis).getObject());
                validatable.error((IValidationError)error);
            }
        }
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        Object o = this.getModelObject();
        ReferencedEnvelope e = o instanceof ReferencedEnvelope ? (ReferencedEnvelope)this.getModelObject() : (ReferencedEnvelope)Converters.convert((Object)o, ReferencedEnvelope.class);
        if (e != null) {
            this.minX = e.getMinX();
            this.minY = e.getMinY();
            this.maxX = e.getMaxX();
            this.maxY = e.getMaxY();
            this.crs = e.getCoordinateReferenceSystem();
            if (this.is3D()) {
                if (e instanceof ReferencedEnvelope3D) {
                    this.minZ = ((ReferencedEnvelope3D)e).getMinZ();
                    this.maxZ = ((ReferencedEnvelope3D)e).getMaxZ();
                } else {
                    this.minZ = Double.NaN;
                    this.maxZ = Double.NaN;
                }
            } else {
                this.minZ = Double.NaN;
                this.maxZ = Double.NaN;
            }
        }
    }

    public EnvelopePanel setReadOnly(boolean readOnly) {
        this.visitChildren(TextField.class, (component, visit) -> component.setEnabled(!readOnly));
        this.crsPanel.setReadOnly(readOnly);
        return this;
    }

    public void convertInput() {
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).processInput());
        if (this.isCRSFieldVisible()) {
            this.crsPanel.processInput();
        }
        if (this.minX != null && this.maxX != null && this.minY != null && this.maxY != null) {
            if (this.crsRequired && this.crs == null) {
                this.setConvertedInput(null);
            } else if (this.is3D()) {
                double minZsafe = this.minZ == null ? Double.NaN : this.minZ;
                double maxZsafe = this.maxZ == null ? Double.NaN : this.maxZ;
                this.setConvertedInput(new ReferencedEnvelope3D(this.minX.doubleValue(), this.maxX.doubleValue(), this.minY.doubleValue(), this.maxY.doubleValue(), minZsafe, maxZsafe, this.crs));
            } else {
                this.setConvertedInput(new ReferencedEnvelope(this.minX.doubleValue(), this.maxX.doubleValue(), this.minY.doubleValue(), this.maxY.doubleValue(), this.crs));
            }
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).clearInput());
        this.crsPanel.modelChanged();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }
}

