/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.UnauthorizedPage;
import org.geoserver.web.data.resource.TitleAndAbstractPanel;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.services.AdminPagePanel;
import org.geoserver.web.services.AdminPagePanelInfo;
import org.geoserver.web.util.SerializableConsumer;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;

public abstract class BaseServiceAdminPage<T extends ServiceInfo>
extends GeoServerSecuredPage {
    public static final String WORKSPACE_ADMIN_SERVICE_ACCESS = "WORKSPACE_ADMIN_SERVICE_ACCESS";
    protected GeoServerDialog dialog;
    protected List<SerializableConsumer<Void>> onSubmitHooks = new ArrayList<SerializableConsumer<Void>>();

    public BaseServiceAdminPage() {
        this(new PageParameters());
    }

    public BaseServiceAdminPage(PageParameters pageParams) {
        String wsName = pageParams.get("workspace").toString();
        this.init((IModel<T>)new ServiceModel<T>(this, this.getServiceClass(), wsName));
    }

    public BaseServiceAdminPage(T service) {
        this.init((IModel<T>)new ServiceModel(this, service));
    }

    void init(final IModel<T> infoModel) {
        ServiceInfo service = (ServiceInfo)infoModel.getObject();
        this.dialog = new GeoServerDialog("dialog");
        this.add(new Component[]{this.dialog});
        Form form = new Form("form", (IModel)new CompoundPropertyModel(infoModel));
        this.add(new Component[]{form});
        boolean allowAccess = Boolean.parseBoolean(GeoServerExtensions.getProperty((String)WORKSPACE_ADMIN_SERVICE_ACCESS));
        if (service.getWorkspace() == null || !allowAccess) {
            if (!this.isAuthenticatedAsAdmin()) {
                throw new RestartResponseException(UnauthorizedPage.class);
            }
            form.add(new Component[]{new GlobalWorkspacePanel("workspace")});
        } else {
            form.add(new Component[]{new LocalWorkspacePanel(this, "workspace", service)});
        }
        form.add(new Component[]{new HelpLink("workspaceHelp").setDialog(this.dialog)});
        form.add(new Component[]{new Label("service.enabled", (IModel)new StringResourceModel("service.enabled", (Component)this).setParameters(new Object[]{this.getServiceName()}))});
        form.add(new Component[]{new TextField("maintainer")});
        TextField onlineResource = new TextField("onlineResource");
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        if (gsEnvironment == null || !GeoServerEnvironment.allowEnvParametrization()) {
            onlineResource.add((IValidator)new UrlValidator());
        }
        form.add(new Component[]{onlineResource});
        CheckBox enabled = new CheckBox("enabled");
        enabled.setOutputMarkupId(true);
        enabled.setMarkupId("enabled");
        form.add(new Component[]{enabled});
        CheckBox citeCompliant = new CheckBox("citeCompliant");
        citeCompliant.setOutputMarkupId(true);
        citeCompliant.setMarkupId("citeCompliant");
        form.add(new Component[]{citeCompliant});
        form.add(new Component[]{this.getInternationalContentFragment(infoModel, "serviceTitleAndAbstract")});
        form.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list(new PropertyModel(infoModel, "keywords")))});
        form.add(new Component[]{new TextField("fees")});
        form.add(new Component[]{new TextField("accessConstraints")});
        this.build(infoModel, form);
        ListView extensionPanels = this.createExtensionPanelList("extensions", infoModel);
        extensionPanels.setReuseItems(true);
        form.add(new Component[]{extensionPanels});
        SubmitLink submit = new SubmitLink("submit", (IModel)new StringResourceModel("save", null, null)){

            public void onSubmit() {
                try {
                    BaseServiceAdminPage.this.onSave(infoModel, true);
                }
                catch (IllegalArgumentException ex) {
                    this.error((Serializable)((Object)ex.getMessage()));
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        };
        form.add(new Component[]{submit});
        form.add(new Component[]{this.applyLink(infoModel, form)});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                BaseServiceAdminPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
        cancel.setDefaultFormProcessing(false);
    }

    protected void onSave(IModel<T> infoModel, boolean doReturn) {
        this.handleSubmit((ServiceInfo)infoModel.getObject());
        this.onSubmitHooks.forEach(x -> x.accept(null));
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(final IModel<T> infoModel, final Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{form});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    BaseServiceAdminPage.this.onSave(infoModel, false);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{this.getForm()});
                }
            }
        };
    }

    protected ListView createExtensionPanelList(String id, final IModel infoModel) {
        List<AdminPagePanelInfo> panels = this.getGeoServerApplication().getBeansOfType(AdminPagePanelInfo.class);
        Iterator<AdminPagePanelInfo> it = panels.iterator();
        while (it.hasNext()) {
            AdminPagePanelInfo panel = it.next();
            if (this.getServiceClass().equals(panel.getServiceClass())) continue;
            it.remove();
        }
        return new ListView<AdminPagePanelInfo>(id, panels){

            protected void populateItem(ListItem<AdminPagePanelInfo> item) {
                AdminPagePanelInfo info = (AdminPagePanelInfo)item.getModelObject();
                try {
                    AdminPagePanel panel = (AdminPagePanel)((Object)info.getComponentClass().getConstructor(String.class, IModel.class).newInstance("content", infoModel));
                    item.add(new Component[]{panel});
                    BaseServiceAdminPage.this.onSubmitHooks.add(x -> panel.onMainFormSubmit());
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to create admin extension panel of type " + info.getComponentClass().getSimpleName(), (Throwable)e);
                }
            }
        };
    }

    protected abstract Class<T> getServiceClass();

    protected abstract void build(IModel var1, Form var2);

    protected void handleSubmit(T info) {
        if (info.getId() != null) {
            this.getGeoServer().save(info);
        }
    }

    protected abstract String getServiceName();

    protected boolean supportInternationalContent() {
        return false;
    }

    private Fragment getInternationalContentFragment(IModel<T> infoModel, String id) {
        Fragment fragment;
        if (this.supportInternationalContent()) {
            fragment = new Fragment(id, "internationalStringFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new TitleAndAbstractPanel("titleAndAbstract", infoModel, "titleMsg", "abstract", (MarkupContainer)this)});
        } else {
            fragment = new Fragment(id, "stringFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new TextField("title")});
            fragment.add(new Component[]{new TextArea("abstract")});
        }
        return fragment;
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    static class LocalWorkspacePanel
    extends Panel {
        final /* synthetic */ BaseServiceAdminPage this$0;

        public LocalWorkspacePanel(String id, T service) {
            this.this$0 = this$0;
            super(id);
            this.add(new Component[]{new Label("workspace", (IModel)new PropertyModel(service, "workspace.name"))});
        }
    }

    class GlobalWorkspacePanel
    extends Panel {
        public GlobalWorkspacePanel(String id) {
            super(id);
            final DropDownChoice wsChoice = new DropDownChoice("workspace", (IModel)new ServiceFilteredWorkspacesModel(new WorkspacesModel()), (IChoiceRenderer)new WorkspaceChoiceRenderer());
            wsChoice.setNullValid(true);
            wsChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

                protected void onUpdate(AjaxRequestTarget target) {
                    WorkspaceInfo ws = (WorkspaceInfo)wsChoice.getModelObject();
                    PageParameters pp = new PageParameters();
                    if (ws != null) {
                        pp.add("workspace", (Object)ws.getName());
                    }
                    GlobalWorkspacePanel.this.setResponsePage(((Object)((Object)BaseServiceAdminPage.this)).getClass(), pp);
                }
            }});
            this.add(new Component[]{wsChoice});
        }
    }

    class ServiceFilteredWorkspacesModel
    extends LoadableDetachableModel<List<WorkspaceInfo>> {
        WorkspacesModel wsModel;

        ServiceFilteredWorkspacesModel(WorkspacesModel wsModel) {
            this.wsModel = wsModel;
        }

        protected List<WorkspaceInfo> load() {
            List workspaces = (List)this.wsModel.getObject();
            GeoServer gs = BaseServiceAdminPage.this.getGeoServer();
            Iterator it = workspaces.iterator();
            while (it.hasNext()) {
                if (gs.getService((WorkspaceInfo)it.next(), BaseServiceAdminPage.this.getServiceClass()) != null) continue;
                it.remove();
            }
            return workspaces;
        }
    }

    static class ServiceModel<T extends ServiceInfo>
    extends LoadableDetachableModel<T> {
        String id;
        Class<T> serviceClass;
        String workspaceName;
        T service;
        final /* synthetic */ BaseServiceAdminPage this$0;

        ServiceModel(T service) {
            this.this$0 = this$0;
            this.id = service.getId();
            if (this.id == null) {
                this.service = service;
            }
        }

        ServiceModel(BaseServiceAdminPage this$0, Class<T> serviceClass, String workspaceName) {
            this.this$0 = this$0;
            this.serviceClass = serviceClass;
            this.workspaceName = workspaceName;
        }

        protected T load() {
            if (this.id != null) {
                return (T)this.this$0.getGeoServer().getService(this.id, this.this$0.getServiceClass());
            }
            if (this.serviceClass != null) {
                if (this.workspaceName != null) {
                    WorkspaceInfo ws = this.this$0.getCatalog().getWorkspaceByName(this.workspaceName);
                    return (T)this.this$0.getGeoServer().getService(ws, this.this$0.getServiceClass());
                }
                return (T)this.this$0.getGeoServer().getService(this.this$0.getServiceClass());
            }
            return this.service;
        }

        public void detach() {
            this.service = this.id == null && this.serviceClass == null ? (ServiceInfo)this.getObject() : null;
        }
    }
}

