/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.StringValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ValidationResult;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.AccessDataRulePanel;
import org.geoserver.web.security.DataAccessRuleInfo;
import org.geoserver.web.wicket.URIValidator;
import org.geoserver.web.wicket.XMLNameValidator;

public class WorkspaceNewPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -4355978268880701910L;
    TextField<String> nsUriTextField;
    AccessDataRulePanel accessdataPanel;
    WsNewInfoPanel infoPanel;
    TabbedPanel<ITab> tabbedPanel;
    CompoundPropertyModel<WorkspaceInfo> model;

    public WorkspaceNewPage() {
        WorkspaceInfo ws = this.getCatalog().getFactory().createWorkspace();
        this.model = new CompoundPropertyModel((Object)ws);
        Form form = new Form("form");
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new Model((Serializable)((Object)"Basic Info"))){
            private static final long serialVersionUID = 1L;

            public WebMarkupContainer getPanel(String panelId) {
                try {
                    WorkspaceNewPage.this.infoPanel = new WsNewInfoPanel(panelId, (IModel<WorkspaceInfo>)WorkspaceNewPage.this.model);
                    return WorkspaceNewPage.this.infoPanel;
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        });
        if (AccessDataRuleInfoManager.canAccess()) {
            tabs.add(new AbstractTab((IModel)new Model((Serializable)((Object)"Security"))){
                private static final long serialVersionUID = 1L;

                public WebMarkupContainer getPanel(String panelId) {
                    try {
                        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
                        ListModel ownModel = new ListModel(manager.getDataAccessRuleInfo((CatalogInfo)WorkspaceNewPage.this.model.getObject()));
                        WorkspaceNewPage.this.accessdataPanel = new AccessDataRulePanel(panelId, (IModel<? extends CatalogInfo>)WorkspaceNewPage.this.model, (IModel<List<DataAccessRuleInfo>>)ownModel);
                        return WorkspaceNewPage.this.accessdataPanel;
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
            });
        }
        this.tabbedPanel = new TabbedPanel<ITab>("tabs", tabs){
            private static final long serialVersionUID = 1L;

            protected WebMarkupContainer newLink(String linkId, final int index) {
                return new SubmitLink(linkId){
                    private static final long serialVersionUID = 1L;

                    public void onSubmit() {
                        this.setSelectedTab(index);
                    }
                };
            }
        };
        form.add(new Component[]{this.tabbedPanel});
        form.add(new Component[]{this.submitLink()});
        form.add(new Component[]{this.cancelLink()});
        this.add(new Component[]{form});
    }

    private AjaxLink<Void> cancelLink() {
        return new AjaxLink<Void>("cancel"){
            private static final long serialVersionUID = -1731475076965108576L;

            public void onClick(AjaxRequestTarget target) {
                WorkspaceNewPage.this.doReturn(WorkspacePage.class);
            }
        };
    }

    private SubmitLink submitLink() {
        return new SubmitLink("submit"){
            private static final long serialVersionUID = -3462848930497720229L;

            public void onSubmit() {
                WorkspaceNewPage.this.handleOnSubmit();
            }
        };
    }

    private void handleOnSubmit() {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = (WorkspaceInfo)this.model.getObject();
        NamespaceInfo namespace = catalog.getFactory().createNamespace();
        namespace.setPrefix(workspace.getName());
        namespace.setURI(this.nsUriTextField.getDefaultModelObjectAsString());
        namespace.setIsolated(workspace.isIsolated());
        if (!this.validateAndReport(() -> catalog.validate(workspace, true)) || !this.validateAndReport(() -> catalog.validate(namespace, true))) {
            return;
        }
        try {
            catalog.add(workspace);
            catalog.add(namespace);
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, "Error storing workspace related objects.", exception);
            this.cleanAndReport(exception);
        }
        if (this.infoPanel.defaultWs) {
            catalog.setDefaultWorkspace(workspace);
        }
        try {
            if (this.accessdataPanel != null) {
                this.accessdataPanel.save();
            }
            this.doReturn(WorkspacePage.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Error saving access rules associated to workspace " + workspace.getName(), e);
            this.error((Serializable)((Object)(e.getMessage() == null ? e.toString() : e.getMessage())));
        }
    }

    private boolean validateAndReport(Supplier<ValidationResult> validation) {
        ValidationResult validationResult;
        try {
            validationResult = validation.get();
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, "Error validating workspace related objects.", exception);
            this.error((Serializable)((Object)exception.getMessage()));
            return false;
        }
        if (!validationResult.isValid()) {
            String message = validationResult.getErrosAsString(System.lineSeparator());
            LOGGER.log(Level.INFO, message);
            this.error((Serializable)((Object)message));
            return false;
        }
        return true;
    }

    private void cleanAndReport(Exception exception) {
        NamespaceInfo foundNamespace;
        WorkspaceInfo workspace;
        Catalog catalog = this.getCatalog();
        WorkspaceInfo foundWorkspace = catalog.getWorkspaceByName((workspace = (WorkspaceInfo)this.model.getObject()).getName());
        if (foundWorkspace != null && (foundNamespace = catalog.getNamespaceByPrefix(workspace.getName())) == null) {
            catalog.remove(foundWorkspace);
        }
        this.error((Serializable)((Object)exception.getMessage()));
    }

    class WsNewInfoPanel
    extends Panel {
        private static final long serialVersionUID = 4286364808180616865L;
        boolean defaultWs;

        public WsNewInfoPanel(String id, IModel<WorkspaceInfo> model) {
            super(id, model);
            TextField nameTextField = new TextField("name");
            nameTextField.setRequired(true);
            nameTextField.add((IValidator)new XMLNameValidator());
            nameTextField.add((IValidator)new StringValidator(){
                private static final long serialVersionUID = -5475431734680134780L;

                public void validate(IValidatable<String> validatable) {
                    if ("default".equals(validatable.getValue())) {
                        validatable.error((IValidationError)new ValidationError("defaultWsError").addKey("defaultWsError"));
                    }
                }
            });
            this.add(new Component[]{nameTextField.setRequired(true)});
            WorkspaceNewPage.this.nsUriTextField = new TextField("uri", (IModel)new Model());
            WorkspaceNewPage.this.nsUriTextField.setRequired(true);
            WorkspaceNewPage.this.nsUriTextField.add((IValidator)new URIValidator());
            this.add(new Component[]{WorkspaceNewPage.this.nsUriTextField});
            CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
            this.add(new Component[]{defaultChk});
            CheckBox isolatedChk = new CheckBox("isolated", (IModel)new PropertyModel(model.getObject(), "isolated"));
            if (!WorkspaceNewPage.this.getCatalog().getCatalogCapabilities().supportsIsolatedWorkspaces()) {
                isolatedChk.setEnabled(false);
            }
            this.add(new Component[]{isolatedChk});
        }
    }
}

