/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.ContactPanel;
import org.geoserver.web.admin.GlobalSettingsPage;
import org.geoserver.web.data.namespace.NamespaceDetachableModel;
import org.geoserver.web.data.settings.SettingsPluginPanelInfo;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.AccessDataRulePanel;
import org.geoserver.web.security.DataAccessRuleInfo;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.services.ServiceMenuPageInfo;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.URIValidator;
import org.geoserver.web.wicket.XMLNameValidator;
import org.geotools.util.logging.Logging;

public class WorkspaceEditPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 4341324830412716976L;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.workspace");
    IModel<WorkspaceInfo> wsModel;
    IModel<NamespaceInfo> nsModel;
    SettingsPanel settingsPanel;
    ServicesPanel servicesPanel;
    AccessDataRulePanel accessDataPanel;
    WsEditInfoPanel basicInfoPanel;
    GeoServerDialog dialog;
    TabbedPanel<ITab> tabbedPanel;

    public WorkspaceEditPage(PageParameters parameters) {
        String wsName = parameters.get("name").toString();
        WorkspaceInfo wsi = this.getCatalog().getWorkspaceByName(wsName);
        if (wsi == null) {
            this.getSession().error((Serializable)((Object)new ParamResourceModel("WorkspaceEditPage.notFound", (Component)this, wsName).getString()));
            this.doReturn(WorkspacePage.class);
            return;
        }
        this.init(wsi);
    }

    public WorkspaceEditPage(WorkspaceInfo ws) {
        this.init(ws);
    }

    private void init(WorkspaceInfo ws) {
        final boolean defaultWs = ws.getId().equals(this.getCatalog().getDefaultWorkspace().getId());
        this.wsModel = new WorkspaceDetachableModel(ws);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(ws.getName());
        if (ns == null) {
            throw new RuntimeException(String.format("Workspace '%s' associated namespace doesn't exists.", ws.getName()));
        }
        this.nsModel = new NamespaceDetachableModel(ns);
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.nsModel));
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new Model((Serializable)((Object)"Basic Info"))){
            private static final long serialVersionUID = 5216769765556937554L;

            public WebMarkupContainer getPanel(String panelId) {
                try {
                    WorkspaceEditPage.this.basicInfoPanel = new WsEditInfoPanel(panelId, WorkspaceEditPage.this.wsModel, WorkspaceEditPage.this.nsModel, defaultWs);
                    return WorkspaceEditPage.this.basicInfoPanel;
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
            }
        });
        if (AccessDataRuleInfoManager.canAccess()) {
            tabs.add(new AbstractTab((IModel)new Model((Serializable)((Object)"Security"))){
                private static final long serialVersionUID = 5216769765556937554L;

                public WebMarkupContainer getPanel(String panelId) {
                    try {
                        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
                        ListModel ownModel = new ListModel(manager.getDataAccessRuleInfo((CatalogInfo)WorkspaceEditPage.this.wsModel.getObject()));
                        WorkspaceEditPage.this.accessDataPanel = new AccessDataRulePanel(panelId, WorkspaceEditPage.this.wsModel, (IModel<List<DataAccessRuleInfo>>)ownModel);
                        return WorkspaceEditPage.this.accessDataPanel;
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
            });
        }
        this.tabbedPanel = new TabbedPanel<ITab>("tabs", tabs){
            private static final long serialVersionUID = 1L;

            protected WebMarkupContainer newLink(String linkId, final int index) {
                return new SubmitLink(linkId){
                    private static final long serialVersionUID = 1L;

                    public void onSubmit() {
                        this.setSelectedTab(index);
                    }
                };
            }
        };
        this.tabbedPanel.setOutputMarkupId(true);
        form.add(new Component[]{this.tabbedPanel});
        form.add(new Component[]{this.submitLink()});
        form.add(new Component[]{this.applyLink()});
        form.add(new Component[]{new BookmarkablePageLink("cancel", WorkspacePage.class)});
        this.add(new Component[]{form});
    }

    private SubmitLink submitLink() {
        return new SubmitLink("save"){
            private static final long serialVersionUID = -3462848930497720229L;

            public void onSubmit() {
                WorkspaceEditPage.this.saveWorkspace(true);
            }
        };
    }

    private AjaxSubmitLink applyLink() {
        return new GeoserverAjaxSubmitLink("apply", (GeoServerBasePage)this){

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                WorkspaceEditPage.this.saveWorkspace(false);
            }
        };
    }

    private void saveWorkspace(boolean doReturn) {
        try {
            Catalog catalog = this.getCatalog();
            NamespaceInfo namespaceInfo = (NamespaceInfo)this.nsModel.getObject();
            WorkspaceInfo workspaceInfo = (WorkspaceInfo)this.wsModel.getObject();
            namespaceInfo.setIsolated(workspaceInfo.isIsolated());
            namespaceInfo.setPrefix(workspaceInfo.getName());
            catalog.validate(workspaceInfo, false).throwIfInvalid();
            catalog.validate(namespaceInfo, false).throwIfInvalid();
            catalog.save(workspaceInfo);
            catalog.save(namespaceInfo);
            if (this.basicInfoPanel.defaultWs) {
                catalog.setDefaultWorkspace(workspaceInfo);
            }
            GeoServer geoServer = this.getGeoServer();
            Settings set = this.settingsPanel.set;
            if (set.enabled.booleanValue()) {
                if (set.model instanceof NewSettingsModel) {
                    geoServer.add((SettingsInfo)set.model.getObject());
                } else {
                    geoServer.save((SettingsInfo)set.model.getObject());
                }
            } else if (set.model instanceof ExistingSettingsModel) {
                geoServer.remove((SettingsInfo)set.model.getObject());
            }
            for (Service s : this.servicesPanel.services) {
                if (s.enabled.booleanValue()) {
                    if (s.model instanceof ExistingServiceModel) continue;
                    geoServer.add((ServiceInfo)s.model.getObject());
                    continue;
                }
                if (!(s.model instanceof ExistingServiceModel)) continue;
                geoServer.remove((ServiceInfo)s.model.getObject());
            }
            try {
                if (this.accessDataPanel != null) {
                    this.accessDataPanel.save();
                }
                if (doReturn) {
                    this.doReturn(WorkspacePage.class);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Error saving access rules associated to workspace " + workspaceInfo.getName(), e);
                this.error((Serializable)((Object)(e.getMessage() == null ? e.toString() : e.getMessage())));
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Failed to save workspace", e);
            this.error((Serializable)((Object)(e.getMessage() == null ? "Failed to save workspace, no error message available, see logs for details" : e.getMessage())));
        }
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    class ServicesPanel
    extends FormComponentPanel<Serializable> {
        private static final long serialVersionUID = 7375904545106343626L;
        List<Service> services;

        public ServicesPanel(String id, final IModel<WorkspaceInfo> wsModel) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new HelpLink("servicesHelp").setDialog(WorkspaceEditPage.this.dialog)});
            this.services = this.services(wsModel);
            ListView<Service> serviceList = new ListView<Service>("services", this.services){
                private static final long serialVersionUID = -4142739871430618450L;

                protected void populateItem(ListItem<Service> item) {
                    Service service = (Service)item.getModelObject();
                    boolean workspaceAdminOverride = Boolean.parseBoolean(GeoServerExtensions.getProperty((String)"WORKSPACE_ADMIN_SERVICE_ACCESS"));
                    boolean isEnabled = WorkspaceEditPage.this.isAuthenticatedAsAdmin() || workspaceAdminOverride;
                    final ServiceLink link = new ServiceLink(service, (IModel<WorkspaceInfo>)wsModel);
                    link.setOutputMarkupId(true);
                    link.setEnabled(isEnabled);
                    AjaxCheckBox enabled = new AjaxCheckBox("enabled", (IModel)new PropertyModel((Object)service, "enabled")){
                        private static final long serialVersionUID = 6369730006169869310L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            link.setEnabled(((Boolean)this.getModelObject()).booleanValue());
                            target.add(new Component[]{link});
                        }
                    };
                    item.add(new Component[]{enabled});
                    ServiceMenuPageInfo<?> info = service.adminPage;
                    link.add(new Behavior[]{new AttributeModifier("title", (IModel)new StringResourceModel(info.getDescriptionKey(), null, null))});
                    link.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), null, null))});
                    Image image = info.getIcon() != null ? new Image("link.icon", (ResourceReference)new PackageResourceReference(info.getComponentClass(), info.getIcon()), new ResourceReference[0]) : new Image("link.icon", (ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/wrench.png"), new ResourceReference[0]);
                    image.add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel(info.getTitleKey(), null, new Object[0]))});
                    link.add(new Component[]{image});
                    item.add(new Component[]{link});
                    item.setEnabled(isEnabled);
                }
            };
            this.add(new Component[]{serviceList});
        }

        List<Service> services(IModel<WorkspaceInfo> wsModel) {
            ArrayList<Service> services = new ArrayList<Service>();
            for (ServiceMenuPageInfo page : WorkspaceEditPage.this.getGeoServerApplication().getBeansOfType(ServiceMenuPageInfo.class)) {
                Service service = new Service();
                service.adminPage = page;
                service.enabled = this.isEnabled(wsModel, page);
                Class<ServiceInfo> serviceClass = page.getServiceClass();
                service.model = service.enabled == false ? new NewServiceModel(wsModel, serviceClass) : new ExistingServiceModel(wsModel, serviceClass);
                services.add(service);
            }
            return services;
        }

        private boolean isEnabled(IModel<WorkspaceInfo> wsModel, ServiceMenuPageInfo page) {
            return WorkspaceEditPage.this.getGeoServer().getService((WorkspaceInfo)wsModel.getObject(), page.getServiceClass()) != null;
        }

        private class ServiceLink
        extends Link<Service> {
            private static final long serialVersionUID = 1111536301891090436L;
            private final IModel<WorkspaceInfo> wsModel;

            public ServiceLink(Service service, IModel<WorkspaceInfo> wsModel) {
                super("link", (IModel)new Model((Serializable)service));
                this.wsModel = wsModel;
            }

            public void onClick() {
                Service s = (Service)this.getModelObject();
                Page page = null;
                if (s.model instanceof ExistingServiceModel) {
                    PageParameters pp = new PageParameters().add("workspace", (Object)((WorkspaceInfo)this.wsModel.getObject()).getName());
                    try {
                        page = (Page)s.adminPage.getComponentClass().getConstructor(PageParameters.class).newInstance(pp);
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
                try {
                    page = (Page)s.adminPage.getComponentClass().getConstructor(s.adminPage.getServiceClass()).newInstance(s.model.getObject());
                }
                catch (Exception e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                ((BaseServiceAdminPage)page).setReturnPage((Page)WorkspaceEditPage.this);
                this.setResponsePage((IRequestablePage)page);
            }
        }
    }

    static class ExistingServiceModel
    extends LoadableDetachableModel<ServiceInfo> {
        private static final long serialVersionUID = -2170117760214309321L;
        IModel<WorkspaceInfo> wsModel;
        Class<ServiceInfo> serviceClass;

        ExistingServiceModel(IModel<WorkspaceInfo> wsModel, Class<ServiceInfo> serviceClass) {
            this.wsModel = wsModel;
            this.serviceClass = serviceClass;
        }

        protected ServiceInfo load() {
            return GeoServerApplication.get().getGeoServer().getService((WorkspaceInfo)this.wsModel.getObject(), this.serviceClass);
        }
    }

    static class NewServiceModel
    extends Model<ServiceInfo> {
        private static final long serialVersionUID = -3467556623909292282L;
        IModel<WorkspaceInfo> wsModel;
        Class<ServiceInfo> serviceClass;
        ServiceInfo service;

        NewServiceModel(IModel<WorkspaceInfo> wsModel, Class<ServiceInfo> serviceClass) {
            this.wsModel = wsModel;
            this.serviceClass = serviceClass;
        }

        public ServiceInfo getObject() {
            if (this.service == null) {
                this.service = this.create();
            }
            return this.service;
        }

        ServiceInfo create() {
            GeoServer gs = GeoServerApplication.get().getGeoServer();
            ServiceInfo newService = (ServiceInfo)gs.getFactory().create(this.serviceClass);
            ServiceInfo global = gs.getService(this.serviceClass);
            OwsUtils.copy((Object)global, (Object)newService, this.serviceClass);
            newService.setWorkspace((WorkspaceInfo)this.wsModel.getObject());
            ((ServiceInfoImpl)newService).setId(null);
            return newService;
        }
    }

    static class Service
    implements Serializable {
        private static final long serialVersionUID = 3283857206025172687L;
        Boolean enabled;
        ServiceMenuPageInfo<?> adminPage;
        IModel<ServiceInfo> model;

        Service() {
        }
    }

    class SettingsPanel
    extends FormComponentPanel<Serializable> {
        private static final long serialVersionUID = -1580928887379954134L;
        WebMarkupContainer settingsContainer;
        Label contactHeading;
        ContactPanel contactPanel;
        Label otherHeading;
        WebMarkupContainer otherSettingsPanel;
        Settings set;

        public SettingsPanel(String id, IModel<WorkspaceInfo> model) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new HelpLink("settingsHelp").setDialog(WorkspaceEditPage.this.dialog)});
            SettingsInfo settings = WorkspaceEditPage.this.getGeoServer().getSettings((WorkspaceInfo)model.getObject());
            this.set = new Settings();
            this.set.enabled = settings != null;
            this.set.model = settings != null ? new ExistingSettingsModel(WorkspaceEditPage.this.wsModel) : new NewSettingsModel(WorkspaceEditPage.this.wsModel);
            this.add(new Component[]{new CheckBox("enabled", (IModel)new PropertyModel((Object)this.set, "enabled")).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){
                private static final long serialVersionUID = -7851699665702753119L;

                protected void onUpdate(AjaxRequestTarget target) {
                    SettingsPanel.this.contactHeading.setVisible(SettingsPanel.this.set.enabled.booleanValue());
                    SettingsPanel.this.contactPanel.setVisible(SettingsPanel.this.set.enabled);
                    SettingsPanel.this.otherHeading.setVisible(SettingsPanel.this.set.enabled.booleanValue());
                    SettingsPanel.this.otherSettingsPanel.setVisible(SettingsPanel.this.set.enabled.booleanValue());
                    target.add(new Component[]{SettingsPanel.this.settingsContainer});
                }
            }})});
            this.settingsContainer = new WebMarkupContainer("settingsContainer");
            this.settingsContainer.setOutputMarkupId(true);
            this.add(new Component[]{this.settingsContainer});
            this.contactHeading = new Label("contactHeading", (IModel)new StringResourceModel("ContactPage.title", null, null));
            this.contactHeading.setVisible(this.set.enabled.booleanValue());
            this.settingsContainer.add(new Component[]{this.contactHeading});
            this.contactPanel = new ContactPanel("contact", (IModel<ContactInfo>)new CompoundPropertyModel((IModel)new PropertyModel(this.set.model, "contact")));
            this.contactPanel.setOutputMarkupId(true);
            this.contactPanel.setVisible(this.set.enabled);
            this.settingsContainer.add(new Component[]{this.contactPanel});
            this.otherHeading = new Label("otherHeading", (IModel)new StringResourceModel("GlobalSettingsPage.serviceSettings", null, null));
            this.otherHeading.setVisible(this.set.enabled.booleanValue());
            this.settingsContainer.add(new Component[]{this.otherHeading});
            this.otherSettingsPanel = new WebMarkupContainer("otherSettings", (IModel)new CompoundPropertyModel(this.set.model));
            this.otherSettingsPanel.setOutputMarkupId(true);
            this.otherSettingsPanel.setVisible(this.set.enabled.booleanValue());
            this.otherSettingsPanel.add(new Component[]{new CheckBox("verbose")});
            this.otherSettingsPanel.add(new Component[]{new CheckBox("verboseExceptions")});
            this.otherSettingsPanel.add(new Component[]{new CheckBox("localWorkspaceIncludesPrefix")});
            this.otherSettingsPanel.add(new Component[]{new TextField("numDecimals").add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)))});
            this.otherSettingsPanel.add(new Component[]{new DropDownChoice("charset", GlobalSettingsPage.AVAILABLE_CHARSETS)});
            this.otherSettingsPanel.add(new Component[]{new TextField("proxyBaseUrl")});
            this.otherSettingsPanel.add(new Component[]{new CheckBox("useHeadersProxyURL")});
            ListView<SettingsPluginPanelInfo> extensions = SettingsPluginPanelInfo.createExtensions("extensions", this.set.model, WorkspaceEditPage.this.getGeoServerApplication());
            this.otherSettingsPanel.add(new Component[]{extensions});
            this.settingsContainer.add(new Component[]{this.otherSettingsPanel});
        }
    }

    class WsEditInfoPanel
    extends Panel {
        private static final long serialVersionUID = -8487041433764733692L;
        boolean defaultWs;

        public WsEditInfoPanel(String id, IModel<WorkspaceInfo> wsModel, IModel<NamespaceInfo> nsModel, boolean defaultWs) {
            super(id, wsModel);
            this.defaultWs = defaultWs;
            boolean isFullAdmin = WorkspaceEditPage.this.isAuthenticatedAsAdmin();
            TextField name = new TextField("name", (IModel)new PropertyModel(wsModel, "name"));
            name.setRequired(true);
            name.setEnabled(isFullAdmin);
            name.add((IValidator)new XMLNameValidator());
            this.add(new Component[]{name});
            TextField uri = new TextField("uri", (IModel)new PropertyModel(nsModel, "uRI"), String.class);
            uri.setRequired(true);
            uri.add((IValidator)new URIValidator());
            this.add(new Component[]{uri});
            CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
            this.add(new Component[]{defaultChk});
            defaultChk.setEnabled(isFullAdmin);
            CheckBox isolatedChk = new CheckBox("isolated", (IModel)new PropertyModel(wsModel, "isolated"));
            this.add(new Component[]{isolatedChk});
            defaultChk.setEnabled(isFullAdmin);
            Component[] componentArray = new Component[1];
            WorkspaceEditPage.this.dialog = new GeoServerDialog("dialog");
            componentArray[0] = WorkspaceEditPage.this.dialog;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            WorkspaceEditPage.this.servicesPanel = new ServicesPanel("services", wsModel);
            componentArray2[0] = WorkspaceEditPage.this.servicesPanel;
            this.add(componentArray2);
            Component[] componentArray3 = new Component[1];
            WorkspaceEditPage.this.settingsPanel = new SettingsPanel("settings", wsModel);
            componentArray3[0] = WorkspaceEditPage.this.settingsPanel;
            this.add(componentArray3);
        }
    }

    static class NewSettingsModel
    extends Model<SettingsInfo> {
        private static final long serialVersionUID = -4365626821652771933L;
        IModel<WorkspaceInfo> wsModel;
        SettingsInfo info;

        NewSettingsModel(IModel<WorkspaceInfo> wsModel) {
            this.wsModel = wsModel;
        }

        public SettingsInfo getObject() {
            if (this.info == null) {
                GeoServer gs = GeoServerApplication.get().getGeoServer();
                this.info = gs.getFactory().createSettings();
                SettingsInfo global = gs.getGlobal().getSettings();
                ContactInfo contact = gs.getFactory().createContact();
                OwsUtils.copy((Object)global.getContact(), (Object)contact, ContactInfo.class);
                OwsUtils.copy((Object)global, (Object)this.info, SettingsInfo.class);
                this.info.setContact(contact);
                this.info.setWorkspace((WorkspaceInfo)this.wsModel.getObject());
            }
            return this.info;
        }
    }

    static class ExistingSettingsModel
    extends LoadableDetachableModel<SettingsInfo> {
        private static final long serialVersionUID = -8203239697623788188L;
        IModel<WorkspaceInfo> wsModel;

        ExistingSettingsModel(IModel<WorkspaceInfo> wsModel) {
            this.wsModel = wsModel;
        }

        protected SettingsInfo load() {
            GeoServer gs = GeoServerApplication.get().getGeoServer();
            return gs.getSettings((WorkspaceInfo)this.wsModel.getObject());
        }
    }

    static class Settings
    implements Serializable {
        private static final long serialVersionUID = -5855608735160516252L;
        Boolean enabled;
        IModel<SettingsInfo> model;

        Settings() {
        }
    }
}

