/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.component.IRequestablePage;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.data.DataAccess;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;

public class DataAccessNewPage
extends AbstractDataAccessPage {
    private static final long serialVersionUID = 1L;

    public DataAccessNewPage(String dataStoreFactDisplayName) {
        WorkspaceInfo defaultWs = this.getCatalog().getDefaultWorkspace();
        if (defaultWs == null) {
            throw new IllegalStateException("No default Workspace configured");
        }
        NamespaceInfo defaultNs = this.getCatalog().getDefaultNamespace();
        if (defaultNs == null) {
            throw new IllegalStateException("No default Namespace configured");
        }
        DataStoreInfo info = this.getCatalog().getFactory().createDataStore();
        info.setWorkspace(defaultWs);
        info.setEnabled(true);
        info.setType(dataStoreFactDisplayName);
        this.initUI(info);
    }

    @Override
    protected final void onSaveDataStore(DataStoreInfo info, AjaxRequestTarget target, boolean doReturn) throws IllegalArgumentException {
        NewLayerPage newLayerPage;
        if (!this.storeEditPanel.onSave()) {
            return;
        }
        Catalog catalog = this.getCatalog();
        DataStoreInfo expandedStore = catalog.getResourcePool().clone(info, true);
        try {
            DataAccess dataStore = expandedStore.getDataStore((ProgressListener)new NullProgressListener());
            dataStore.dispose();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error obtaining new data store", e);
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            throw new IllegalArgumentException("Error creating data store, check the parameters. Error message: " + message);
        }
        DataStoreInfo savedStore = catalog.getResourcePool().clone(info, true);
        try {
            catalog.validate((StoreInfo)savedStore, true).throwIfInvalid();
            savedStore = catalog.getResourcePool().clone(info, false);
            catalog.add((StoreInfo)savedStore);
        }
        catch (FileSandboxEnforcer.SandboxException e) {
            this.error((Serializable)((Object)new ParamResourceModel("sandboxError", (Component)this, e.getFile().getAbsolutePath()).getString()));
            return;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error adding data store to catalog", e);
            String message = e.getMessage();
            if (message == null && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            throw new IllegalArgumentException("Error creating data store with the provided parameters: " + message);
        }
        try {
            newLayerPage = new NewLayerPage(savedStore.getId());
        }
        catch (RuntimeException e) {
            try {
                catalog.remove((StoreInfo)expandedStore);
                catalog.remove((StoreInfo)savedStore);
            }
            catch (Exception removeEx) {
                LOGGER.log(Level.WARNING, "Error removing just added datastore!", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (doReturn) {
            this.setResponsePage((IRequestablePage)newLayerPage);
        } else {
            this.setResponsePage((IRequestablePage)new DataAccessEditPage(savedStore.getId()));
        }
    }
}

