/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.web.GeoServerApplication;

public class MetadataLinkEditor
extends Panel {
    private static final long serialVersionUID = -5721941745847988670L;
    private static final List<String> LINK_TYPES = Arrays.asList("ISO19115:2003", "FGDC", "TC211", "19139", "other");
    private final ListView<MetadataLinkInfo> links;
    private final Label noMetadata;
    private final WebMarkupContainer table;
    private PropertyModel<List<MetadataLinkInfo>> metadataLinksModel;

    protected Catalog getCatalog() {
        return ((GeoServerApplication)this.getApplication()).getCatalog();
    }

    public MetadataLinkEditor(String id, IModel<?> resourceModel) {
        super(id, resourceModel);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.metadataLinksModel = new PropertyModel(resourceModel, "metadataLinks");
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.links = new ListView<MetadataLinkInfo>("links", this.metadataLinksModel){
            private static final long serialVersionUID = -3241009112151911288L;

            protected void populateItem(ListItem<MetadataLinkInfo> item) {
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(item.getIndex() % 2 == 0 ? "even" : "odd")))});
                TextField metadataType = new TextField("type", (IModel)new PropertyModel((Object)item.getModel(), "metadataType"));
                RepeatingView commonKeys = new RepeatingView("commonTypes");
                item.add(new Component[]{commonKeys});
                for (String key : LINK_TYPES) {
                    commonKeys.add(new Component[]{new Label(commonKeys.newChildId(), (Serializable)((Object)key))});
                }
                metadataType.setRequired(true);
                item.add(new Component[]{metadataType});
                TextField about = new TextField("about", (IModel)new PropertyModel((Object)item.getModel(), "about"));
                item.add(new Component[]{about});
                FormComponentFeedbackBorder urlBorder = new FormComponentFeedbackBorder("urlBorder");
                item.add(new Component[]{urlBorder});
                TextField format = new TextField("format", (IModel)new PropertyModel((Object)item.getModel(), "type"));
                format.setRequired(true);
                item.add(new Component[]{format});
                TextField url = new TextField("metadataLinkURL", (IModel)new PropertyModel((Object)item.getModel(), "content"));
                url.add((IValidator)new UrlValidator());
                url.setRequired(true);
                urlBorder.add(new Component[]{url});
                AjaxLink<MetadataLinkInfo> link = new AjaxLink<MetadataLinkInfo>("removeLink", item.getModel()){
                    private static final long serialVersionUID = -6204300287066695521L;

                    public void onClick(AjaxRequestTarget target) {
                        ((List)MetadataLinkEditor.this.metadataLinksModel.getObject()).remove(this.getModelObject());
                        MetadataLinkEditor.this.updateLinksVisibility();
                        target.add(new Component[]{container});
                    }
                };
                item.add(new Component[]{link});
            }
        };
        this.links.setReuseItems(true);
        this.table.add(new Component[]{this.links});
        this.noMetadata = new Label("noLinks", (IModel)new ResourceModel("noMetadataLinksSoFar"));
        container.add(new Component[]{this.noMetadata});
        this.updateLinksVisibility();
        AjaxButton button = new AjaxButton("addlink"){
            private static final long serialVersionUID = -695617463194724617L;

            protected void onSubmit(AjaxRequestTarget target) {
                MetadataLinkInfo link = MetadataLinkEditor.this.getCatalog().getFactory().createMetadataLink();
                link.setMetadataType(LINK_TYPES.get(0));
                link.setType("text/plain");
                ((List)MetadataLinkEditor.this.metadataLinksModel.getObject()).add(link);
                MetadataLinkEditor.this.updateLinksVisibility();
                target.add(new Component[]{container});
            }
        };
        this.add(new Component[]{button});
    }

    private void updateLinksVisibility() {
        boolean anyLink = !((List)this.metadataLinksModel.getObject()).isEmpty();
        this.table.setVisible(anyLink);
        this.noMetadata.setVisible(!anyLink);
    }

    public class UrlValidator
    implements IValidator<String> {
        private static final long serialVersionUID = 8435726308689930141L;

        public void validate(IValidatable validatable) {
            String url = (String)validatable.getValue();
            if (url != null) {
                try {
                    MetadataLinkInfoImpl.validate((String)url);
                }
                catch (IllegalArgumentException ex) {
                    ValidationError err = new ValidationError("invalidURL").addKey("invalidURL").setVariable("url", (Object)url);
                    validatable.error((IValidationError)err);
                }
            }
        }
    }
}

