/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.jai.util.CacheDiagnostics;
import java.awt.GraphicsEnvironment;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.web.admin.AbstractStatusPage;
import org.geoserver.web.admin.JVMFontsPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.LockingManager;
import org.geotools.api.filter.Filter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.util.logging.Logging;

public class StatusPanel
extends Panel {
    private static final long serialVersionUID = 7732030199323990637L;
    private Map<String, Object> values;
    private static final String KEY_DATA_DIR = "dataDir";
    private static final String KEY_LOCKS = "locks";
    private static final String KEY_CONNECTIONS = "connections";
    private static final String KEY_MEMORY = "memory";
    private static final String KEY_JVM_VERSION = "jvm_version";
    private static final String KEY_JAI_AVAILABLE = "jai_available";
    private static final String KEY_JAI_IMAGEIO_AVAILABLE = "jai_imageio_available";
    private static final String KEY_JAI_MAX_MEM = "jai_max_mem";
    private static final String KEY_JAI_MEM_USAGE = "jai_mem_usage";
    private static final String KEY_JAI_MEM_THRESHOLD = "jai_mem_threshold";
    private static final String KEY_JAI_TILE_THREADS = "jai_tile_threads";
    private static final String KEY_JAI_TILE_THREAD_PRIORITY = "jai_tile_thread_priority";
    private static final String KEY_COVERAGEACCESS_CORE_POOL_SIZE = "coverage_thread_corepoolsize";
    private static final String KEY_COVERAGEACCESS_MAX_POOL_SIZE = "coverage_thread_maxpoolsize";
    private static final String KEY_COVERAGEACCESS_KEEP_ALIVE_TIME = "coverage_thread_keepalivetime";
    private static final String KEY_UPDATE_SEQUENCE = "update_sequence";
    private static final String RESOURCE_CACHE = "resource_cache";
    private static final String KEY_JAVA_RENDERER = "renderer";
    private static final Logger LOGGER = Logging.getLogger(StatusPanel.class);
    private AbstractStatusPage parent;

    public StatusPanel(String id, AbstractStatusPage parent) {
        super(id);
        this.parent = parent;
        this.initUI();
    }

    public void initUI() {
        this.values = new HashMap<String, Object>();
        this.updateModel();
        this.add(new Component[]{new Label(KEY_DATA_DIR, new MapModel(this.values, KEY_DATA_DIR))});
        this.add(new Component[]{new Label(KEY_LOCKS, new MapModel(this.values, KEY_LOCKS))});
        this.add(new Component[]{new Label(KEY_CONNECTIONS, new MapModel(this.values, KEY_CONNECTIONS))});
        this.add(new Component[]{new Label(KEY_MEMORY, new MapModel(this.values, KEY_MEMORY))});
        this.add(new Component[]{new Label("jvm.version", new MapModel(this.values, KEY_JVM_VERSION))});
        this.add(new Component[]{new Label("jai.available", new MapModel(this.values, KEY_JAI_AVAILABLE))});
        this.add(new Component[]{new Label("jai.imageio.available", new MapModel(this.values, KEY_JAI_IMAGEIO_AVAILABLE))});
        this.add(new Component[]{new Label("jai.memory.available", new MapModel(this.values, KEY_JAI_MAX_MEM))});
        this.add(new Component[]{new Label("jai.memory.used", new MapModel(this.values, KEY_JAI_MEM_USAGE))});
        this.add(new Component[]{new Label("jai.memory.threshold", new MapModel(this.values, KEY_JAI_MEM_THRESHOLD))});
        this.add(new Component[]{new Label("jai.tile.threads", (IModel)new StringResourceModel("values.threads", (Component)this).setParameters(new Object[]{new MapModel(this.values, KEY_JAI_TILE_THREADS)}))});
        this.add(new Component[]{new Label("jai.tile.priority", new MapModel(this.values, KEY_JAI_TILE_THREAD_PRIORITY))});
        this.add(new Component[]{new Label("coverage.corepoolsize", (IModel)new StringResourceModel("values.threads", (Component)this).setParameters(new Object[]{new MapModel(this.values, KEY_COVERAGEACCESS_CORE_POOL_SIZE)}))});
        this.add(new Component[]{new Label("coverage.maxpoolsize", (IModel)new StringResourceModel("values.threads", (Component)this).setParameters(new Object[]{new MapModel(this.values, KEY_COVERAGEACCESS_MAX_POOL_SIZE)}))});
        this.add(new Component[]{new Label("coverage.keepalivetime", (IModel)new StringResourceModel("values.milliseconds", (Component)this).setParameters(new Object[]{new MapModel(this.values, KEY_COVERAGEACCESS_KEEP_ALIVE_TIME)}))});
        this.add(new Component[]{new Label("updateSequence", new MapModel(this.values, KEY_UPDATE_SEQUENCE))});
        this.add(new Component[]{new Label("resourceCache", new MapModel(this.values, RESOURCE_CACHE))});
        this.add(new Component[]{new Label(KEY_JAVA_RENDERER, new MapModel(this.values, KEY_JAVA_RENDERER))});
        this.add(new Component[]{new Link<Object>("free.locks"){
            private static final long serialVersionUID = -2889353495319211391L;

            public void onClick() {
                StatusPanel.this.updateModel();
            }
        }});
        this.add(new Component[]{new Link<Object>("free.memory"){
            private static final long serialVersionUID = 3695369177295089346L;

            public void onClick() {
                System.gc();
                System.runFinalization();
                StatusPanel.this.updateModel();
            }
        }});
        this.add(new Component[]{new Link<Object>("free.memory.jai"){
            private static final long serialVersionUID = -3556725607958589003L;

            public void onClick() {
                TileCache jaiCache = StatusPanel.this.parent.getGeoServer().getGlobal().getJAI().getTileCache();
                long capacityBefore = jaiCache.getMemoryCapacity();
                jaiCache.flush();
                jaiCache.setMemoryCapacity(0L);
                System.gc();
                System.runFinalization();
                jaiCache.setMemoryCapacity(capacityBefore);
                StatusPanel.this.updateModel();
            }
        }});
        int fontCount = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts().length;
        this.add(new Component[]{new Label("fontCount", (IModel)new ParamResourceModel("StatusPage.fontCount", (Component)this, fontCount))});
        this.add(new Component[]{new BookmarkablePageLink("show.fonts", JVMFontsPage.class)});
        this.add(new Component[]{new AjaxLink<Object>("clear.resourceCache"){
            private static final long serialVersionUID = 2663650174059497376L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    StatusPanel.this.parent.getGeoServer().reset();
                    this.info((Serializable)((Object)this.getLocalizer().getString("resourceCacheClearedSuccessfully", (Component)this)));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Error resetting resource caches", t);
                    this.error(t);
                }
                StatusPanel.this.parent.addFeedbackPanels(target);
                StatusPanel.this.updateModel();
            }
        }});
        this.add(new Component[]{new AjaxLink<Object>("reload.catalogConfig"){
            private static final long serialVersionUID = -7476556423889306321L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    StatusPanel.this.parent.getGeoServer().reload();
                    this.info((Serializable)((Object)this.getLocalizer().getString("catalogConfigReloadedSuccessfully", (Component)StatusPanel.this)));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "An error occurred while reloading the catalog", t);
                    this.error(t);
                }
                StatusPanel.this.parent.addFeedbackPanels(target);
                StatusPanel.this.updateModel();
            }
        }});
    }

    private void updateModel() {
        this.values.put(KEY_DATA_DIR, this.getDataDirectory());
        this.values.put(KEY_LOCKS, this.getLockCount());
        this.values.put(KEY_CONNECTIONS, this.getConnectionCount());
        this.values.put(KEY_MEMORY, this.formatUsedMemory());
        this.values.put(KEY_JVM_VERSION, System.getProperty("java.vendor") + ": " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + ")");
        this.values.put(KEY_JAI_AVAILABLE, Boolean.toString(this.isNativeJAIAvailable()));
        this.values.put(KEY_JAI_IMAGEIO_AVAILABLE, Boolean.toString(PackageUtil.isCodecLibAvailable()));
        GeoServerInfo geoServerInfo = this.parent.getGeoServer().getGlobal();
        JAIInfo jaiInfo = geoServerInfo.getJAI();
        JAI jai = jaiInfo.getJAI();
        CoverageAccessInfo coverageAccess = geoServerInfo.getCoverageAccess();
        TileCache jaiCache = jaiInfo.getTileCache();
        this.values.put(KEY_JAI_MAX_MEM, this.formatMemory(jaiCache.getMemoryCapacity()));
        if (jaiCache instanceof CacheDiagnostics) {
            this.values.put(KEY_JAI_MEM_USAGE, this.formatMemory(((CacheDiagnostics)jaiCache).getCacheMemoryUsed()));
        } else {
            this.values.put(KEY_JAI_MEM_USAGE, "-");
        }
        this.values.put(KEY_JAI_MEM_THRESHOLD, Integer.toString((int)(100.0f * jaiCache.getMemoryThreshold())) + "%");
        this.values.put(KEY_JAI_TILE_THREADS, jai.getTileScheduler().getParallelism());
        this.values.put(KEY_JAI_TILE_THREAD_PRIORITY, Integer.toString(jai.getTileScheduler().getPriority()));
        this.values.put(KEY_COVERAGEACCESS_CORE_POOL_SIZE, coverageAccess.getCorePoolSize());
        this.values.put(KEY_COVERAGEACCESS_MAX_POOL_SIZE, coverageAccess.getMaxPoolSize());
        this.values.put(KEY_COVERAGEACCESS_KEEP_ALIVE_TIME, coverageAccess.getKeepAliveTime());
        this.values.put(KEY_UPDATE_SEQUENCE, geoServerInfo.getUpdateSequence());
        this.values.put(RESOURCE_CACHE, this.getResourceCache());
        this.values.put(KEY_JAVA_RENDERER, this.checkRenderer());
    }

    private String getDataDirectory() {
        GeoServerDataDirectory dd = this.parent.getGeoServerApplication().getBeanOfType(GeoServerDataDirectory.class);
        return dd.root().getAbsolutePath();
    }

    private String checkRenderer() {
        try {
            String renderer = Class.forName("sun.java2d.pipe.RenderingEngine").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]).getClass().getName();
            return renderer;
        }
        catch (Throwable e) {
            return "Unknown";
        }
    }

    boolean isNativeJAIAvailable() {
        try {
            Class<?> image = Class.forName("com.sun.medialib.mlib.Image");
            return (Boolean)image.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private String formatUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedBytes = runtime.totalMemory() - runtime.freeMemory();
        String formattedUsedMemory = this.formatMemory(usedBytes);
        String formattedMaxMemory = this.formatMemory(runtime.maxMemory());
        return formattedUsedMemory + " / " + formattedMaxMemory;
    }

    private String formatMemory(long bytes) {
        long KB = 1024L;
        long MB = 0x100000L;
        long GB = 0x40000000L;
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(2);
        String formattedUsedMemory = bytes > 0x40000000L ? formatter.format((float)bytes / 1.0737418E9f) + " GB" : (bytes > 0x100000L ? formatter.format(bytes / 0x100000L) + " MB" : formatter.format(bytes / 1024L) + " KB");
        return formattedUsedMemory;
    }

    private synchronized int getLockCount() {
        int count;
        block10: {
            count = 0;
            CloseableIterator<StoreInfo> i = this.getStores();
            block7: while (true) {
                while (i.hasNext()) {
                    StoreInfo meta = (StoreInfo)i.next();
                    if (!meta.isEnabled() || !(meta instanceof DataStoreInfo)) continue;
                    DataStoreInfo dataStoreInfo = (DataStoreInfo)meta;
                    try {
                        LockingManager lockingManager;
                        DataAccess store = dataStoreInfo.getDataStore(null);
                        if (!(store instanceof DataStore) || !((lockingManager = ((DataStore)store).getLockingManager()) instanceof InProcessLockingManager)) continue block7;
                        InProcessLockingManager inprocess = (InProcessLockingManager)lockingManager;
                        count += inprocess.allLocks().size();
                        continue block7;
                    }
                    catch (Throwable notAvailable) {
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (i != null) {
                    i.close();
                }
            }
        }
        return count;
    }

    private int getResourceCache() {
        ResourcePool pool = this.parent.getGeoServer().getCatalog().getResourcePool();
        int count = 0;
        count += pool.getCrsCache().size();
        count += pool.getDataStoreCache().size();
        count += pool.getFeatureTypeCache().size();
        count += pool.getFeatureTypeAttributeCache().size();
        count += pool.getHintCoverageReaderCache().size();
        count += pool.getWmsCache().size();
        count += pool.getWmtsCache().size();
        count += pool.getStyleCache().size();
        return count += pool.getSldCache().size();
    }

    private synchronized int getConnectionCount() {
        int count = 0;
        try (CloseableIterator<StoreInfo> i = this.getStores();){
            while (i.hasNext()) {
                block11: {
                    StoreInfo meta = (StoreInfo)i.next();
                    if (!meta.isEnabled()) continue;
                    if (meta instanceof DataStoreInfo) {
                        DataStoreInfo dataMeta = (DataStoreInfo)meta;
                        try {
                            DataAccess store = dataMeta.getDataStore(null);
                            if (store == null) {
                            }
                            break block11;
                        }
                        catch (Throwable notAvailable) {
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, "Store '" + meta.getName() + "' unavailable: " + notAvailable, notAvailable);
                        }
                        continue;
                    }
                }
                ++count;
            }
        }
        return count;
    }

    private CloseableIterator<StoreInfo> getStores() {
        Catalog catalog = this.parent.getGeoServer().getCatalog();
        Filter filter = Predicates.acceptAll();
        CloseableIterator stores = catalog.list(StoreInfo.class, filter);
        return stores;
    }
}

