/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.apache.wicket.markup.html.image.resource.BufferedDynamicImageResource;

public class PreviewFont
implements Serializable {
    public static final int PREVIEW_IMAGE_WIDTH = 450;
    public static final int PREVIEW_IMAGE_HEIGHT = 16;
    private transient BufferedDynamicImageResource previewImage;
    private final String PREVIEW_TEXT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    Font font;

    protected PreviewFont(Font font) {
        this.font = font;
    }

    public BufferedDynamicImageResource getPreviewImage() {
        if (this.previewImage == null) {
            this.previewImage = this.createPreviewImage();
        }
        return this.previewImage;
    }

    private BufferedDynamicImageResource createPreviewImage() {
        BufferedImage bi = new BufferedImage(450, 16, 2);
        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int stringHeight = fontMetrics.getAscent();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setPaint(Color.BLACK);
        GlyphVector gv = this.font.createGlyphVector(graphics2D.getFontRenderContext(), "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray());
        AffineTransform at = AffineTransform.getTranslateInstance(2.0, 8 + stringHeight / 4);
        Shape sample = at.createTransformedShape(gv.getOutline());
        graphics2D.fill(sample);
        BufferedDynamicImageResource generatedImage = new BufferedDynamicImageResource("png");
        generatedImage.setImage(bi);
        return generatedImage;
    }

    public String getFontName() {
        return this.font.getFontName();
    }
}

