/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.web.GeoServerUnlockablePage;
import org.geoserver.web.ServerBusyPage;
import org.geoserver.web.WicketCallback;

public class WicketConfigurationLockCallback
implements WicketCallback {
    GeoServerConfigurationLock locker;

    public WicketConfigurationLockCallback(GeoServerConfigurationLock locker) {
        this.locker = locker;
    }

    @Override
    public void onBeginRequest() {
    }

    @Override
    public void onAfterTargetsDetached() {
    }

    @Override
    public void onEndRequest() {
        this.locker.unlock();
    }

    @Override
    public void onRequestTargetSet(RequestCycle cycle, Class<? extends IRequestablePage> requestTarget) {
        if (!GeoServerUnlockablePage.class.isAssignableFrom(requestTarget)) {
            GeoServerConfigurationLock.LockType type = this.locker.getCurrentLock();
            if (type != null || requestTarget == null) {
                return;
            }
            boolean lockTaken = false;
            if (type == null) {
                lockTaken = this.locker.tryLock(GeoServerConfigurationLock.LockType.READ);
            }
            if (cycle != null && !lockTaken) {
                cycle.setResponsePage(ServerBusyPage.class);
            }
        }
    }

    @Override
    public void onRuntimeException(RequestCycle cycle, Exception ex) {
    }
}

