/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.InternationalStringPanel;

public class StringAndInternationalStringPanel
extends Panel {
    public StringAndInternationalStringPanel(String id, IModel<?> model, WebMarkupContainer labelProvider) {
        this(id, model, id, id, "international" + id.substring(0, 1).toUpperCase() + id.substring(1), labelProvider);
    }

    public StringAndInternationalStringPanel(String id, IModel<?> model, String labelKey, String stringProperty, String internationalProperty, WebMarkupContainer labelProvider) {
        this(id, model, labelKey, stringProperty, internationalProperty, labelProvider, null);
    }

    public StringAndInternationalStringPanel(String id, IModel<?> model, String labelKey, String stringProperty, String internationalProperty, WebMarkupContainer labelProvider, final IValidator<String> validator) {
        super(id, model);
        WebMarkupContainer container = new WebMarkupContainer("labelContainer");
        this.add(new Component[]{container});
        container.add(new Component[]{new Label("stringLabel", (IModel)new StringResourceModel(labelKey, (Component)labelProvider))});
        TextField title = new TextField("stringField", (IModel)new PropertyModel(model, stringProperty));
        this.add(new Component[]{title});
        if (validator != null) {
            title.add(validator);
        }
        InternationalStringPanel<TextField<String>> internationalStringField = new InternationalStringPanel<TextField<String>>("internationalField", (IModel)new PropertyModel(model, internationalProperty), title, container){

            @Override
            protected TextField<String> getTextComponent(String id, IModel<String> model) {
                TextField field = new TextField(id, model);
                if (validator != null) {
                    field.add(validator);
                }
                return field;
            }
        };
        this.add(new Component[]{internationalStringField});
    }
}

