/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.crypt.AbstractCrypt;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.web.GeoServerApplication;
import org.geotools.util.logging.Logging;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;

public class GeoserverWicketEncrypterFactory
implements ICryptFactory {
    static ICryptFactory Factory;
    protected static Logger LOGGER;
    static final String ICRYPT_ATTR_NAME = "__ICRYPT";
    ICrypt NoCrypt = new ICrypt(){

        public String decryptUrlSafe(String text) {
            return text;
        }

        public String encryptUrlSafe(String plainText) {
            return plainText;
        }

        public void setKey(String key) {
        }
    };

    public static ICryptFactory get() {
        if (Factory != null) {
            return Factory;
        }
        Factory = (ICryptFactory)GeoServerExtensions.bean(ICryptFactory.class);
        if (Factory == null) {
            Factory = new GeoserverWicketEncrypterFactory();
        }
        return Factory;
    }

    protected GeoserverWicketEncrypterFactory() {
    }

    public ICrypt newCrypt() {
        RequestCycle cycle = RequestCycle.get();
        ServletWebRequest req = (ServletWebRequest)cycle.getRequest();
        HttpSession s = req.getContainerRequest().getSession(false);
        if (s != null) {
            return this.getEncrypterFromSession(s);
        }
        LOGGER.warning("No session availabe to get url parameter encrypter");
        return this.NoCrypt;
    }

    protected ICrypt getEncrypterFromSession(HttpSession s) {
        Object result = (ICrypt)s.getAttribute(ICRYPT_ATTR_NAME);
        if (result != null) {
            return result;
        }
        GeoServerSecurityManager manager = GeoServerApplication.get().getSecurityManager();
        char[] key = manager.getRandomPassworddProvider().getRandomPasswordWithDefaultLength();
        StandardPBEByteEncryptor enc = new StandardPBEByteEncryptor();
        enc.setPasswordCharArray(key);
        manager.disposePassword(key);
        if (manager.isStrongEncryptionAvailable()) {
            enc.setProvider((Provider)new BouncyCastleProvider());
            enc.setAlgorithm("PBEWITHSHA256AND128BITAES-CBC-BC");
        } else {
            enc.setAlgorithm("PBEWITHMD5ANDDES");
        }
        result = new CryptImpl(enc);
        s.setAttribute(ICRYPT_ATTR_NAME, result);
        return result;
    }

    static {
        LOGGER = Logging.getLogger((String)"org.geoserver.security");
    }

    class CryptImpl
    extends AbstractCrypt {
        protected StandardPBEByteEncryptor enc;

        CryptImpl(StandardPBEByteEncryptor enc) {
            this.enc = enc;
        }

        protected byte[] crypt(byte[] input, int mode) throws GeneralSecurityException {
            if (mode == 1) {
                return this.enc.encrypt(input);
            }
            return this.enc.decrypt(input);
        }
    }
}

