/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.web.Category;
import org.geoserver.web.ComponentInfo;
import org.geoserver.web.DefaultGeoServerNodeInfo;
import org.geoserver.web.DeveloperToolbar;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerNodeInfo;
import org.geoserver.web.HeaderContribution;
import org.geoserver.web.LoginFormHTMLInclude;
import org.geoserver.web.LoginFormInfo;
import org.geoserver.web.MenuPageInfo;
import org.geoserver.web.spring.security.GeoServerSession;
import org.geoserver.web.util.LocalizationsFinder;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public class GeoServerBasePage
extends WebPage
implements IAjaxIndicatorAware {
    protected static final String HEADER_PANEL = "headerPanel";
    protected static final Logger LOGGER = Logging.getLogger(GeoServerBasePage.class);
    protected static volatile GeoServerNodeInfo NODE_INFO;
    protected FeedbackPanel topFeedbackPanel;
    protected FeedbackPanel bottomFeedbackPanel;
    protected Page returnPage;
    protected Class<? extends Page> returnPageClass;
    public static final String VERSION_3 = "jquery/jquery-3.5.1.js";

    protected GeoServerBasePage(PageParameters parameters) {
        super(parameters);
        this.commonBaseInit();
    }

    protected GeoServerBasePage() {
        this.commonBaseInit();
    }

    protected void commonBaseInit() {
        PackageResourceReference faviconReference = null;
        List<HeaderContribution> cssContribs = this.getGeoServerApplication().getBeansOfType(HeaderContribution.class);
        for (HeaderContribution csscontrib : cssContribs) {
            try {
                PackageResourceReference ref;
                if (!csscontrib.appliesTo(this) || (ref = csscontrib.getFavicon()) == null) continue;
                faviconReference = ref;
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem adding header contribution", t);
            }
        }
        if (faviconReference == null) {
            faviconReference = new PackageResourceReference(GeoServerBasePage.class, "favicon.ico");
        }
        String faviconUrl = RequestCycle.get().urlFor(faviconReference, null).toString();
        this.add(new Component[]{new ExternalLink("faviconLink", faviconUrl, null)});
        this.add(new Component[]{new Label("pageTitle", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return GeoServerBasePage.this.getPageTitle();
            }
        })});
        GeoServerSecurityManager securityManager = this.getGeoServerApplication().getSecurityManager();
        SecurityManagerConfig securityConfig = securityManager.getSecurityConfig();
        List securityFiltersNames = securityConfig.getFilterChain().filtersFor("/web/**");
        final ArrayList<String> securityFilterClassNames = new ArrayList<String>();
        for (String name : securityFiltersNames) {
            try {
                SecurityFilterConfig config = securityManager.loadFilterConfig(name, true);
                securityFilterClassNames.add(config.getClassName());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Could not load security filter config for " + name, e);
            }
        }
        Authentication user = GeoServerSession.get().getAuthentication();
        final boolean anonymous = user == null || user instanceof AnonymousAuthenticationToken;
        List<LoginFormInfo> loginforms = this.filterByAuth(this.getGeoServerApplication().getBeansOfType(LoginFormInfo.class));
        this.add(new Component[]{new ListView<LoginFormInfo>("loginforms", loginforms){

            public void populateItem(ListItem<LoginFormInfo> item) {
                final LoginFormInfo info = (LoginFormInfo)item.getModelObject();
                WebMarkupContainer loginForm = new WebMarkupContainer("loginform"){

                    protected void onComponentTag(ComponentTag tag) {
                        String loginPath = GeoServerBasePage.this.getResourcePath(info.getLoginPath());
                        tag.put("action", (CharSequence)loginPath);
                    }
                };
                Image image = info.getIcon() != null ? new Image("link.icon", (ResourceReference)new PackageResourceReference(info.getComponentClass(), info.getIcon()), new ResourceReference[0]) : new Image("link.icon", (ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/door-in.png"), new ResourceReference[0]);
                loginForm.add(new Component[]{image});
                if (info.getTitleKey() != null && !info.getTitleKey().isEmpty()) {
                    loginForm.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), null, null))});
                    image.add(new Behavior[]{AttributeModifier.replace((String)"alt", (IModel)new ParamResourceModel(info.getTitleKey(), null, new Object[0]))});
                } else {
                    loginForm.add(new Component[]{new Label("link.label", (Serializable)((Object)""))});
                }
                LoginFormHTMLInclude include = info.getInclude() != null ? new LoginFormHTMLInclude("login.include", new PackageResourceReference(info.getComponentClass(), info.getInclude())) : new LoginFormHTMLInclude("login.include", null);
                loginForm.add(new Component[]{include});
                item.add(new Component[]{loginForm});
                boolean filterInChain = false;
                for (String filterClassName : securityFilterClassNames) {
                    if (!filterClassName.equals(info.getFilterClass().getName())) continue;
                    filterInChain = true;
                    break;
                }
                loginForm.setVisible(anonymous && filterInChain);
            }
        }});
        WebMarkupContainer loggedInAsForm = new WebMarkupContainer("loggedinasform");
        loggedInAsForm.add(new Component[]{new Label("loggedInUsername", (Serializable)((Object)GeoServerSession.get().getUsername()))});
        loggedInAsForm.setVisible(!anonymous);
        this.add(new Component[]{loggedInAsForm});
        WebMarkupContainer logoutForm = new WebMarkupContainer("logoutform"){

            protected void onComponentTag(ComponentTag tag) {
                String logoutPath = GeoServerBasePage.this.getResourcePath("j_spring_security_logout");
                tag.put("action", (CharSequence)logoutPath);
            }
        };
        this.add(new Component[]{logoutForm});
        Image image = new Image("link.icon", (ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/door-out.png"), new ResourceReference[0]);
        logoutForm.add(new Component[]{image});
        logoutForm.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel("logout", null, null))});
        image.add(new Behavior[]{AttributeModifier.replace((String)"alt", (IModel)new ParamResourceModel("logout", null, new Object[0]))});
        logoutForm.setVisible(!anonymous);
        this.add(new Component[]{new BookmarkablePageLink("home", GeoServerHomePage.class)});
        DeveloperToolbar devToolbar = new DeveloperToolbar("devButtons");
        this.add(new Component[]{devToolbar});
        devToolbar.setVisible(RuntimeConfigurationType.DEVELOPMENT.equals((Object)this.getApplication().getConfigurationType()));
        List infos = this.filterByAuth(this.getGeoServerApplication().getBeansOfType(MenuPageInfo.class));
        final Map links = this.splitByCategory(infos);
        List<Object> standalone = links.containsKey(null) ? links.get(null) : new ArrayList();
        links.remove(null);
        ArrayList<Category> categories = new ArrayList<Category>(links.keySet());
        Collections.sort(categories);
        this.add(new Component[]{new ListView<Category>("category", categories){

            public void populateItem(ListItem<Category> item) {
                Category category = (Category)item.getModelObject();
                GeoServerBasePage.this.createCategoryComponent(item, category, links);
            }
        }});
        this.add(new Component[]{new ListView<MenuPageInfo<GeoServerBasePage>>("standalone", standalone){

            public void populateItem(ListItem<MenuPageInfo<GeoServerBasePage>> item) {
                MenuPageInfo info = (MenuPageInfo)item.getModelObject();
                BookmarkablePageLink link = new BookmarkablePageLink("link", info.getComponentClass());
                link.add(new Behavior[]{AttributeModifier.replace((String)"title", (IModel)new StringResourceModel(info.getDescriptionKey(), null, null))});
                link.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), null, null))});
                item.add(new Component[]{link});
            }
        }});
        Component[] componentArray = new Component[1];
        this.topFeedbackPanel = new FeedbackPanel("topFeedback");
        componentArray[0] = this.topFeedbackPanel;
        this.add(componentArray);
        this.topFeedbackPanel.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.bottomFeedbackPanel = new FeedbackPanel("bottomFeedback");
        componentArray2[0] = this.bottomFeedbackPanel;
        this.add(componentArray2);
        this.bottomFeedbackPanel.setOutputMarkupId(true);
        this.add(new Component[]{new Image("ajaxFeedbackImage", (ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "img/ajax-loader.gif"), new ResourceReference[0])});
        this.add(new Component[]{new WebMarkupContainer(HEADER_PANEL)});
        this.add(new Component[]{new Label("gbpTitle", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return GeoServerBasePage.this.getTitle();
            }
        })});
        Label gbpDescription = new Label("gbpDescription", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return GeoServerBasePage.this.getDescription();
            }
        });
        gbpDescription.setEscapeModelStrings(false);
        this.add(new Component[]{gbpDescription});
        WebMarkupContainer container = new WebMarkupContainer("nodeIdContainer");
        this.add(new Component[]{container});
        String id = this.getNodeInfo().getId();
        Label label = new Label("nodeId", (Serializable)((Object)id));
        container.add(new Component[]{label});
        NODE_INFO.customize(container);
        if (id == null) {
            container.setVisible(false);
        }
        this.add(new Component[]{this.localeSwitcher()});
    }

    private Component localeSwitcher() {
        final DropDownChoice select = new DropDownChoice("localeSwitcher", (IModel)new Model((Serializable)this.getSessionLocale()), this.getLocalesModel());
        select.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                Locale locale = (Locale)select.getModelObject();
                if (locale == null) {
                    Cookie languageCookie = new Cookie("GeoServerUILanguage", null);
                    ((WebResponse)GeoServerBasePage.this.getResponse()).clearCookie(languageCookie);
                    locale = target.getPage().getRequest().getLocale();
                    if (locale == null) {
                        locale = Locale.ENGLISH;
                    }
                } else {
                    GeoServerBasePage.this.getGeoServerApplication().refreshLocaleCookie(GeoServerBasePage.this.getResponse(), locale);
                }
                GeoServerBasePage.this.getSession().setLocale(locale);
                target.add(new Component[]{GeoServerBasePage.this.getPage()});
            }
        }});
        return select;
    }

    private List<Locale> getLocalesModel() {
        ArrayList<Locale> model = new ArrayList<Locale>();
        model.add(null);
        model.addAll(LocalizationsFinder.getAvailableLocales());
        return model;
    }

    private Locale getSessionLocale() {
        Locale locale = this.getSession().getLocale();
        if (locale == null) {
            return Locale.ENGLISH;
        }
        List<Locale> locales = LocalizationsFinder.getAvailableLocales();
        if (locales.contains(locale)) {
            return locale;
        }
        return locales.stream().filter(l -> locale.getLanguage().equals(l.getLanguage())).findFirst().orElse(Locale.ENGLISH);
    }

    private void createCategoryComponent(ListItem<Category> item, Category category, Map<Category, List<MenuPageInfo<GeoServerBasePage>>> links) {
        item.add(new Component[]{new Label("category.header", (IModel)new StringResourceModel(category.getNameKey(), null, null))});
        item.add(new Component[]{new ListView<MenuPageInfo<GeoServerBasePage>>("category.links", links.get(category)){

            public void populateItem(ListItem<MenuPageInfo<GeoServerBasePage>> item) {
                GeoServerBasePage.this.createMenuComponent(item);
            }
        }});
    }

    private void createMenuComponent(ListItem<MenuPageInfo<GeoServerBasePage>> item) {
        MenuPageInfo info = (MenuPageInfo)item.getModelObject();
        BookmarkablePageLink<Page> link = new BookmarkablePageLink<Page>("link", info.getComponentClass()){

            public PageParameters getPageParameters() {
                PageParameters pageParams = super.getPageParameters();
                pageParams.add("filter", (Object)false, INamedParameters.Type.PATH);
                return pageParams;
            }
        };
        link.add(new Behavior[]{AttributeModifier.replace((String)"title", (IModel)new StringResourceModel(info.getDescriptionKey(), null, null))});
        link.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), null, null))});
        Image image = info.getIcon() != null ? new Image("link.icon", (ResourceReference)new PackageResourceReference(info.getComponentClass(), info.getIcon()), new ResourceReference[0]) : new Image("link.icon", (ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "img/icons/silk/wrench.png"), new ResourceReference[0]);
        image.add(new Behavior[]{AttributeModifier.replace((String)"alt", (IModel)new ParamResourceModel(info.getTitleKey(), null, new Object[0]))});
        link.add(new Component[]{image});
        item.add(new Component[]{link});
    }

    private String getResourcePath(String path) {
        HttpServletRequest hr = ((GeoServerApplication)this.getApplication()).servletRequest(this.getRequest());
        String baseURL = ResponseUtils.baseURL((HttpServletRequest)hr);
        return ResponseUtils.buildURL((String)baseURL, (String)path, null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryResourceReference.INSTANCE_3)));
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "css/blueprint/screen.css"), (String)"screen, projection"));
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "css/blueprint/print.css"), (String)"print"));
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "css/bootstrap-utilities.min.css"), (String)"all"));
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "css/geoserver.css"), (String)"screen, projection"));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "js/jquery.placeholder.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "js/jquery.fullscreen.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(GeoServerBasePage.class, "js/jquery.hide.ajaxFeedback.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"$('input, textarea').placeholder();"));
        List<HeaderContribution> cssContribs = this.getGeoServerApplication().getBeansOfType(HeaderContribution.class);
        for (HeaderContribution csscontrib : cssContribs) {
            try {
                if (!csscontrib.appliesTo(this)) continue;
                PackageResourceReference ref = csscontrib.getCSS();
                if (ref != null) {
                    response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)ref));
                }
                if ((ref = csscontrib.getJavaScript()) != null) {
                    response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ref));
                }
                ref = csscontrib.getFavicon();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem adding header contribution", t);
            }
        }
    }

    private GeoServerNodeInfo getNodeInfo() {
        if (NODE_INFO == null) {
            GeoServerNodeInfo info = (GeoServerNodeInfo)GeoServerExtensions.bean(GeoServerNodeInfo.class);
            if (info == null) {
                info = new DefaultGeoServerNodeInfo();
            }
            NODE_INFO = info;
        }
        return NODE_INFO;
    }

    protected String getTitle() {
        return new ParamResourceModel("title", (Component)this, new Object[0]).getString();
    }

    protected String getDescription() {
        return new ParamResourceModel("description", (Component)this, new Object[0]).getString();
    }

    String getPageTitle() {
        try {
            return "GeoServer: " + this.getTitle();
        }
        catch (Exception e) {
            LOGGER.warning(((Object)((Object)this)).getClass().getSimpleName() + " does not have a title set");
            return "GeoServer";
        }
    }

    protected void setHeaderPanel(Component component) {
        if (!HEADER_PANEL.equals(component.getId())) {
            throw new IllegalArgumentException("The header panel component must have 'headerPanel' id");
        }
        this.remove(HEADER_PANEL);
        this.add(new Component[]{component});
    }

    protected GeoServerApplication getGeoServerApplication() {
        return (GeoServerApplication)this.getApplication();
    }

    public GeoServerSession getSession() {
        return (GeoServerSession)super.getSession();
    }

    protected GeoServer getGeoServer() {
        return this.getGeoServerApplication().getGeoServer();
    }

    protected Catalog getCatalog() {
        return this.getGeoServerApplication().getCatalog();
    }

    private <T extends GeoServerBasePage> Map<Category, List<MenuPageInfo<T>>> splitByCategory(List<MenuPageInfo<T>> pages) {
        Collections.sort(pages);
        HashMap<Category, List<MenuPageInfo<T>>> map = new HashMap<Category, List<MenuPageInfo<T>>>();
        for (MenuPageInfo<T> page : pages) {
            Category cat = page.getCategory();
            if (!map.containsKey(cat)) {
                map.put(cat, new ArrayList());
            }
            ((List)map.get(cat)).add(page);
        }
        return map;
    }

    protected <T extends ComponentInfo> List<T> filterByAuth(List<T> list) {
        Authentication user = this.getSession().getAuthentication();
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        for (ComponentInfo component : list) {
            if (component.getAuthorizer() == null) continue;
            Class clazz = component.getComponentClass();
            if (!component.getAuthorizer().isAccessAllowed(clazz, user)) continue;
            result.add(component);
        }
        return result;
    }

    public String getAjaxIndicatorMarkupId() {
        return "ajaxFeedback";
    }

    public GeoServerBasePage setReturnPage(Page returnPage) {
        this.returnPage = returnPage;
        return this;
    }

    public GeoServerBasePage setReturnPage(Class<? extends Page> returnPageClass) {
        this.returnPageClass = returnPageClass;
        return this;
    }

    protected void doReturn() {
        this.doReturn(null);
    }

    protected void doReturn(Class<? extends Page> defaultPageClass) {
        if (this.returnPage != null) {
            this.setResponsePage((IRequestablePage)this.returnPage);
            return;
        }
        if (this.returnPageClass != null) {
            this.setResponsePage(this.returnPageClass);
            return;
        }
        defaultPageClass = defaultPageClass != null ? defaultPageClass : GeoServerHomePage.class;
        this.setResponsePage(defaultPageClass);
    }

    public void addFeedbackPanels(AjaxRequestTarget target) {
        target.add(new Component[]{this.topFeedbackPanel});
        target.add(new Component[]{this.bottomFeedbackPanel});
    }
}

