/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.gce.imagemosaic.egr.RendererUtilities;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

class Tile {
    private static final Logger LOGGER = Logging.getLogger(Tile.class);
    private static final boolean antiAliasing = false;
    private static final byte FF = -1;
    static Map<String, WritableRaster> solidRasterCache = new SoftValueHashMap();
    private static final ColorModel BINARY_COLOR_MODEL = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
    private static MultiPixelPackedSampleModel DEFAULT_PACKED_SAMPLE_MODEL = new MultiPixelPackedSampleModel(0, 256, 256, 1);
    static Map<String, MultiPixelPackedSampleModel> mpSampleModelCache = new SoftValueHashMap();
    private final int tileWidth;
    private final int tileHeight;
    private final int stdTileWidth;
    private final int stdTileHeight;
    private final int col;
    private final int row;
    private Polygon tileBBox;
    private long coverageCount;
    private WritableRaster raster;
    private BufferedImage bi;
    private Graphics2D graphics;
    private BitSet rowFull;
    private Rectangle tileArea;

    public Tile(int tileWidth, int tileHeight, int col, int row, AffineTransform w2s) {
        this(tileWidth, tileHeight, col, row, w2s, tileWidth, tileHeight);
    }

    public Tile(int tileWidth, int tileHeight, int col, int row, AffineTransform w2s, int stdTileWidth, int stdTileHeight) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.col = col;
        this.row = row;
        this.stdTileWidth = stdTileWidth;
        this.stdTileHeight = stdTileHeight;
        this.rowFull = new BitSet(tileHeight);
        this.tileArea = new Rectangle(col * stdTileWidth, row * stdTileHeight, tileWidth, tileHeight);
        try {
            Envelope e = RendererUtilities.createMapEnvelope(this.tileArea, w2s);
            this.tileBBox = JTS.toGeometry(e);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("TileBBox: " + this.tileBBox);
            }
        }
        catch (NoninvertibleTransformException ex) {
            LOGGER.log(Level.SEVERE, "Error creating tile", ex);
            this.tileBBox = null;
        }
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public long getCoverageCount() {
        return this.coverageCount;
    }

    public boolean isFullyCovered() {
        return (long)(this.tileWidth * this.tileHeight) == this.coverageCount;
    }

    public Polygon getTileBBox() {
        return this.tileBBox;
    }

    private void initGraphics(boolean inverted) {
        this.initRaster(inverted);
        if (this.graphics == null) {
            Color drawColor = inverted ? Color.BLACK : Color.WHITE;
            this.bi = new BufferedImage(BINARY_COLOR_MODEL, this.raster, false, null);
            this.bi.setAccelerationPriority(0.0f);
            this.graphics = this.bi.createGraphics();
            boolean offset = false;
            this.graphics.setClip(0, 0, this.tileWidth + 0, this.tileHeight + 0);
            this.graphics.translate(-this.col * this.stdTileWidth, -this.row * this.stdTileHeight);
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.graphics.setColor(drawColor);
        }
    }

    private void initRaster(boolean inverted) {
        if (this.raster == null) {
            this.allocateRaster(inverted);
        }
    }

    public boolean refreshCoverageCount() throws IllegalStateException {
        if (this.raster == null) {
            throw new IllegalStateException("Raster not initialized");
        }
        long cnt = 0L;
        this.raster.getSampleModel();
        int scanlineStride = ((MultiPixelPackedSampleModel)this.raster.getSampleModel()).getScanlineStride();
        DataBufferByte data = (DataBufferByte)this.raster.getDataBuffer();
        byte[] bytes = data.getData();
        int pos = 0;
        for (int row = 0; row < this.tileHeight; ++row) {
            if (this.rowFull.get(row)) {
                cnt += (long)this.tileWidth;
                pos += scanlineStride;
                continue;
            }
            int rowCnt = 0;
            for (int col = 0; col < scanlineStride; ++col) {
                byte b = bytes[pos++];
                int count = Integer.bitCount(0xFF & b);
                rowCnt += count;
            }
            cnt += (long)rowCnt;
            if (rowCnt < this.tileWidth) continue;
            this.rowFull.set(row);
        }
        if (this.coverageCount == cnt) {
            return false;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Updating count for " + this + " to " + cnt);
        }
        this.coverageCount = cnt;
        return true;
    }

    public boolean draw(PlanarImage binaryImage) {
        this.initRaster(false);
        Rectangle imageBounds = binaryImage.getBounds();
        Rectangle overlapArea = imageBounds.intersection(this.tileArea);
        if (overlapArea.isEmpty()) {
            return false;
        }
        int xOffset = this.tileArea.x;
        int yOffset = this.tileArea.y;
        Rectangle tileOverlap = new Rectangle(overlapArea.x - xOffset, overlapArea.y - yOffset, overlapArea.width, overlapArea.height);
        RandomIter sourceIter = RandomIterFactory.create((RenderedImage)binaryImage, (Rectangle)overlapArea, (boolean)true, (boolean)true);
        WritableRandomIter rasterIter = RandomIterFactory.createWritable((WritableRaster)this.raster, (Rectangle)tileOverlap);
        boolean added = false;
        int maxCol = overlapArea.x + overlapArea.width;
        int maxRow = overlapArea.y + overlapArea.height;
        for (int row = overlapArea.y; row < maxRow; ++row) {
            for (int col = overlapArea.x; col < maxCol; ++col) {
                int maskValue = sourceIter.getSample(col, row, 0);
                int rasValue = rasterIter.getSample(col - xOffset, row - yOffset, 0);
                if (maskValue != 1 || rasValue != 0) continue;
                rasterIter.setSample(col - xOffset, row - yOffset, 0, 1);
                ++this.coverageCount;
                added = true;
            }
        }
        return added;
    }

    private void allocateRaster(boolean inverted) {
        WritableRaster result;
        int value;
        int n = value = inverted ? 1 : 0;
        if (this.tileWidth != this.tileHeight || value == 0) {
            result = this.buildSolidRaster(this.tileWidth, this.tileHeight, value);
        } else {
            Raster template = this.getSolidRaster(this.tileWidth, this.tileHeight, value);
            result = template.createCompatibleWritableRaster();
            byte[] src = ((DataBufferByte)template.getDataBuffer()).getData();
            byte[] dst = ((DataBufferByte)result.getDataBuffer()).getData();
            System.arraycopy(src, 0, dst, 0, src.length);
        }
        this.raster = result;
    }

    Raster getSolidRaster(int tileWidth, int tileHeight, int value) {
        String key = tileWidth + "x" + tileHeight + "_" + value;
        WritableRaster result = solidRasterCache.get(key);
        if (result == null) {
            result = this.buildSolidRaster(tileWidth, tileHeight, value);
            solidRasterCache.put(key, result);
        }
        return result;
    }

    private WritableRaster buildSolidRaster(int tileWidth, int tileHeight, int value) {
        SampleModel sampleModel = this.getMPSampleModel(tileWidth, tileHeight);
        WritableRaster newRaster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (Point)new Point(0, 0));
        int dataType = sampleModel.getTransferType();
        int numBands = sampleModel.getNumBands();
        if (dataType != 0) {
            throw new IllegalArgumentException("The code works only if the sample model data type is BYTE");
        }
        if (numBands != 1) {
            throw new IllegalArgumentException("The code works only for single band rasters!");
        }
        if (value != 0) {
            int w = sampleModel.getWidth();
            int h = sampleModel.getHeight();
            int[] data = new int[w * h];
            Arrays.fill(data, value);
            newRaster.setSamples(0, 0, w, h, 0, data);
        }
        return newRaster;
    }

    private SampleModel getMPSampleModel(int tileWidth, int tileHeight) {
        SampleModel sampleModel;
        if (tileWidth == 256 && tileHeight == 256) {
            sampleModel = DEFAULT_PACKED_SAMPLE_MODEL;
        } else {
            String key = tileWidth + "x" + tileHeight;
            sampleModel = mpSampleModelCache.get(key);
            if (sampleModel == null) {
                sampleModel = new MultiPixelPackedSampleModel(0, tileWidth, tileHeight, 1);
                mpSampleModelCache.put(key, (MultiPixelPackedSampleModel)sampleModel);
            }
        }
        return sampleModel;
    }

    public void draw(Shape projectedShape) {
        this.draw(projectedShape, false);
    }

    public void draw(Shape projectedShape, boolean inverted) {
        this.initGraphics(inverted);
        Color drawColor = inverted ? Color.BLACK : Color.WHITE;
        this.graphics.setColor(drawColor);
        this.graphics.fill(projectedShape);
    }

    public void draw() {
        this.initRaster(false);
    }

    public void dispose() {
        if (this.graphics != null) {
            this.graphics.dispose();
        }
        this.bi = null;
        this.raster = null;
    }

    public String toString() {
        return "Tile[" + this.col + "x" + this.row + ":" + this.coverageCount + "]";
    }

    WritableRaster getRaster() {
        return this.raster;
    }

    public Rectangle getTileArea() {
        return this.tileArea;
    }
}

