/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DecoratingSimpleFeatureIterator;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.SupportFilesCollector;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.PushbackFeatureIterator;
import org.geotools.util.URLs;

class FileViewCollection
extends DecoratingSimpleFeatureCollection {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static final String IMAGEINDEX = "imageindex";
    private final PathType pathType;
    private final String parentLocation;
    private final String locationAttribute;
    private final SimpleFeatureType schema;
    private final SimpleFeatureBuilder featureBuilder;

    protected FileViewCollection(GranuleCatalog catalog, Query query, RasterManager manager) throws IOException {
        super(FileViewCollection.getDelegateCollection(catalog, query, manager));
        this.pathType = manager.getPathType();
        this.parentLocation = manager.getParentLocation();
        this.locationAttribute = manager.getLocationAttribute();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)this.delegate.getSchema());
        tb.remove(this.locationAttribute);
        if (((SimpleFeatureType)this.delegate.getSchema()).getAttributeDescriptors().stream().anyMatch(d -> IMAGEINDEX.equals(d.getLocalName()))) {
            tb.remove(IMAGEINDEX);
        }
        this.schema = tb.buildFeatureType();
        this.featureBuilder = new SimpleFeatureBuilder(this.schema);
    }

    private static SimpleFeatureCollection getDelegateCollection(GranuleCatalog catalog, Query query, RasterManager manager) throws IOException {
        ArrayList<SortBy> sorts = new ArrayList<SortBy>();
        String locationAttribute = manager.getLocationAttribute();
        sorts.add(FF.sort(locationAttribute, SortOrder.ASCENDING));
        manager.getDimensionDescriptors().stream().map(dd -> FF.sort(dd.getStartAttribute(), SortOrder.ASCENDING)).forEach(sorts::add);
        if (query.getSortBy() != null && query.getSortBy().length > 0) {
            sorts.addAll(Arrays.asList(query.getSortBy()));
        }
        Query updated = new Query(query);
        updated.setSortBy(sorts.toArray(new SortBy[sorts.size()]));
        return catalog.getGranules(updated);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public SimpleFeatureIterator features() {
        final PushbackFeatureIterator pit = new PushbackFeatureIterator(this.delegate.features());
        return new DecoratingSimpleFeatureIterator(pit){

            @Override
            public SimpleFeature next() throws NoSuchElementException {
                if (this.delegate == null || !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                SimpleFeature sample = pit.next();
                String location = (String)sample.getAttribute(FileViewCollection.this.locationAttribute);
                while (pit.hasNext()) {
                    SimpleFeature next = pit.next();
                    String nextLocation = (String)next.getAttribute(FileViewCollection.this.locationAttribute);
                    if (location.equals(nextLocation)) continue;
                    pit.pushBack();
                    break;
                }
                return FileViewCollection.this.remapFeature(sample);
            }
        };
    }

    private SimpleFeature remapFeature(SimpleFeature feature) {
        String location = (String)feature.getAttribute(this.locationAttribute);
        URL path = this.pathType.resolvePath(this.parentLocation, location);
        this.schema.getAttributeDescriptors().stream().filter(d -> !location.equals(d.getLocalName())).forEach(d -> this.featureBuilder.set(d.getLocalName(), feature.getAttribute(d.getLocalName())));
        File mainFile = URLs.urlToFile((URL)path);
        if (mainFile != null) {
            SupportFilesCollector collector = SupportFilesCollector.getCollectorFor(mainFile);
            List<File> supportFiles = Collections.emptyList();
            if (collector != null) {
                supportFiles = collector.getSupportFiles(mainFile.getPath());
            }
            this.featureBuilder.featureUserData("GranuleFiles", new FileGroupProvider.FileGroup(mainFile, supportFiles, Collections.emptyMap()));
        } else {
            this.featureBuilder.featureUserData("GranuleFiles", path);
        }
        return this.featureBuilder.buildFeature(feature.getID());
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        return new FilteringSimpleFeatureCollection(this, filter);
    }
}

