/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.geotools.api.data.ResourceInfo;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.PAMResourceInfo;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.RATCollector;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class RATCollectorListener
extends ImageMosaicEventHandlers.ProcessingEventListener {
    static final Logger LOGGER = Logging.getLogger(RATCollectorListener.class);
    private final File pamFile;
    private List<RATCollector> collectors = new ArrayList<RATCollector>();
    PAMDataset first = null;
    boolean stopCollection = false;

    public RATCollectorListener(CatalogBuilderConfiguration configuration) {
        String root = configuration.getParameter("RootMosaicDirectory");
        String name = configuration.getParameter("Name");
        this.pamFile = new File(root, name + ".aux.xml");
    }

    public RATCollectorListener(File pamFile) {
        this.pamFile = pamFile;
    }

    @Override
    public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
        if (this.stopCollection) {
            return;
        }
        if (event instanceof ImageMosaicEventHandlers.FileProcessingEvent) {
            ImageMosaicEventHandlers.FileProcessingEvent fileEvent = (ImageMosaicEventHandlers.FileProcessingEvent)event;
            if (!fileEvent.isIngested()) {
                return;
            }
            File file = fileEvent.getFile();
            this.collectRAT(file);
        } else if (event instanceof ImageMosaicEventHandlers.CompletionEvent) {
            this.generateMosaicRAT();
        }
    }

    public void collectRAT(File file) {
        File pamFile = new File(file.getParent(), file.getName() + ".aux.xml");
        if (pamFile.exists() && pamFile.isFile() && pamFile.canRead()) {
            this.collectExternalRAT(pamFile);
        } else {
            this.collectInternalRAT(file);
        }
    }

    public void generateMosaicRAT() {
        if (this.stopCollection) {
            return;
        }
        for (int band = 0; band < this.collectors.size(); ++band) {
            RATCollector collector = this.collectors.get(band);
            if (collector == null) continue;
            collector.replaceRows(this.first, band);
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)"it.geosolutions.imageio.pam");
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this.first, this.pamFile);
        }
        catch (JAXBException e) {
            LOGGER.log(Level.SEVERE, "Failed to write the final PAM file", e);
            throw new RuntimeException(e);
        }
    }

    private void collectExternalRAT(File pamFile) {
        try {
            PAMParser parser = new PAMParser();
            PAMDataset pam = parser.parsePAM(pamFile);
            this.collectRAT(pam);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error parsing PAM file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectInternalRAT(File file) {
        AbstractGridCoverage2DReader reader = Optional.ofNullable(GridFormatFinder.findFormat((Object)file, (Hints)Utils.EXCLUDE_MOSAIC_HINTS)).map(f -> f.getReader((Object)file)).orElse(null);
        if (reader != null) {
            try {
                ResourceInfo info = reader.getInfo(reader.getGridCoverageNames()[0]);
                if (info instanceof PAMResourceInfo) {
                    PAMResourceInfo pamInfo = (PAMResourceInfo)info;
                    PAMDataset pam = pamInfo.getPAMDataset();
                    this.collectRAT(pam);
                }
            }
            finally {
                reader.dispose();
            }
        }
    }

    private void collectRAT(PAMDataset pam) {
        if (pam == null || pam.getPAMRasterBand() == null || pam.getPAMRasterBand().isEmpty()) {
            return;
        }
        List bands = pam.getPAMRasterBand();
        if (this.first == null) {
            this.first = pam;
            for (int i = 0; i < bands.size(); ++i) {
                PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = ((PAMDataset.PAMRasterBand)bands.get(i)).getGdalRasterAttributeTable();
                if (rat == null) {
                    this.collectors.add(null);
                    continue;
                }
                this.collectors.add(new RATCollector(i, rat));
            }
        } else if (!this.checkCompatible(this.first, pam)) {
            this.stopCollection = true;
        } else {
            for (int i = 0; i < bands.size(); ++i) {
                PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat = ((PAMDataset.PAMRasterBand)bands.get(i)).getGdalRasterAttributeTable();
                if (rat == null) continue;
                this.collectors.get(i).collect(rat);
            }
        }
    }

    private boolean checkCompatible(PAMDataset first, PAMDataset second) {
        List bands1 = first.getPAMRasterBand();
        List bands2 = second.getPAMRasterBand();
        if (bands1.size() != bands2.size()) {
            LOGGER.warning("Stopping PAM collection, different number of bands found in PAM files");
            return false;
        }
        for (int i = 0; i < bands1.size(); ++i) {
            List fields2;
            PAMDataset.PAMRasterBand band1 = (PAMDataset.PAMRasterBand)bands1.get(i);
            PAMDataset.PAMRasterBand band2 = (PAMDataset.PAMRasterBand)bands2.get(i);
            PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat1 = band1.getGdalRasterAttributeTable();
            PAMDataset.PAMRasterBand.GDALRasterAttributeTable rat2 = band2.getGdalRasterAttributeTable();
            if (rat1 == null && rat2 == null) continue;
            if (rat1 == null || rat2 == null) {
                LOGGER.warning("Stopping PAM collection, RATs found in some files but not in others for band " + i);
                return false;
            }
            List fields1 = rat1.getFieldDefn();
            if (Objects.equals(fields1, fields2 = rat2.getFieldDefn())) continue;
            LOGGER.warning("Stopping PAM collection, different field definitions found in PAM files");
            return false;
        }
        return true;
    }

    @Override
    public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
    }
}

