/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.data.FileServiceInfo;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GranuleRemovalPolicy;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.filter.Filters;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleStoreDecorator;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

class PurgingGranuleStore
extends GranuleStoreDecorator {
    static final Logger LOGGER = Logging.getLogger(PurgingGranuleStore.class);
    private final RasterManager manager;

    public PurgingGranuleStore(GranuleStore delegate, RasterManager manager) {
        super(delegate);
        this.manager = manager;
    }

    @Override
    public int removeGranules(Filter filter, Hints hints) {
        GranuleRemovalPolicy policy = Optional.ofNullable(hints).map(h -> (GranuleRemovalPolicy)h.get((Object)Hints.GRANULE_REMOVAL_POLICY)).orElse(GranuleRemovalPolicy.NONE);
        int removed = 0;
        try {
            if (policy == GranuleRemovalPolicy.NONE) {
                removed = this.delegate.removeGranules(filter, hints);
            } else {
                Map<String, Integer> countsByFilter = this.countGranulesMatching(filter, this.manager);
                if (countsByFilter.isEmpty()) {
                    return 0;
                }
                Map<String, Integer> countsByLocation = this.countGranulesMatchingLocations(countsByFilter.keySet());
                Set<String> removedLocations = this.getRemovedLocations(countsByFilter, countsByLocation);
                boolean deleteData = policy == GranuleRemovalPolicy.ALL;
                Set<String> singleGranules = removedLocations.stream().filter(l -> (Integer)countsByLocation.get(l) == 1).collect(Collectors.toSet());
                Set multiGranules = removedLocations.stream().filter(l -> (Integer)countsByLocation.get(l) > 1).collect(Collectors.toSet());
                this.removeGranuleFiles(deleteData, singleGranules);
                for (String multiGranule : multiGranules) {
                    Filter removedLocationsFilter = this.buildLocationsFilter(this.manager, Collections.singleton(multiGranule));
                    Query q = this.buildQuery();
                    q.setFilter(removedLocationsFilter);
                    q.setMaxFeatures(1);
                    this.manager.getGranuleCatalog().getGranuleDescriptors(q, new FileRemovingGranuleVisitor(deleteData));
                }
                removed = this.delegate.removeGranules(filter);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to perform cleanup", e);
        }
        return removed;
    }

    private void removeGranuleFiles(boolean deleteData, Set<String> singleGranules) throws IOException {
        Filter removedLocationsFilter = this.buildLocationsFilter(this.manager, singleGranules);
        Query q = this.buildQuery();
        q.setFilter(removedLocationsFilter);
        this.manager.getGranuleCatalog().getGranuleDescriptors(q, new FileRemovingGranuleVisitor(deleteData));
    }

    private Query buildQuery() {
        return this.buildQuery(this.manager.getTypeName());
    }

    private Query buildQuery(String typeName) {
        Query q = new Query(typeName);
        q.getHints().put((Object)CatalogConfigurationBeans.COVERAGE_NAME, (Object)this.manager.getName());
        return q;
    }

    private Set<String> getRemovedLocations(Map<String, Integer> countsByFilter, Map<String, Integer> countsByLocation) {
        HashSet<String> result = new HashSet<String>();
        for (String location : countsByFilter.keySet()) {
            int total;
            int matched = countsByFilter.get(location);
            if (matched < (total = countsByLocation.get(location).intValue())) continue;
            result.add(location);
        }
        return result;
    }

    private Filter buildLocationsFilter(RasterManager manager, Set<String> locations) {
        PropertyName locationProperty = this.getLocationProperty(manager);
        List<Filter> filters = locations.stream().map(l -> Utils.FF.equal((Expression)locationProperty, (Expression)Utils.FF.literal(l), false)).collect(Collectors.toList());
        return Filters.or(Utils.FF, filters);
    }

    private Map<String, Integer> countGranulesMatching(Filter filter, RasterManager manager) throws IOException {
        CalcResult result = this.countGranulesMatchingCalc(filter, manager);
        return this.calcToCountMap(result);
    }

    private Map<String, Integer> countGranulesMatchingLocations(Set<String> locations) throws IOException {
        ImageMosaicReader reader = this.manager.getParentReader();
        CalcResult calc = null;
        for (String coverageName : reader.getGridCoverageNames()) {
            RasterManager coverageManager = reader.getRasterManager(coverageName);
            Filter filter = this.buildLocationsFilter(coverageManager, locations);
            CalcResult coverageCalc = this.countGranulesMatchingCalc(filter, coverageManager);
            calc = calc == null ? coverageCalc : calc.merge(coverageCalc);
        }
        return this.calcToCountMap(calc);
    }

    private Map<String, Integer> calcToCountMap(CalcResult result) {
        Map map = result.toMap();
        return map.entrySet().stream().collect(Collectors.toMap(x -> (String)((List)x.getKey()).get(0), x -> (Integer)x.getValue()));
    }

    private CalcResult countGranulesMatchingCalc(Filter filter, RasterManager manager) throws IOException {
        Query q = this.buildQuery(manager.getTypeName());
        q.setFilter(filter);
        SimpleFeatureCollection lc = manager.getGranuleCatalog().getGranules(q);
        List<Expression> groupByExpressions = Arrays.asList(this.getLocationProperty(manager));
        GroupByVisitor groupVisitor = new GroupByVisitor(Aggregate.COUNT, NilExpression.NIL, groupByExpressions, null);
        lc.accepts(groupVisitor, null);
        return groupVisitor.getResult();
    }

    private PropertyName getLocationProperty(RasterManager manager) {
        CatalogConfigurationBean configuration = manager.getConfiguration().getCatalogConfigurationBean();
        String locationAttribute = Optional.ofNullable(configuration.getLocationAttribute()).orElse("location");
        return Utils.FF.property(locationAttribute);
    }

    private class FileRemovingGranuleVisitor
    implements GranuleCatalogVisitor {
        private final boolean mDeleteData;

        public FileRemovingGranuleVisitor(boolean deleteData) {
            this.mDeleteData = deleteData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(GranuleDescriptor granule, SimpleFeature feature) {
            block17: {
                AbstractGridCoverage2DReader reader = null;
                try {
                    reader = granule.getReader();
                    File granuleFile = URLs.urlToFile((URL)granule.getGranuleUrl());
                    if (granuleFile != null) {
                        this.removeFile(new File(granuleFile.getParentFile(), granuleFile.getName() + ".ovr"));
                        List<File> footprintFiles = PurgingGranuleStore.this.manager.getGranuleCatalog().getFootprintFiles(feature);
                        footprintFiles.forEach(this::removeFile);
                    }
                    if (reader instanceof StructuredGridCoverage2DReader) {
                        ((StructuredGridCoverage2DReader)reader).delete(this.mDeleteData);
                    }
                    if (!this.mDeleteData) break block17;
                    ArrayList<File> filesToRemove = new ArrayList<File>();
                    ServiceInfo info = reader.getInfo();
                    if (info instanceof FileServiceInfo) {
                        try (CloseableIterator<FileGroupProvider.FileGroup> it = ((FileServiceInfo)info).getFiles(Query.ALL);){
                            filesToRemove.addAll(this.getFilesToRemove(it));
                        }
                    }
                    if (granuleFile != null) {
                        filesToRemove.add(granuleFile);
                    }
                    reader.dispose();
                    for (File file : filesToRemove) {
                        this.removeFile(file);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to perform cleanup for granule " + granule.getGranuleUrl(), e);
                }
                finally {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
            }
        }

        private void removeFile(File file) {
            if (file.exists()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    LOGGER.warning("Could not remove source file " + file + ": " + e.getMessage());
                }
            }
        }

        private List<File> getFilesToRemove(CloseableIterator<FileGroupProvider.FileGroup> it) {
            ArrayList<File> filesToRemove = new ArrayList<File>();
            while (it.hasNext()) {
                FileGroupProvider.FileGroup group = (FileGroupProvider.FileGroup)it.next();
                filesToRemove.add(group.getMainFile());
                List<File> supportFiles = group.getSupportFiles();
                if (supportFiles == null) continue;
                filesToRemove.addAll(supportFiles);
            }
            return filesToRemove;
        }
    }
}

