/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.core.InitializingReader;
import it.geosolutions.imageio.core.SourceSPIProvider;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import it.geosolutions.jaiext.vectorbin.VectorBinarizeDescriptor;
import it.geosolutions.jaiext.vectorbin.VectorBinarizeRIF;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import org.apache.commons.beanutils.MethodUtils;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.CogGranuleAccessProvider;
import org.geotools.gce.imagemosaic.DefaultGranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleDescriptorModifier;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.jai.Registry;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class GranuleDescriptor {
    private static final Logger LOGGER = Logging.getLogger(GranuleDescriptor.class);
    private static final String AUXFILE_EXT = ".aux.xml";
    public static final Hints EXCLUDE_MOSAIC = new Hints((RenderingHints.Key)Utils.EXCLUDE_MOSAIC, (Object)true);
    public static final double READ_THRESHOLD = Double.parseDouble(System.getProperty("org.geotools.mosaic.read.threshold", "0.001"));
    OverviewsController overviewsController;
    private GeneralBounds granuleEnvelope;
    private AbstractGridFormat format;
    private boolean nativeBandSelection;
    private Hints hints;
    private static PAMParser pamParser;
    ReferencedEnvelope granuleBBOX;
    MultiLevelROI roiProvider;
    URL granuleUrl;
    int maxDecimationFactor = -1;
    final Map<Integer, GranuleOverviewLevelDescriptor> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;
    ImageReaderSpi cachedReaderSPI;
    private SimpleFeature originator;
    PAMDataset pamDataset;
    boolean handleArtifactsFiltering = false;
    boolean filterMe = false;
    ImageInputStreamSpi cachedStreamSPI;
    private MaskOverviewProvider ovrProvider;
    private GranuleAccessProvider granuleAccessProvider;
    private NoDataContainer noData;
    private Double[] scales;
    private Double[] offsets;
    private SampleModel sampleModel;

    public GeneralBounds getGranuleEnvelope() {
        return this.granuleEnvelope;
    }

    public void setGranuleEnvelope(GeneralBounds granuleEnvelope) {
        this.granuleEnvelope = granuleEnvelope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init(BoundingBox granuleBBOX, URL granuleUrl, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, boolean heterogeneousGranules, boolean handleArtifactsFiltering, Hints hints) {
        this.granuleBBOX = ReferencedEnvelope.reference((Bounds)granuleBBOX);
        this.granuleUrl = granuleUrl;
        this.roiProvider = roiProvider;
        this.handleArtifactsFiltering = handleArtifactsFiltering;
        this.hints = new Hints((RenderingHints)hints);
        this.filterMe = handleArtifactsFiltering && roiProvider != null;
        URL input = granuleUrl;
        AbstractGridCoverage2DReader gcReader = null;
        ImageInputStream inStream = null;
        ImageReader imageReader = null;
        try {
            boolean checkAuxiliaryMetadata;
            Object providerHint = Utils.getHintIfAvailable((RenderingHints)hints, (RenderingHints.Key)GranuleAccessProvider.GRANULE_ACCESS_PROVIDER);
            if (providerHint != null) {
                this.granuleAccessProvider = ((GranuleAccessProvider)providerHint).copyProviders();
                this.granuleAccessProvider.setGranuleInput(granuleUrl);
            } else {
                this.granuleAccessProvider = this.getDefaultProvider(input, suggestedFormat, suggestedSPI, suggestedIsSPI, false, hints);
            }
            this.format = this.granuleAccessProvider.getFormat();
            this.nativeBandSelection = this.supportsNativeBandSelection();
            gcReader = this.granuleAccessProvider.getGridCoverageReader();
            this.ovrProvider = this.granuleAccessProvider.getMaskOverviewsProvider();
            if (heterogeneousGranules) {
                this.granuleBBOX = ReferencedEnvelope.reference((Bounds)gcReader.getOriginalEnvelope());
            }
            if (this.granuleAccessProvider instanceof GranuleDescriptorModifier) {
                ((GranuleDescriptorModifier)((Object)this.granuleAccessProvider)).update(this, hints);
            }
            if (this.cachedStreamSPI == null) {
                this.cachedStreamSPI = this.granuleAccessProvider.getInputStreamSpi();
            }
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            if (inStream == null) {
                inStream = this.granuleAccessProvider.getImageInputStream();
            }
            if (this.cachedReaderSPI == null) {
                this.cachedReaderSPI = this.granuleAccessProvider.getImageReaderSpi();
            }
            if (this.cachedReaderSPI == null) {
                throw new IllegalArgumentException("Unable to get a ReaderSPI for the provided input: " + granuleUrl.toString());
            }
            imageReader = this.granuleAccessProvider.getImageReader();
            boolean ignoreMetadata = false;
            if (imageReader instanceof InitializingReader) {
                ignoreMetadata = ((InitializingReader)imageReader).init((RenderingHints)hints);
            }
            imageReader.setInput(inStream, false, ignoreMetadata);
            Rectangle originalDimension = Utils.getDimension(0, imageReader);
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(originalDimension), (Bounds)this.granuleBBOX);
            geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
            this.baseGridToWorld = geMapper.createAffineTransform();
            this.granuleLevels.put(0, new GranuleOverviewLevelDescriptor(1.0, 1.0, originalDimension.width, originalDimension.height));
            if (heterogeneousGranules) {
                GranuleOverviewLevelDescriptor baseOverviewLevelDescriptor = this.granuleLevels.get(0);
                int numberOfOvervies = this.ovrProvider.getNumOverviews();
                AffineTransform2D baseG2W = baseOverviewLevelDescriptor.getGridToWorldTransform();
                int width = baseOverviewLevelDescriptor.getWidth();
                int height = baseOverviewLevelDescriptor.getHeight();
                double resX = AffineTransform2D.getScaleX0((AffineTransform)baseG2W);
                double resY = AffineTransform2D.getScaleY0((AffineTransform)baseG2W);
                double[] highestRes = new double[]{resX, resY};
                double[][] overviewsResolution = this.ovrProvider.getOverviewResolutions(highestRes[0] * (double)width, highestRes[1] * (double)height);
                this.overviewsController = new OverviewsController(highestRes, numberOfOvervies, overviewsResolution);
            }
            if (checkAuxiliaryMetadata = this.checkAuxiliaryMetadata(hints)) {
                this.checkPamDataset();
            }
            this.initFromImageMetadata(imageReader, checkAuxiliaryMetadata);
            return;
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
            if (gcReader != null) {
                try {
                    gcReader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private boolean checkAuxiliaryMetadata(Hints hints) {
        if (hints != null && hints.containsKey((Object)Utils.CHECK_AUXILIARY_METADATA)) {
            return (Boolean)hints.get((Object)Utils.CHECK_AUXILIARY_METADATA);
        }
        return false;
    }

    private boolean supportsNativeBandSelection() {
        try {
            return this.format.getReadParameters().values().stream().anyMatch(p -> p.getDescriptor().getName().equals(AbstractGridFormat.BANDS.getName()));
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private GranuleAccessProvider getDefaultProvider(Object input, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, boolean skipExternalOverviews, Hints hints) throws IOException {
        Hints suggestedObjectHints = new Hints((RenderingHints)hints);
        if (suggestedFormat != null) {
            suggestedObjectHints.put((Object)GranuleAccessProvider.SUGGESTED_FORMAT, (Object)suggestedFormat);
        }
        if (suggestedSPI != null) {
            suggestedObjectHints.put((Object)GranuleAccessProvider.SUGGESTED_READER_SPI, (Object)suggestedSPI);
        }
        if (suggestedIsSPI != null) {
            suggestedObjectHints.put((Object)GranuleAccessProvider.SUGGESTED_STREAM_SPI, (Object)suggestedIsSPI);
        }
        if (skipExternalOverviews) {
            suggestedObjectHints.put((Object)Hints.SKIP_EXTERNAL_OVERVIEWS, (Object)skipExternalOverviews);
        }
        suggestedObjectHints.add((RenderingHints)EXCLUDE_MOSAIC);
        DefaultGranuleAccessProvider provider = new DefaultGranuleAccessProvider(suggestedObjectHints);
        provider.setGranuleInput(input);
        return provider;
    }

    private void initFromImageMetadata(ImageReader reader, boolean readPam) throws IOException {
        int index;
        block6: {
            Object imageIndex;
            index = 0;
            if (this.originator != null && (imageIndex = this.originator.getAttribute("imageindex")) instanceof Integer) {
                index = (Integer)imageIndex;
            }
            try {
                IIOMetadata metadata = reader.getImageMetadata(index);
                if (metadata instanceof CoreCommonImageMetadata) {
                    CoreCommonImageMetadata ccm = (CoreCommonImageMetadata)metadata;
                    double[] noDataArray = null;
                    if (ccm.getNoDataValues() != null) {
                        noDataArray = Arrays.stream(ccm.getNoDataValues()).mapToDouble(d -> d == null ? Double.NaN : d).toArray();
                        this.noData = new NoDataContainer(noDataArray);
                    }
                    this.scales = ccm.getScales();
                    this.offsets = ccm.getOffsets();
                }
                if (readPam && this.pamDataset == null && metadata instanceof TIFFImageMetadata) {
                    TIFFImageMetadata tiffMetadata = (TIFFImageMetadata)metadata;
                    this.pamDataset = AbstractGridCoverage2DReader.getPamDataset((TIFFImageMetadata)tiffMetadata);
                }
            }
            catch (UnsupportedOperationException e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block6;
                LOGGER.log(Level.FINER, "Failed to gather metadata, might not be fatal, some readers do not support it", e);
            }
        }
        this.sampleModel = reader.getImageTypes(index).next().getSampleModel();
    }

    public OverviewsController getOverviewsController() {
        return this.overviewsController;
    }

    private void checkPamDataset() throws IOException {
        File file = URLs.urlToFile((URL)this.granuleUrl);
        String path = file.getCanonicalPath();
        File auxFile = new File(path + AUXFILE_EXT);
        if (auxFile.exists()) {
            if (pamParser == null) {
                try {
                    pamParser = PAMParser.getInstance();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Couldn't initialize PAM parser.", e);
                }
            }
            this.pamDataset = pamParser.parsePAM(auxFile);
        }
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, -1, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, -1, heterogeneousGranules);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, heterogeneousGranules, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules, boolean handleArtifactsFiltering) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, heterogeneousGranules, handleArtifactsFiltering, null);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules, boolean handleArtifactsFiltering, Hints hints) {
        this.maxDecimationFactor = maxDecimationFactor;
        URL rasterGranule = this.extractRasterGranule(hints, granuleLocation, null, false);
        if (rasterGranule == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("File found " + granuleLocation);
        }
        this.originator = null;
        this.init(granuleBBox, rasterGranule, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, heterogeneousGranules, handleArtifactsFiltering, hints);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, AbstractGridFormat suggestedFormat, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, false);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, boolean heterogeneousGranules, Hints hints) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, null, heterogeneousGranules, hints);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, boolean heterogeneousGranules) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, heterogeneousGranules, null);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, AbstractGridFormat suggestedFormat, ImageInputStreamSpi suggestedIsSPI, String locationAttribute, String parentLocation, MultiLevelROI roiProvider) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, roiProvider, false, null);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, MultiLevelROI roiProvider, boolean heterogeneousGranules, Hints hints) {
        String granuleLocation = (String)Utils.getAttribute(feature, locationAttribute);
        ReferencedEnvelope granuleBBox = this.getFeatureBounds(feature);
        PathResolver pathResolver = new PathResolver(pathType, parentLocation);
        URL rasterGranule = this.extractRasterGranule(hints, granuleLocation, pathResolver, true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Proceeding with granule: " + granuleLocation);
        }
        this.originator = feature;
        this.init(granuleBBox, rasterGranule, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, heterogeneousGranules, false, hints);
    }

    private URL extractRasterGranule(Hints hints, String granuleLocation, PathResolver pathResolver, boolean exceptionOnNullGranule) {
        GranuleAccessProvider accessProvider = (GranuleAccessProvider)Utils.getHintIfAvailable((RenderingHints)hints, (RenderingHints.Key)GranuleAccessProvider.GRANULE_ACCESS_PROVIDER);
        URL rasterGranule = null;
        if (accessProvider instanceof CogGranuleAccessProvider) {
            try {
                CogGranuleAccessProvider cap = (CogGranuleAccessProvider)accessProvider;
                CogGranuleAccessProvider copy = (CogGranuleAccessProvider)cap.copyProviders();
                copy.setGranuleInput(granuleLocation);
                rasterGranule = copy.getInputURL();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to set an URL from the provided granuleLocation: " + granuleLocation, e);
                }
                rasterGranule = null;
            }
        } else {
            rasterGranule = pathResolver != null ? pathResolver.resolve(granuleLocation) : URLs.fileToUrl((File)new File(granuleLocation));
        }
        if (rasterGranule == null && exceptionOnNullGranule) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "granuleLocation", granuleLocation));
        }
        return rasterGranule;
    }

    private ReferencedEnvelope getFeatureBounds(SimpleFeature feature) {
        Geometry g = (Geometry)feature.getDefaultGeometry();
        if (g == null) {
            return null;
        }
        CoordinateReferenceSystem crs = feature.getFeatureType().getCoordinateReferenceSystem();
        ReferencedEnvelope granuleBBox = new ReferencedEnvelope(g.getEnvelopeInternal(), crs);
        return granuleBBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GranuleLoadingResult loadRaster(ImageReadParam imageReadParameters, int index, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, RasterLayerRequest request, Hints hints) throws IOException {
        ReferencedEnvelope intersection;
        if (LOGGER.isLoggable(Level.FINER)) {
            String name = Thread.currentThread().getName();
            LOGGER.finer("Thread:" + name + " Loading raster data for granuleDescriptor " + this);
        }
        ImageReadParam readParameters = null;
        double[] virtualNativeResolution = request.getVirtualNativeResolution();
        boolean useFootprint = this.roiProvider != null && request.getFootprintBehavior() != FootprintBehavior.None;
        Geometry inclusionGeometry = useFootprint ? this.roiProvider.getFootprint() : null;
        ReferencedEnvelope bbox = useFootprint ? new ReferencedEnvelope(this.granuleBBOX.intersection(inclusionGeometry.getEnvelopeInternal()), this.granuleBBOX.getCoordinateReferenceSystem()) : this.granuleBBOX;
        boolean doFiltering = false;
        if (this.filterMe && useFootprint) {
            doFiltering = Utils.areaIsDifferent(inclusionGeometry, this.baseGridToWorld, this.granuleBBOX);
        }
        if ((intersection = new ReferencedEnvelope(bbox.intersection(cropBBox), cropBBox.getCoordinateReferenceSystem())).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
            }
            return null;
        }
        if (useFootprint && inclusionGeometry != null && !JTS.toGeometry(cropBBox).intersects(inclusionGeometry)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
            }
            return null;
        }
        ImageInputStream inStream = null;
        ImageReader reader = null;
        boolean cleanupInFinally = request.getReadType() != ReadType.JAI_IMAGEREAD;
        try {
            PlanarImage pi;
            RenderedImage raster;
            int ssy;
            int ssx;
            int imageIndex;
            if (request.isHeterogeneousGranules() && (this.originator == null || this.originator.getAttribute("imageindex") == null)) {
                EnhancedImageReadParam erp;
                readParameters = new EnhancedImageReadParam();
                imageIndex = ReadParamsController.setReadParams(request.spatialRequestHelper.getComputedResolution(), request.getOverviewPolicy(), request.getDecimationPolicy(), readParameters, request.rasterManager, this.overviewsController, virtualNativeResolution);
                if (imageReadParameters instanceof EnhancedImageReadParam && (erp = (EnhancedImageReadParam)imageReadParameters).getBands() != null) {
                    ((EnhancedImageReadParam)readParameters).setBands(erp.getBands());
                }
            } else {
                imageIndex = index;
                readParameters = imageReadParameters;
            }
            int ovrIndex = imageIndex;
            boolean isExternal = this.ovrProvider.isExternalOverview(imageIndex);
            URL granuleURLUpdated = this.granuleUrl;
            if (isExternal) {
                granuleURLUpdated = this.ovrProvider.getOvrURL();
                assert (this.ovrProvider.getExternalOverviewInputStreamSpi() != null) : "no cachedStreamSPI available for external overview!";
                SourceSPIProvider sourceSpiProvider = this.ovrProvider.getSourceSpiProvider().getCompatibleSourceProvider(granuleURLUpdated);
                inStream = sourceSpiProvider.getStream();
                reader = sourceSpiProvider.getReader();
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get s reader for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                    }
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
                boolean ignoreMetadata = false;
                if (reader instanceof InitializingReader) {
                    ignoreMetadata = ((InitializingReader)reader).init((RenderingHints)hints);
                }
                reader.setInput(inStream, false, ignoreMetadata);
                ovrIndex = this.ovrProvider.getOverviewIndex(imageIndex);
            } else {
                ovrIndex = this.ovrProvider.getOverviewIndex(imageIndex);
                assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
                inStream = this.granuleAccessProvider.getImageInputStream();
                if (inStream == null) {
                    GranuleLoadingResult sourceSpiProvider = null;
                    return sourceSpiProvider;
                }
                if (this.cachedReaderSPI == null) {
                    reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
                    if (reader != null) {
                        this.cachedReaderSPI = reader.getOriginatingProvider();
                    }
                } else {
                    reader = this.granuleAccessProvider.getImageReader();
                }
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get a reader for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                    }
                    GranuleLoadingResult sourceSpiProvider = null;
                    return sourceSpiProvider;
                }
            }
            if (reader instanceof InitializingReader) {
                ((InitializingReader)reader).init((RenderingHints)hints);
            }
            reader.setInput(inStream);
            if (MethodUtils.getAccessibleMethod(reader.getClass(), (String)"setRasterLayerRequest", RasterLayerRequest.class) != null) {
                try {
                    MethodUtils.invokeMethod((Object)reader, (String)"setRasterLayerRequest", (Object)request);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error setting raster layer request on reader.", exception);
                }
            }
            GranuleOverviewLevelDescriptor selectedlevel = this.getLevel(ovrIndex, reader, imageIndex, isExternal);
            AffineTransform2D cropGridToWorld = new AffineTransform2D((AffineTransform)selectedlevel.gridToWorldTransformCorner);
            AffineTransform2D cropWorldToGrid = (AffineTransform2D)cropGridToWorld.inverse();
            Rectangle2D r2d = CRS.transform((MathTransform)cropWorldToGrid, (Bounds)intersection).toRectangle2D();
            if (r2d.getWidth() < READ_THRESHOLD || r2d.getHeight() < READ_THRESHOLD) {
                cleanupInFinally = true;
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            Rectangle sourceArea = r2d.getBounds();
            if (selectedlevel.baseToLevelTransform.isIdentity()) {
                sourceArea.grow(2, 2);
            }
            XRectangle2D.intersect((Rectangle2D)sourceArea, (Rectangle2D)selectedlevel.rasterDimensions, (Rectangle2D)sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got empty area for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                }
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Loading level " + imageIndex + " with source region: " + sourceArea + " subsampling: " + readParameters.getSourceXSubsampling() + "," + readParameters.getSourceYSubsampling() + " for granule:" + this.granuleUrl);
            }
            int newSubSamplingFactor = 0;
            String pluginName = this.cachedReaderSPI.getPluginClassName();
            if (pluginName != null && pluginName.equals("it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader") && (newSubSamplingFactor = ImageIOUtilities.getSubSamplingFactor2((int)(ssx = readParameters.getSourceXSubsampling()), (int)(ssy = readParameters.getSourceYSubsampling()))) != 0) {
                if (newSubSamplingFactor > this.maxDecimationFactor && this.maxDecimationFactor != -1) {
                    newSubSamplingFactor = this.maxDecimationFactor;
                }
                readParameters.setSourceSubsampling(newSubSamplingFactor, newSubSamplingFactor, 0, 0);
            }
            readParameters.setSourceRegion(sourceArea);
            boolean expandToRGB = request.getRasterManager().isExpandMe();
            if (expandToRGB && this.getRawColorModel(reader, ovrIndex) instanceof IndexColorModel && readParameters instanceof EnhancedImageReadParam) {
                EnhancedImageReadParam erp = (EnhancedImageReadParam)readParameters;
                erp.setBands(null);
            }
            if (this.nativeBandSelection && readParameters instanceof EnhancedImageReadParam && ((EnhancedImageReadParam)readParameters).getBands() != null && request.getReadType() == ReadType.JAI_IMAGEREAD) {
                int[] bands = ((EnhancedImageReadParam)readParameters).getBands();
                ImageTypeSpecifier selected = ImageIOUtilities.getBandSelectedType((int)bands.length, (SampleModel)this.sampleModel);
                readParameters.setDestinationType(selected);
            }
            try {
                raster = request.getReadType().read(readParameters, ovrIndex, granuleURLUpdated, selectedlevel.rasterDimensions, reader, hints, false);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
                }
                GranuleLoadingResult granuleLoadingResult = null;
                try {
                    if (cleanupInFinally && inStream != null) {
                        inStream.close();
                    }
                }
                finally {
                    if (cleanupInFinally && reader != null) {
                        reader.dispose();
                    }
                }
                return granuleLoadingResult;
            }
            int[] bands = request.getBands();
            if (bands != null && (!this.nativeBandSelection || expandToRGB)) {
                raster = this.selectBands(hints, expandToRGB, raster, bands);
            }
            if (request.isRescalingEnabled()) {
                raster = this.rescaleRaster(request, hints, raster, bands);
            }
            if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1])) {
                raster = this.forceVirtualNativeResolution(raster, request, virtualNativeResolution, selectedlevel, hints);
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            AffineTransform finalRaster2Model = this.setupRaster2Model(selectedlevel, sourceArea, raster);
            if (useFootprint) {
                ROI transformed;
                block118: {
                    try {
                        Rectangle imgBounds = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
                        transformed = this.roiProvider.getTransformedROI(finalRaster2Model.createInverse(), imageIndex, imgBounds, readParameters, request.getReadType());
                        if (transformed instanceof ROIGeometry && ((ROIGeometry)transformed).getAsGeometry().isEmpty()) {
                            GranuleLoadingResult granuleLoadingResult = null;
                            return granuleLoadingResult;
                        }
                        if (transformed != null && !transformed.getBounds().isEmpty()) break block118;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to a problem when managing the ROI");
                        }
                        GranuleLoadingResult granuleLoadingResult = null;
                        return granuleLoadingResult;
                    }
                    catch (java.awt.geom.NoninvertibleTransformException e) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to a problem when managing the ROI");
                        }
                        transformed = null;
                        return transformed;
                    }
                }
                pi = PlanarImage.wrapRenderedImage((RenderedImage)raster);
                if (!transformed.intersects(pi.getBounds())) {
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
                pi.setProperty("ROI", (Object)transformed);
                if (pi instanceof RenderedOp) {
                    PlanarImage theImage = ((RenderedOp)pi).getRendering();
                    theImage.setProperty("ROI", (Object)transformed);
                }
                raster = pi;
            }
            finalRaster2Model.preConcatenate((AffineTransform)mosaicWorldToGrid);
            Interpolation interpolation = request.getInterpolation();
            Rectangle2D finalLayout = ImageUtilities.layoutHelper((RenderedImage)raster, (float)((float)finalRaster2Model.getScaleX()), (float)((float)finalRaster2Model.getScaleY()), (float)((float)finalRaster2Model.getTranslateX()), (float)((float)finalRaster2Model.getTranslateY()), (Interpolation)interpolation);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
                }
                pi = null;
                return pi;
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
            if (XAffineTransform.isIdentity((AffineTransform)finalRaster2Model, (double)1.0E-6)) {
                Object t;
                if (this.noData != null) {
                    t = PlanarImage.wrapRenderedImage((RenderedImage)raster);
                    t.setProperty("GC_NODATA", (Object)this.noData);
                    raster = t;
                }
                t = new GranuleLoadingResult(raster, null, granuleURLUpdated, doFiltering, this.pamDataset, this);
                return t;
            }
            RenderedImage image = this.loadTiled(request, hints, virtualNativeResolution, useFootprint, raster, finalRaster2Model, interpolation, localHints);
            if (image == null) {
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            GranuleLoadingResult granuleLoadingResult = new GranuleLoadingResult(image, null, granuleURLUpdated, doFiltering, this.pamDataset, this);
            return granuleLoadingResult;
        }
        catch (NoninvertibleTransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this + " with request " + request + " Resulting in no granule loaded: Empty result", e);
            }
            GranuleLoadingResult granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        catch (IllegalStateException | TransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this + " with request " + request + " Resulting in no granule loaded: Empty result", e);
            }
            GranuleLoadingResult granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        finally {
            try {
                if (cleanupInFinally && inStream != null) {
                    inStream.close();
                }
            }
            finally {
                if (cleanupInFinally && reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    private RenderedImage loadTiled(RasterLayerRequest request, Hints hints, double[] virtualNativeResolution, boolean useFootprint, RenderedImage raster, AffineTransform finalRaster2Model, Interpolation interpolation, RenderingHints localHints) {
        BorderExtender extender;
        TileScheduler scheduler;
        TileCache cache;
        Dimension tileDimensions = request.getTileDimensions();
        ImageLayout layout = null;
        if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
            layout = new ImageLayout();
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
        } else {
            layout = Utils.getImageLayoutHint((RenderingHints)hints);
        }
        if (layout != null) {
            layout.setTileWidth(Math.min(layout.getTileWidth(null), raster.getWidth()));
            layout.setTileHeight(Math.min(layout.getTileHeight(null), raster.getHeight()));
            localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
        if ((cache = Utils.getTileCacheHint((RenderingHints)hints)) != null) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, cache));
        }
        if ((scheduler = Utils.getTileSchedulerHint((RenderingHints)hints)) != null) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, scheduler));
        }
        if ((extender = Utils.getBorderExtenderHint((RenderingHints)hints)) != null) {
            localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
        } else {
            localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
        }
        ImageWorker iw = new ImageWorker(raster);
        if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1])) {
            localHints.add(new RenderingHints((RenderingHints.Key)ImageWorker.PRESERVE_CHAINED_AFFINES, true));
        }
        iw.setRenderingHints(localHints);
        if (iw.getNoData() == null && this.noData != null) {
            iw.setNoData(this.noData.getAsRange());
        }
        iw.affine(finalRaster2Model, interpolation, request.getBackgroundValues());
        RenderedImage renderedImage = iw.getRenderedImage();
        Object roi = renderedImage.getProperty("ROI");
        if (useFootprint && roi instanceof ROIGeometry && ((ROIGeometry)roi).getAsGeometry().isEmpty() || roi instanceof ROI && ((ROI)roi).getBounds().isEmpty()) {
            return null;
        }
        if (iw.getNoData() != null) {
            PlanarImage t = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
            t.setProperty("GC_NODATA", (Object)new NoDataContainer(iw.getNoData()));
            renderedImage = t;
        } else if (this.noData != null) {
            PlanarImage t = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
            t.setProperty("GC_NODATA", (Object)this.noData);
            renderedImage = t;
        }
        return renderedImage;
    }

    private AffineTransform setupRaster2Model(GranuleOverviewLevelDescriptor selectedlevel, Rectangle sourceArea, RenderedImage raster) {
        double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
        double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
        AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance((double)decimationScaleX, (double)decimationScaleY);
        AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance((double)sourceArea.x, (double)sourceArea.y);
        AffineTransform2D backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
        AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
        finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        if (!XAffineTransform.isIdentity((AffineTransform)backToBaseLevelScaleTransform, (double)1.0E-6)) {
            finalRaster2Model.concatenate((AffineTransform)backToBaseLevelScaleTransform);
        }
        if (!XAffineTransform.isIdentity((AffineTransform)afterDecimationTranslateTranform, (double)1.0E-6)) {
            finalRaster2Model.concatenate(afterDecimationTranslateTranform);
        }
        if (!XAffineTransform.isIdentity((AffineTransform)decimationScaleTranform, (double)1.0E-6)) {
            finalRaster2Model.concatenate(decimationScaleTranform);
        }
        return finalRaster2Model;
    }

    private RenderedImage rescaleRaster(RasterLayerRequest request, Hints hints, RenderedImage raster, int[] bands) {
        if (this.noData != null && request.getReadType() == ReadType.JAI_IMAGEREAD) {
            PlanarImage t = PlanarImage.wrapRenderedImage((RenderedImage)raster);
            t.setProperty("GC_NODATA", (Object)this.noData);
            raster = t;
        }
        raster = this.rescale(raster, hints, bands);
        return raster;
    }

    private RenderedImage selectBands(Hints hints, boolean expandToRGB, RenderedImage raster, int[] bands) {
        ColorModel colorModel;
        if (raster.getColorModel() instanceof IndexColorModel && expandToRGB) {
            raster = new ImageWorker(raster).forceComponentColorModel().getRenderedImage();
        }
        if ((colorModel = (raster = new ImageWorker(raster).retainBands(bands).getRenderedImage()).getColorModel()) == null) {
            ColorModel newColorModel;
            ImageLayout layout = (ImageLayout)hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
            if (layout == null) {
                layout = new ImageLayout();
            }
            if ((newColorModel = ImageIOUtilities.createColorModel((SampleModel)raster.getSampleModel())) != null) {
                layout.setColorModel(newColorModel);
                raster = new ImageWorker(raster).setRenderingHints((RenderingHints)hints).format(raster.getSampleModel().getDataType()).getRenderedImage();
            }
        }
        return raster;
    }

    private RenderedImage rescale(RenderedImage raster, Hints hints, int[] bands) {
        Double[] rescalingScales = this.scales;
        Double[] rescalingOffsets = this.offsets;
        if (bands != null && (this.scales != null || this.offsets != null)) {
            rescalingScales = new Double[bands.length];
            rescalingOffsets = new Double[bands.length];
            int i = 0;
            for (int bandIndex : bands) {
                rescalingScales[i] = this.scales != null ? this.scales[bandIndex] : null;
                rescalingOffsets[i++] = this.offsets != null ? this.offsets[bandIndex] : null;
            }
        }
        raster = ImageUtilities.applyRescaling((Double[])rescalingScales, (Double[])rescalingOffsets, (RenderedImage)raster, (Hints)hints);
        return raster;
    }

    private RenderedImage forceVirtualNativeResolution(RenderedImage raster, RasterLayerRequest request, double[] virtualNativeResolution, GranuleOverviewLevelDescriptor selectedlevel, Hints hints) {
        AffineTransform virtualTransform = XAffineTransform.getScaleInstance((double)(XAffineTransform.getScaleX0((AffineTransform)selectedlevel.gridToWorldTransformCorner) / virtualNativeResolution[0]), (double)(XAffineTransform.getScaleY0((AffineTransform)selectedlevel.gridToWorldTransformCorner) / virtualNativeResolution[1]));
        Dimension tileDimensions = request.getTileDimensions();
        RenderingHints localHints = null;
        if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
            ImageLayout layout = new ImageLayout();
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
            localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        } else {
            ImageLayout originalLayout = Utils.getImageLayoutHint((RenderingHints)hints);
            if (originalLayout != null) {
                ImageLayout localLayout = new ImageLayout();
                localLayout.setTileHeight(originalLayout.getTileHeight(null));
                localLayout.setTileWidth(originalLayout.getTileWidth(null));
                localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, localLayout);
            }
        }
        if (localHints == null) {
            localHints = new RenderingHints(null);
        }
        this.updateLocalHints(hints, localHints);
        localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
        ImageWorker worker = new ImageWorker(raster).setRenderingHints(localHints);
        return worker.affine(virtualTransform, request.getInterpolation(), request.getBackgroundValues()).getRenderedImage();
    }

    private void updateLocalHints(Hints hints, RenderingHints localHints) {
        TileScheduler scheduler;
        TileCache cache = Utils.getTileCacheHint((RenderingHints)hints);
        if (cache != null) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, cache));
        }
        if ((scheduler = Utils.getTileSchedulerHint((RenderingHints)hints)) != null) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, scheduler));
        }
    }

    private ColorModel getRawColorModel(ImageReader reader, int imageIndex) {
        try {
            ImageTypeSpecifier imageType = reader.getRawImageType(imageIndex);
            if (imageType == null) {
                return null;
            }
            ColorModel cm = imageType.getColorModel();
            return cm;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine the native color model of the reader", e);
            return null;
        }
    }

    private GranuleOverviewLevelDescriptor getLevel(int index, ImageReader reader, int imageIndex, boolean external) {
        int indexValue;
        int n = indexValue = external ? imageIndex : index;
        if (reader == null) {
            throw new NullPointerException("Null reader passed to the internal GranuleOverviewLevelDescriptor method");
        }
        Map<Integer, GranuleOverviewLevelDescriptor> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(indexValue)) {
                return this.granuleLevels.get(indexValue);
            }
            try {
                Rectangle levelDimension = Utils.getDimension(index, reader);
                GranuleOverviewLevelDescriptor baseLevel = this.granuleLevels.get(0);
                double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                GranuleOverviewLevelDescriptor newLevel = new GranuleOverviewLevelDescriptor(scaleX, scaleY, levelDimension.width, levelDimension.height);
                this.granuleLevels.put(indexValue, newLevel);
                return newLevel;
            }
            catch (IOException | IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    GranuleOverviewLevelDescriptor getLevel(int index) {
        GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor;
        block15: {
            ImageReader reader = null;
            ImageInputStream inStream = this.cachedStreamSPI.createInputStreamInstance(this.granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            try {
                assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
                if (inStream == null) {
                    throw new IllegalArgumentException("Unable to create an inputstream for the granuleurl:" + (Serializable)(this.granuleUrl != null ? this.granuleUrl : "null"));
                }
                if (this.cachedReaderSPI == null) {
                    reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
                    if (reader != null) {
                        this.cachedReaderSPI = reader.getOriginatingProvider();
                    }
                } else {
                    reader = this.cachedReaderSPI.createReaderInstance();
                }
                if (reader == null) {
                    throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.granuleUrl.toString());
                }
                reader.setInput(inStream, false, false);
                granuleOverviewLevelDescriptor = this.getLevel(index, reader, index, false);
                if (inStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalStateException e) {
                    if (reader != null) {
                        reader.dispose();
                    }
                    throw new IllegalArgumentException(e);
                }
            }
            inStream.close();
        }
        return granuleOverviewLevelDescriptor;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Description of a granuleDescriptor ").append("\n");
        buffer.append("BBOX:\t\t").append(this.granuleBBOX.toString()).append("\n");
        buffer.append("file:\t\t").append(this.granuleUrl).append("\n");
        buffer.append("gridToWorld:\t\t").append(this.baseGridToWorld).append("\n");
        int i = 1;
        for (GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor : this.granuleLevels.values()) {
            int n = ++i;
            ++i;
            buffer.append("Description of level ").append(n).append("\n");
            buffer.append(granuleOverviewLevelDescriptor.toString()).append("\n");
        }
        return buffer.toString();
    }

    public BoundingBox getGranuleBBOX() {
        return this.granuleBBOX;
    }

    public URL getGranuleUrl() {
        return this.granuleUrl;
    }

    public SimpleFeature getOriginator() {
        return this.originator;
    }

    public Geometry getFootprint() {
        if (this.roiProvider == null) {
            return null;
        }
        return this.roiProvider.getFootprint();
    }

    public AbstractGridCoverage2DReader getReader() {
        if (this.granuleAccessProvider instanceof CogGranuleAccessProvider) {
            try {
                return this.granuleAccessProvider.getGridCoverageReader();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to access the reader", e);
            }
        }
        return this.format.getReader((Object)this.granuleUrl, this.hints);
    }

    public MultiLevelROI getRoiProvider() {
        return this.roiProvider;
    }

    public MaskOverviewProvider getMaskOverviewProvider() {
        return this.ovrProvider;
    }

    static {
        try {
            Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new VectorBinarizeDescriptor(), (RenderedImageFactory)new VectorBinarizeRIF(), (String)"org.jaitools.media.jai");
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Error when registering RIF for GranuleDescriptor.", e);
        }
    }

    public static class GranuleLoadingResult {
        RenderedImage loadedImage;
        ROI footprint;
        URL granuleUrl;
        boolean doFiltering;
        PAMDataset pamDataset;
        GranuleDescriptor granuleDescriptor;

        public ROI getFootprint() {
            return this.footprint;
        }

        public RenderedImage getRaster() {
            return this.loadedImage;
        }

        public URL getGranuleUrl() {
            return this.granuleUrl;
        }

        public PAMDataset getPamDataset() {
            return this.pamDataset;
        }

        public void setPamDataset(PAMDataset pamDataset) {
            this.pamDataset = pamDataset;
        }

        public boolean isDoFiltering() {
            return this.doFiltering;
        }

        public GranuleDescriptor getGranuleDescriptor() {
            return this.granuleDescriptor;
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl, boolean doFiltering, PAMDataset pamDataset, GranuleDescriptor granuleDescriptor) {
            this.loadedImage = loadedImage;
            Object roi = loadedImage.getProperty("ROI");
            if (roi instanceof ROI) {
                this.footprint = (ROI)roi;
            }
            this.granuleUrl = granuleUrl;
            this.doFiltering = doFiltering;
            this.pamDataset = pamDataset;
            this.granuleDescriptor = granuleDescriptor;
        }
    }

    class GranuleOverviewLevelDescriptor {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform2D baseToLevelTransform;
        final AffineTransform2D gridToWorldTransformCorner;
        final Rectangle rasterDimensions;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public GranuleOverviewLevelDescriptor(double scaleX, double scaleY, int width, int height) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = new AffineTransform2D(XAffineTransform.getScaleInstance((double)scaleX, (double)scaleY, (double)0.0, (double)0.0));
            AffineTransform gridToWorldTransform_ = new AffineTransform((AffineTransform)this.baseToLevelTransform);
            gridToWorldTransform_.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(GranuleDescriptor.this.baseGridToWorld);
            this.gridToWorldTransformCorner = new AffineTransform2D(gridToWorldTransform_);
            this.width = width;
            this.height = height;
            this.rasterDimensions = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.rasterDimensions.clone();
        }

        public AffineTransform2D getGridToWorldTransform() {
            return this.gridToWorldTransformCorner;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Description of a granuleDescriptor level").append("\n").append("width:\t\t").append(this.width).append("\n").append("height:\t\t").append(this.height).append("\n").append("scaleX:\t\t").append(this.scaleX).append("\n").append("scaleY:\t\t").append(this.scaleY).append("\n").append("baseToLevelTransform:\t\t").append(this.baseToLevelTransform.toString()).append("\n").append("gridToWorldTransform:\t\t").append(this.gridToWorldTransformCorner.toString()).append("\n");
            return buffer.toString();
        }
    }

    static class PathResolver {
        PathType pathType;
        String parentLocation;

        public PathResolver(PathType pathType, String parentLocation) {
            this.pathType = pathType;
            this.parentLocation = parentLocation;
        }

        public URL resolve(String granuleLocation) {
            return this.pathType.resolvePath(this.parentLocation, granuleLocation);
        }
    }
}

