/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.net.URL;
import java.util.logging.Logger;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.geotools.util.logging.Logging;

public class HttpClientBuilder {
    static final Logger log = Logging.getLogger((String)HttpClientBuilder.class.toString());
    private UsernamePasswordCredentials httpcredentials = null;
    private AuthScope authscope = null;
    private Integer backendTimeoutMillis = null;
    private static final HttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private boolean doAuthentication = false;
    private RequestConfig connectionConfig;
    private org.apache.http.impl.client.HttpClientBuilder clientBuilder;

    public HttpClientBuilder() {
    }

    public HttpClientBuilder(URL url, Integer backendTimeout, String httpUsername, String httpPassword, URL proxyUrl, int concurrency) {
        if (url != null) {
            this.setHttpCredentials(httpUsername, httpPassword, new AuthScope(url.getHost(), url.getPort()));
        } else {
            this.setHttpCredentials(httpUsername, httpPassword, AuthScope.ANY);
        }
        this.setBackendTimeout(backendTimeout);
        this.setConnectionConfig(RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setSocketTimeout(this.backendTimeoutMillis.intValue()).setConnectTimeout(this.backendTimeoutMillis.intValue()).setRedirectsEnabled(true).build());
        this.clientBuilder = org.apache.http.impl.client.HttpClientBuilder.create();
        this.clientBuilder.useSystemProperties();
        this.clientBuilder.setConnectionManager(connectionManager);
        this.clientBuilder.setMaxConnTotal(concurrency);
    }

    public void setHttpCredentials(String username, String password, URL authscopeUrl) {
        AuthScope authscope = new AuthScope(authscopeUrl.getHost(), authscopeUrl.getPort());
        this.setHttpCredentials(username, password, authscope);
    }

    public void setHttpCredentials(String username, String password, AuthScope authscope) {
        if (username != null && authscope != null) {
            this.authscope = authscope;
            this.httpcredentials = new UsernamePasswordCredentials(username, password);
            this.doAuthentication = true;
        } else {
            this.authscope = null;
            this.httpcredentials = null;
            this.doAuthentication = false;
        }
    }

    public void setBackendTimeout(int backendTimeout) {
        this.backendTimeoutMillis = backendTimeout * 1000;
    }

    public HttpClient buildClient() {
        if (this.authscope != null && this.httpcredentials != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(this.authscope, (Credentials)this.httpcredentials);
            this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        CloseableHttpClient httpClient = this.clientBuilder.build();
        return httpClient;
    }

    public boolean isDoAuthentication() {
        return this.doAuthentication;
    }

    public UsernamePasswordCredentials getHttpcredentials() {
        return this.httpcredentials;
    }

    public void setHttpcredentials(UsernamePasswordCredentials httpcredentials) {
        this.httpcredentials = httpcredentials;
    }

    public RequestConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public void setConnectionConfig(RequestConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }
}

