/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public class NullBlobStore
implements BlobStore {
    private Map<String, Properties> metadataMap = new HashMap<String, Properties>();
    private static final Logger LOGGER = Logging.getLogger((String)NullBlobStore.class.getName());

    @Override
    public boolean delete(String layerName) throws StorageException {
        return true;
    }

    @Override
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        return true;
    }

    @Override
    public boolean delete(TileObject obj) throws StorageException {
        return true;
    }

    @Override
    public boolean delete(TileRange obj) throws StorageException {
        return true;
    }

    @Override
    public boolean get(TileObject obj) throws StorageException {
        return false;
    }

    @Override
    public void put(TileObject obj) throws StorageException {
    }

    @Override
    public void clear() throws StorageException {
    }

    @Override
    public synchronized void destroy() {
        this.metadataMap.clear();
    }

    @Override
    public void addListener(BlobStoreListener listener) {
    }

    @Override
    public boolean removeListener(BlobStoreListener listener) {
        return true;
    }

    @Override
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        return true;
    }

    @Override
    public synchronized String getLayerMetadata(String layerName, String key) {
        Properties properties = this.metadataMap.get(layerName);
        if (properties != null) {
            try {
                return URLDecoder.decode((String)properties.get(key), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    @Override
    public synchronized void putLayerMetadata(String layerName, String key, String value) {
        Properties props = this.metadataMap.get(layerName);
        if (props != null) {
            try {
                props.setProperty(key, URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else {
            props = new Properties();
            try {
                props.setProperty(key, URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            this.metadataMap.put(layerName, props);
        }
    }

    @Override
    public boolean layerExists(String layerName) {
        return false;
    }

    @Override
    public boolean deleteByParametersId(String layerName, String parametersId) throws StorageException {
        return true;
    }

    @Override
    public Set<Map<String, String>> getParameters(String layerName) {
        return Collections.emptySet();
    }

    @Override
    public Map<String, Optional<Map<String, String>>> getParametersMapping(String layerName) {
        return Collections.emptyMap();
    }
}

