/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.geowebcache.storage.blobstore.file.TileFileVisitor;
import org.geowebcache.storage.blobstore.file.XYZFilePathFilter;
import org.geowebcache.util.FileUtils;

public class XYZFilePathGenerator
implements FilePathGenerator {
    private static Logger log = Logging.getLogger((String)XYZFilePathGenerator.class.getName());
    protected final TileLayerDispatcher layers;
    protected final String cacheRoot;
    private final Convention convention;

    public XYZFilePathGenerator(String cacheRoot, TileLayerDispatcher layers, Convention convention) {
        this.cacheRoot = cacheRoot;
        this.layers = layers;
        this.convention = convention;
    }

    @Override
    public File tilePath(TileObject tile, MimeType mimeType) throws GeoWebCacheException {
        long[] tileIndex = tile.getXYZ();
        long x = tileIndex[0];
        int z = (int)tileIndex[2];
        long y = this.getY(tile.getLayerName(), tile.getGridSetId(), x, tileIndex[1], z);
        StringBuilder path = new StringBuilder(256);
        String fileExtension = mimeType.getFileExtension();
        path.append(this.cacheRoot);
        path.append(File.separatorChar);
        FilePathUtils.appendFiltered(tile.getLayerName(), path);
        path.append(File.separatorChar);
        String parametersId = tile.getParametersId();
        Map<String, String> parameters = tile.getParameters();
        if (parametersId == null && parameters != null && !parameters.isEmpty()) {
            parametersId = ParametersUtils.getId(parameters);
            tile.setParametersId(parametersId);
        }
        FilePathUtils.appendFiltered(tile.getGridSetId(), path);
        if (parametersId != null) {
            path.append("_");
            path.append(parametersId);
        }
        path.append(File.separatorChar);
        path.append(z);
        path.append(File.separatorChar);
        path.append(x);
        path.append(File.separatorChar);
        path.append(y);
        path.append('.');
        path.append(fileExtension);
        File tileFile = new File(path.toString());
        return tileFile;
    }

    protected long getY(String layerName, String gridSetId, long x, long y, int z) throws GeoWebCacheException {
        if (this.convention == Convention.TMS) {
            return y;
        }
        TileLayer tileLayer = this.layers.getTileLayer(layerName);
        GridSubset subset = tileLayer.getGridSubset(gridSetId);
        GridSet gridSet = subset.getGridSet();
        long tilesHigh = gridSet.getGrid(z).getNumTilesHigh();
        return tilesHigh - y - 1L;
    }

    @Override
    public void visitRange(File layerDirectory, TileRange range, TileFileVisitor visitor) throws StorageException {
        XYZFilePathFilter tileFinder = new XYZFilePathFilter(range, this);
        for (File gridsetParamDir : FileUtils.listFilesNullSafe(layerDirectory, tileFinder)) {
            visitor.preVisitDirectory(gridsetParamDir);
            for (File zoomDir : FileUtils.listFilesNullSafe(gridsetParamDir, tileFinder)) {
                int z = Integer.parseInt(zoomDir.getName());
                visitor.preVisitDirectory(zoomDir);
                for (File xDir : FileUtils.listFilesNullSafe(zoomDir, tileFinder)) {
                    long x = Long.parseLong(xDir.getName());
                    visitor.preVisitDirectory(xDir);
                    for (File tile : FileUtils.listFilesNullSafe(xDir, tileFinder)) {
                        long y = Long.parseLong(FilenameUtils.getBaseName((String)tile.getName()));
                        visitor.visitFile(tile, x, y, z);
                    }
                    visitor.postVisitDirectory(xDir);
                }
                visitor.postVisitDirectory(zoomDir);
            }
            visitor.postVisitDirectory(gridsetParamDir);
        }
    }

    public static enum Convention {
        TMS,
        XYZ;

    }
}

