/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.geowebcache.util.FileUtils;
import org.geowebcache.util.SuppressFBWarnings;

public class LayerMetadataStore {
    private static Logger log = Logging.getLogger((String)LayerMetadataStore.class.getName());
    public static final String PROPERTY_METADATA_MAX_RW_ATTEMPTS = "gwc.layermetadatastore.maxRWAttempts";
    public static final String PROPERTY_WAIT_AFTER_RENAME = "gwc.layermetadatastore.waitAfterRename";
    static final int METADATA_MAX_RW_ATTEMPTS = Integer.parseInt(System.getProperty("gwc.layermetadatastore.maxRWAttempts", "50"));
    static final int WAIT_AFTER_RENAME = Integer.parseInt(System.getProperty("gwc.layermetadatastore.waitAfterRename", "50"));
    static final String METADATA_GZIP_EXTENSION = ".gz";
    private final String path;
    private File tmp;
    private static final int lockShardSize = 32;
    private ReadWriteLock[] locks = (ReadWriteLock[])IntStream.range(0, 32).mapToObj(i -> new ReentrantReadWriteLock()).toArray(ReadWriteLock[]::new);

    public LayerMetadataStore(String rootPath, File tmpPath) {
        this.path = rootPath;
        this.tmp = tmpPath;
    }

    public Map<String, String> getLayerMetadata(String layerName) throws IOException {
        Properties props = this.loadLayerMetadata(layerName);
        HashMap<String, String> map = new HashMap<String, String>();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put((String)k, (String)v)));
        return map;
    }

    public String getEntry(String layerName, String key) throws IOException {
        Properties metadata = this.loadLayerMetadata(layerName);
        String value = metadata.getProperty(key);
        return value == null ? value : LayerMetadataStore.urlDecUtf8(value);
    }

    public void putEntry(String layerName, String key, String value) throws IOException {
        String encodedValue;
        boolean doUpdate;
        File metadataFile = this.resolveMetadataFile(layerName);
        Properties metadata = this.loadLayerMetadata(metadataFile);
        if (null == value) {
            doUpdate = metadata.containsKey(key);
            encodedValue = null;
        } else {
            encodedValue = URLEncoder.encode(value, "UTF-8");
            boolean bl = doUpdate = !Objects.equals(encodedValue, metadata.getProperty(key));
        }
        if (doUpdate) {
            this.writeMetadataOptimisticLock(key, encodedValue, metadataFile);
        }
    }

    private File getLayerPath(String layerName) {
        String prefix = this.path + File.separator + FilePathUtils.filteredLayerName(layerName);
        File layerPath = new File(prefix);
        return layerPath;
    }

    private static String urlDecUtf8(String value) {
        try {
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private int resolveLockBucket(File file) {
        long consistentFileNameHash = Hashing.farmHashFingerprint64().hashString((CharSequence)file.getAbsolutePath(), StandardCharsets.UTF_8).asLong();
        int bucket = Hashing.consistentHash((long)consistentFileNameHash, (int)this.locks.length);
        return bucket;
    }

    private ReadWriteLock getLock(File file) {
        return this.locks[this.resolveLockBucket(file)];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    private void writeMetadataOptimisticLock(String key, String value, File metadataFile) throws IOException {
        ReadWriteLock rwLock = this.getLock(metadataFile);
        int maxAttempts = METADATA_MAX_RW_ATTEMPTS;
        Properties metadata = this.loadLayerMetadata(metadataFile);
        long lastModified = metadataFile.lastModified();
        log.fine("Start attempt to add key (key: " + key + ")");
        rwLock.writeLock().lock();
        try {
            this.createParentIfNeeded(metadataFile);
            int attempt = 0;
            for (attempt = 0; attempt < maxAttempts; ++attempt) {
                if (lastModified == metadataFile.lastModified()) {
                    metadata = this.loadLayerMetadata(metadataFile);
                    metadata.compute(key, (BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, oldValue) -> value));
                    File tempFile = this.writeTempMetadataFile(metadata);
                    if (FileUtils.renameFile(tempFile, metadataFile)) {
                        Thread.sleep(WAIT_AFTER_RENAME);
                        Properties metadataAfterRename = this.loadLayerMetadata(metadataFile);
                        if (metadata.equals(metadataAfterRename)) {
                            log.fine("Temporary file renamed successfully (metadata: " + metadata.toString() + ")");
                            return;
                        }
                        log.fine("Renamed file content differs from expected saved content.\nCurrent:" + metadataAfterRename.toString() + "\nExpected: " + metadata.toString());
                        ++attempt;
                    } else {
                        log.info("Reattempting to write metadata file, because an error while renaming metadata file " + metadataFile.getPath());
                        ++attempt;
                    }
                    tempFile.delete();
                } else {
                    log.fine("Reattempting to write metadata file since timestamp changed (metadata: " + metadata.toString() + ")");
                }
                if (metadata.isEmpty()) {
                    log.fine("Reattempting to write metadata file with empty metadata: " + metadata.toString() + ")");
                }
                metadata = this.loadLayerMetadata(metadataFile);
                lastModified = metadataFile.lastModified();
            }
            if (maxAttempts != attempt) return;
            log.fine("Optimistic write reaches max number of attempts (" + maxAttempts + ")");
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    private File writeTempMetadataFile(Properties metadata) {
        this.tmp.mkdirs();
        try {
            File metadataFile = File.createTempFile("tmp", METADATA_GZIP_EXTENSION, this.tmp);
            return this.writeMetadataFile(metadata, metadataFile);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Cannot create temporary file");
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeMetadataFile(Properties metadata, File metadataFile) throws IOException {
        ReadWriteLock lock = this.getLock(metadataFile);
        lock.writeLock().lock();
        try {
            this.createParentIfNeeded(metadataFile);
            String comments = "auto generated file, do not edit by hand";
            try (Writer writer = this.compressingWriter(metadataFile);){
                metadata.store(writer, comments);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return metadataFile;
    }

    private void createParentIfNeeded(File metadataFile) {
        File parentDir = metadataFile.getParentFile();
        if (!(parentDir.exists() || parentDir.mkdirs() || parentDir.exists())) {
            throw new IllegalStateException("Unable to create parent directory " + parentDir.getAbsolutePath());
        }
    }

    private Writer compressingWriter(File file) throws FileNotFoundException, IOException {
        return new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8);
    }

    private Properties getUncompressedLayerMetadata(File metadataFile) throws IOException {
        return this.loadLayerMetadata(metadataFile, this::open);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadLayerMetadata(File metadataFile, Function<File, InputStream> isProvider) throws IOException {
        int maxAttempts = METADATA_MAX_RW_ATTEMPTS;
        long lastModified = metadataFile.lastModified();
        ReadWriteLock lock = this.getLock(metadataFile);
        lock.readLock().lock();
        try {
            int attempt = 0;
            for (attempt = 0; metadataFile.exists() && attempt < maxAttempts; ++attempt) {
                try {
                    Properties props;
                    InputStream in;
                    block15: {
                        in = isProvider.apply(metadataFile);
                        props = new Properties();
                        props.load(in);
                        long currentModDate = metadataFile.lastModified();
                        if (lastModified != currentModDate) break block15;
                        Properties properties = props;
                        if (in == null) return properties;
                        in.close();
                        return properties;
                    }
                    try {
                        log.fine("Reattempting to read metadata file since timestamp changed (metadata: " + props.toString() + ")");
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (maxAttempts != attempt) return new Properties();
            log.fine("Optimistic read reaches max number of attempts (" + maxAttempts + ")");
            return new Properties();
        }
        finally {
            lock.readLock().unlock();
        }
    }

    private InputStream openCompressed(File file) {
        try {
            return new GZIPInputStream(this.open(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream open(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Properties loadLayerMetadata(File metadataFile) throws IOException {
        return this.loadLayerMetadata(metadataFile, this::openCompressed);
    }

    private Properties loadLayerMetadata(String layerName) throws IOException {
        File metadataFile = this.resolveMetadataFile(layerName);
        return this.loadLayerMetadata(metadataFile);
    }

    private String getMetadataFilename() {
        return this.getLegacyMetadataFilename() + METADATA_GZIP_EXTENSION;
    }

    private String getLegacyMetadataFilename() {
        return "metadata.properties";
    }

    private File resolveMetadataFile(String layerName) {
        File layerPath = this.getLayerPath(layerName);
        File metadataFile = new File(layerPath, this.getMetadataFilename());
        if (!metadataFile.exists()) {
            metadataFile = this.tryUpgradeLegacyMetadataFile(layerPath, metadataFile);
        }
        return metadataFile;
    }

    /*
     * Loose catch block
     */
    private File tryUpgradeLegacyMetadataFile(File layerPath, File newMetadataFile) {
        File oldMetadataFile = new File(layerPath, this.getLegacyMetadataFilename());
        if (newMetadataFile.equals(oldMetadataFile)) {
            throw new IllegalArgumentException();
        }
        if (!oldMetadataFile.exists()) {
            return newMetadataFile;
        }
        ReadWriteLock newFileLock = this.getLock(newMetadataFile);
        ReadWriteLock oldFileLock = this.getLock(oldMetadataFile);
        newFileLock.writeLock().lock();
        try {
            File file;
            oldFileLock.writeLock().lock();
            try {
                if (!oldMetadataFile.exists()) {
                    File file2 = newMetadataFile;
                    return file2;
                }
                log.info("Upgrading legacy layer medatada file " + oldMetadataFile);
                Properties oldProperties = this.getUncompressedLayerMetadata(oldMetadataFile);
                File compressedNewFile = this.writeMetadataFile(oldProperties, newMetadataFile);
                oldMetadataFile.delete();
                file = compressedNewFile;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Upgrading metadata.properties - Failure creating new compressed file or deleting uncompressed one " + newMetadataFile.getPath() + "-" + e.getMessage());
                throw new UncheckedIOException(e);
            }
            finally {
                oldFileLock.writeLock().unlock();
            }
            return file;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            newFileLock.writeLock().unlock();
        }
    }
}

